/*
	MapFileParser.h
	This class provides functions for parsing map files
	5-15-01
*/

#ifndef __MAPFILEPARSER__
#define __MAPFILEPARSER__

//#ifndef HASHINCLUDED
//#define  HASHTABLE_NOASSERTIFCLASH			// Prevent the hashtable from asserting if we have duplicates
//#define  HASHINCLUDED
#include <core/StringHashTable.h>
//#endif

#include "Max.h"
#include "TypeData.h"
#include "PropTagParser.h"

class PropList;

class MapFileParser: public PropTagParser
{
protected:
	Lst::StringHashTable<TypeDesc>      scriptDB;	// Script information database
													//		This includes all datatypes
public:
	MapFileParser();
	~MapFileParser();

	bool      ParseMapFile(char* Filename,bool bProgBar=false);
	bool      ParseTagDBFile();
	TypeDesc* AddType(CStr Name,CStr ScriptFile,DataType type);
	void      DeleteType(CStr Name);

	CStr      ParseScriptDesc(CStr Filename,CStr Keyword);					// Extracts the AutoDuck script function description tag

	inline    Lst::StringHashTable<TypeDesc>* GetScriptDB()  { return &scriptDB; }
};

#endif
