/*
	PieceBrowser.h
	Maintains a catalog of pieces to use and place to build up the level
*/

#ifndef __PIECEBROWSER__
#define __PIECEBROWSER__

#include "max.h"
#include "istdplug.h"
#include "iparamb2.h"
#include "iparamm2.h"
#include "simpobj.h"
#include "../misc/llist.h"
#include "NSPiece.h"
#include "notify.h"

#define vPIECEBROWSER_CLASS_ID  Class_ID(0x6bf17060, 0x619a7b4c)
#define PBLOCK_REF              0
#define PATH_SIZE               1024

class MultiList;
class PartPreviewDlg;

enum RendererType
{
	RENDERER_OPENGL,
	RENDERER_DIRECT3D,
};

class PieceBrowserObj: public GeomObject
{
	friend class PieceBrowserObjDlgProc;

	RendererType            rendererType;			// The current renderer type that the preview window should use
	PieceBrowserObjDlgProc* dlgProc;
	//PartPreviewDlg*         previewDlg;
	bool                    bPieceLoaded;
	bool                    bPreviewInitialized;	// True if the global PartPreviewDlg has been initialized for this specific object
	char Path[PATH_SIZE];

	void ReadConfig();
	void WriteConfig();
	bool SavePiece(char* Filename);
	void StoreComponent();
	void RetrieveComponent(CStr value="");
	bool CreateGLWindow();

	Point3 GetMinVerts(Mesh& mesh);
	Point3 GetMaxVerts(Mesh& mesh);

	// Callback for populating multilist with .nsp files
	static void AddNSPFile(char* filename, void* data);

	void NotifyPreCollapse(INode* node, IDerivedObject* derObj,int index);
	void NotifyPostCollapse(INode* node, Object* uobj, IDerivedObject* derObj,int index);

public:
	NSPiece        piece;		// This is the original mesh loaded out of the file w/o any changes
	Mesh           mesh;		// This is the actual (scaled) mesh that gets used
	MtlBase*       curmtl;		// This is the material that will get automatically assigned
	IObjParam*     ip;
	IParamBlock2*  pblock;
	ULONG          nodeHandle;
	MultiList*     mlist;
	LinkList<CStr> partList;
	MtlBaseLib*    amtlLib;
	INode*         curnode;
	bool		   bInCreation;	// The object is in the middle of being created (CreateMouseProc)	
	Matrix3        m_Rot;		// Internal rotation of mesh representation in NSPiece

	PieceBrowserObj();
	~PieceBrowserObj();

	TCHAR*		GetObjectName() { return _T("PieceBrowserObj"); }
	void		DeleteThis() { delete this; }
	Class_ID	ClassID() { return vPIECEBROWSER_CLASS_ID; }
	void		GetClassName(TSTR& s) { s = _T("PieceBrowserObj"); }
	void        InitNodeName(TSTR& s) { s = _T(piece.pieceName); }
	
	void        RefAdded(RefMakerHandle rm);

	RefTargetHandle Clone(RemapDir &remap);
	RefResult NotifyRefChanged(Interval        changeInt,
		                       RefTargetHandle hTarget,
							   PartID&         partID,
							   RefMessage      message)  {  return REF_SUCCEED; }

	int NumRefs() { return 1; }
	RefTargetHandle GetReference(int i) { return pblock; }
	
	void SetReference(int i, RefTargetHandle rtarg)
	{
		pblock = (IParamBlock2*)rtarg;
	}

	// Make pblock public
	int NumParamBlocks() { return 1; }
	IParamBlock2* GetParamBlock(int i) { return pblock; }
	IParamBlock2* GetParamBlockByID(BlockID id)
	{
		if (pblock->ID() == id)
			return pblock;

		return NULL;
	}

	CreateMouseCallBack* GetCreateMouseCallBack();

	void BeginEditParams(IObjParam *ip, ULONG flags, Animatable* prev);
	void EndEditParams(IObjParam *ip, ULONG flags, Animatable* next);

	void FreeCaches();

	// Obj Space
	void GetLocalBoundBox(TimeValue t, INode* node, ViewExp *vpt, Box3 &box);

	// World Space
	void GetWorldBoundBox(TimeValue t, INode* node, ViewExp *vpt, Box3 &box);

	int  Display(TimeValue t,INode *node, ViewExp *vpt, int flags);

	int HitTest(TimeValue t,
		        INode     *node,
				int       type,
				int       crossing,
				int       flags,
				IPoint2   *p,
				ViewExp   *vpt);

	ObjectState Eval(TimeValue t);

	// Screen FX objects can convert themselves to triObjects in representation of a quad
	int CanConvertToType(Class_ID obtype);
	Object* ConvertToType(TimeValue t, Class_ID obtype);

	// This method is required for all renderable objects
	Mesh* GetRenderMesh(TimeValue t, INode *inode, View& view, BOOL& needDelete);

	// Implementations of required methods for mesh deformation
	int    IsDeformable()                   { return TRUE;                }
	int    NumPoints()                      { return mesh.numVerts;       }
	Point3 GetPoint(int i)                  { return mesh.verts[i];       }
	void   SetPoint(int i, const Point3& p) { mesh.verts[i] = p;          }
	void   PointsWereChanged()              { mesh.InvalidateGeomCache(); }

	void   Deform(Deformer *defProc, int useSel=0);
	void   GetDeformBBox(TimeValue t, Box3& box, Matrix3 *tm=NULL,BOOL useSel=FALSE );

	// From BaseObject
	BOOL HasUVW() { return TRUE; }

	// From SimpleObject
	void BuildMesh(TimeValue t);
	//Object *BuildPolyBox (TimeValue t);
	BOOL OKtoDisplay(TimeValue t)                   { return TRUE; }

	////
	void GetWidthHeightLength(Mesh& mesh, float& width, float& height, float& length);
	bool LoadPiece(NSPiece* ldmesh, char* Filename);
	void ScaleMesh(Mesh& modmesh, float width, float height, float length);

	void UpdateRotation();

	HWND GetHWND();

	bool SaveMtlLib(char* filename);

	// From ReferenceMaker
	IOResult Load(ILoad* iload);
	IOResult Save(ISave* isave);

	int IsMappable() { return TRUE; }

	void ApplyUVWMap(int type, 
		             float utile, 
					 float vtile,
					 float wtile,
					 int uflip, 
					 int vflip,
					 int wflip, 
					 int cap, 
					 const Matrix3& tm,
					 int channel=1);

	inline bool GetLoadStatus() { return bPieceLoaded; }
	inline RendererType GetRendererType() { return rendererType; }
};

class PieceBrowserObjClassDesc : public ClassDesc2
{
public:
	int 	     IsPublic(void) 			{ return TRUE; }
	void*        Create(BOOL loading=FALSE) { return new PieceBrowserObj; }
	const TCHAR* ClassName(void)		    { return "PieceBrowserObj"; }
	SClass_ID    SuperClassID(void)		    { return GEOMOBJECT_CLASS_ID; }
	Class_ID     ClassID(void)				{ return vPIECEBROWSER_CLASS_ID; }
	const TCHAR* Category(void)		        { return "NExt Objects"; }

	const TCHAR* InternalName()             { return _T("PieceBrowserObj"); }
	HINSTANCE    HInstance()                { return hInstance; }
};

#endif
