/*
	DisplayDevice.h
	Maintains display adapter information
	aml - 11-21-02
*/

#ifndef __DISPLAYDEVICE__
#define __DISPLAYDEVICE__

#include <windows.h>
#include <d3dx8.h>
#include "../misc/llist.h"
#include "D3DMesh.h"

struct DisplayDevice
{
	HMONITOR                  hMonitor;				// The monitor attached to this display device
	LPDIRECT3DDEVICE8         device;				// The Direct3D interface for this display device
	D3DCAPS8                  caps;					// Capabilities of this display device
	D3DADAPTER_IDENTIFIER8    ident;				// Display Adapter identity info
	D3DDISPLAYMODE            mode;					// Display mode the adapter is currently in
	D3DPRESENT_PARAMETERS	  d3dpp;				// Present parameters for this display
	LPDIRECT3DTEXTURE8        texDefault;			// Default texture to use on pieces with no materials
	int                       id;					// Order of enumeration

	LinkList<VertexBuffer>    vertBuffers;			// Vertex buffers uploaded to this device
	int                       nVertBuffers;			// Number of vertex buffers
	LinkList<IndexBuffer>     indexBuffers;			// Index buffers uploaded to this device
	int                       nIndexBuffers;		// Number of index buffers
	LinkList<Texture>         textures;				// The textures uploaded to this device

	bool                      bHardwareVBuffers;	// True if adaptor supports hardware vert buffers

	D3DXMATRIX				  matWorld;				// World matrix on this device currently
	D3DXMATRIX			      matView;				// View (LookAt) matrix on this device currently
	D3DXMATRIX				  matProj;				// Projection matrix on this device currently

	DisplayDevice();
	~DisplayDevice();

	// Methods
	Link<IndexBuffer>*  AddIndexBuffer(int size);
	void                RemoveIndexBuffer(Link<IndexBuffer>* iBuffer);
	bool                AssignIndexData(Link<IndexBuffer>* ibuffer, D3DFace* faces, int nFaces);

	Link<VertexBuffer>* AddVertBuffer(int size);
	void                RemoveVertBuffer(Link<VertexBuffer>* vBuffer);
	bool                AssignVertData(Link<VertexBuffer>* vbuffer, D3DVert* verts, int nVerts);

	Link<Texture>*      AddTexture(const char* filename);
	void                SetMatrices();

	void				FreeTextures();
	void                FreeVertBuffers();
	void				FreeIndexBuffers();
	void				FreeAll();
};

#endif
