/*
	Mesh structure supported by Direct3D Renderer
	aml - 11-20-02
*/

#include "D3DMesh.h"

BufferGroup::BufferGroup()
{
	verts  = NULL;
	faces  = NULL;
	nVerts = 0;
	nFaces = 0;
	vbuf   = NULL;
	ibuf   = NULL;
}

BufferGroup::~BufferGroup()
{
	if (verts)
		delete [] verts;

	if (faces)
		delete [] faces;
}

void BufferGroup::AllocVerts(int num)
{
	nVerts = num;
	verts  = new D3DVert[num];
}

void BufferGroup::AllocFaces(int num)
{
	nFaces = num;
	faces  = new D3DFace[num];
}

void D3DMesh::Init()
{
	nVerts   = 0;
	nFaces   = 0;
	verts    = NULL;
	faces    = NULL;
	vBuffer  = NULL;
	iBuffer  = NULL;
	textures = NULL;
	texFaces = NULL;
	texgroup = NULL;
}

D3DMesh::D3DMesh()
{
	Init();
}

D3DMesh::~D3DMesh()
{
	if (verts)
		delete [] verts;

	if (faces)
		delete [] faces;

	if (vBuffer)
		delete [] vBuffer;

	if (iBuffer)
		delete [] iBuffer;

	if (textures)
		delete [] textures;

	if (texFaces)
		delete [] texFaces;

	if (texgroup)
		delete [] texgroup;
}

void D3DMesh::AllocVerts(int num)
{
	nVerts = num;
	verts  = new D3DVert[num];
}

void D3DMesh::AllocFaces(int num)
{
	nFaces   = num;
	faces    = new D3DFace[num];
	texFaces = new TexFace[num];
}

void D3DMesh::AllocRefs(int nDisp)
{
	if (vBuffer)
		delete [] vBuffer;

	vBuffer = new Link<VertexBuffer>*[nDisp];
	ZeroMemory(vBuffer, sizeof(Link<VertexBuffer>*) * nDisp);

	iBuffer = new Link<IndexBuffer>*[nDisp];
	ZeroMemory(iBuffer, sizeof(Link<IndexBuffer>*) * nDisp);

	for(int i = 0; i < nTextures; i++)
		textures[i].AllocTextureRefs(nDisp);
}

void D3DMesh::AllocTextures(int nTex)
{
	nTextures = nTex;
	textures = new MeshTexture[nTextures];
}

int D3DMesh::CountTextureFaces(int id)
{
	int count = 0;

	for(int i = 0; i < nFaces; i++)
	{
		if (texFaces[i].tex == id)
			count++;
	}

	return count;
}

// Build buffers constructs vert and index lists on a
// per texture basis.  When rendered we draw all the geometry
// at once for any given texture
void D3DMesh::BuildBuffers()
{
	if (texgroup)
		delete [] texgroup;

	texgroup = new BufferGroup[nTextures];

	for(int curTex = 0; curTex < nTextures; curTex++)
	{
		int texFaceCount = CountTextureFaces(curTex);
		texgroup[curTex].AllocFaces(texFaceCount);
		texgroup[curTex].AllocVerts(texFaceCount * 3);

		int curface = 0;
		for(int j = 0; j < nFaces; j++)
		{
			if (texFaces[j].tex == curTex)
			{
				texgroup[curTex].verts[curface * 3 + 0] = verts[texFaces[j].f[0]];
				texgroup[curTex].verts[curface * 3 + 1] = verts[texFaces[j].f[1]];
				texgroup[curTex].verts[curface * 3 + 2] = verts[texFaces[j].f[2]];

				texgroup[curTex].faces[curface].f[0] = curface * 3 + 0;
				texgroup[curTex].faces[curface].f[1] = curface * 3 + 1;
				texgroup[curTex].faces[curface].f[2] = curface * 3 + 2;
				
				curface++;
			}
		}
	}
}
