/*
	Overlap.cpp
	A Utility plugin that checks for overlapping objects in a scene
*/

#include "Next.h"
#include "Overlap.h"
#include "../Resource.h"
#include "../misc/maxutil.h"
#include "IUtilityPanel.h"

extern HINSTANCE  hInstance;
extern Interface* gInterface;
extern GUP*       gpGUP;

static OverlapActionCB       overlapActionCB;
static OverlapActionCB*      overlapAccel=NULL;
static OverlapTool*	s_overlap_tool = NULL;

// action table
static ActionDescription s_overlap_actions[] = {

	ID_OVERLAP_OPEN,
	IDS_OVERLAPTOOL_DESC,
    IDS_OVERLAPTOOL_DESC,
    IDS_OVERLAPTOOL_ACTIONS,
};

bool RegOverlapActionAccelerators();
void UnRegOverlapActionAccelerators();

const ActionTableId overlap_actions           = vOVERLAPTOOL_SHORTCUT_ID;
const ActionContextId overlap_actions_context = vOVERLAPTOOL_SHORTCUT_ID;

static OverlapToolClassDesc theOverlapToolDesc;
ClassDesc2* GetOverlapToolDesc() { return &theOverlapToolDesc; }

static DWORD WINAPI ProgressFunc(LPVOID arg) 
{
    return(0);
}

OverlapTool::OverlapTool()
{
	s_overlap_tool = this;

	nodeTolerance = 0;
	objectTolerance = 0;
}

OverlapTool::~OverlapTool()
{
	s_overlap_tool = NULL;
}

void OverlapTool::BeginEditParams(Interface *ip,IUtil *iu)
{
	this->ip=ip;
	this->iu=iu;

	hRollup = ip->AddRollupPage(hInstance, MAKEINTRESOURCE(IDD_OVERLAP), DlgProc, "NeverSoft Overlap Tool",(LPARAM)this);

	ISpinnerControl *spinner;
	ICustEdit* edit;
	
	spinner = SetupFloatSpinner( hRollup, IDC_NODE_TOLERANCE_SPINNER, IDC_NODE_TOLERANCE, 0.0f, 1000.0f, 1.0f, 0.1f );
	spinner = SetupFloatSpinner( hRollup, IDC_OBJECT_TOLERANCE_SPINNER, IDC_OBJECT_TOLERANCE, 0.0f, 100.0f, 1.0f, 0.1f );

	char buf[256];	
	CStr appDir=ip->GetDir(APP_PLUGCFG_DIR);
	appDir+="\\NxPrefs.ini";	

	edit = GetICustEdit( GetDlgItem( hRollup, IDC_NODE_TOLERANCE ));
	GetPrivateProfileString("Overlap","NodeTolerance","10.0",buf,255,(char*)appDir);
	edit->SetText( buf );
	ReleaseICustEdit( edit );

	edit = GetICustEdit( GetDlgItem( hRollup, IDC_OBJECT_TOLERANCE ));
	GetPrivateProfileString("Overlap","ObjectTolerance","10.0",buf,255,(char*)appDir);
	edit->SetText( buf );
	ReleaseICustEdit( edit );
}

bool already_in_set( INodeTab& nodes, INode* node )
{
	int i;

	for( i = 0; i < nodes.Count(); i++ )
	{
		if( nodes[i] == node )
		{
			return true;
		}
	}

	return false;
}
void OverlapTool::Begin( void )
{
	INodeTab allNodes, overlapping_nodes1, overlapping_nodes2, overlapping_nodes_all;
	INode* node1, *node2;
	int i, j;
		
	GetAllNodes(allNodes);
	
	ip->RemoveNamedSelSet(CStr("OVERLAPPING - 1"));
	ip->RemoveNamedSelSet(CStr("OVERLAPPING - 2"));
	ip->RemoveNamedSelSet(CStr("OVERLAPPING - ALL"));	
	for( i = 0; i < allNodes.Count(); i++ )
	{
		node1 = allNodes[i];
		for( j = i + 1; j < allNodes.Count(); j++ )
		{
			node2 = allNodes[j];
			if( Overlapping( node1, node2, objectTolerance, nodeTolerance ))
			{
				if(	( !already_in_set( overlapping_nodes1, node1 )) &&
					( !already_in_set( overlapping_nodes2, node1 )))
				{
					overlapping_nodes1.Append( 1, &node1 );
				}
				if(	( !already_in_set( overlapping_nodes1, node2 )) &&
					( !already_in_set( overlapping_nodes2, node2 )))
				{
					overlapping_nodes2.Append( 1, &node2 );
				}

				if(	!already_in_set( overlapping_nodes_all, node1 ))
				{
					overlapping_nodes_all.Append( 1, &node1 );
				}
				if(	!already_in_set( overlapping_nodes_all, node2 ))
				{
					overlapping_nodes_all.Append( 1, &node2 );
				}
				
			}
		}
	}

	if( overlapping_nodes1.Count() > 0 )
	{		
		ip->AddNewNamedSelSet(overlapping_nodes1, CStr("OVERLAPPING - 1"));
	}
	if( overlapping_nodes2.Count() > 0 )
	{		
		ip->AddNewNamedSelSet(overlapping_nodes2, CStr("OVERLAPPING - 2"));
	}
	if( overlapping_nodes_all.Count() > 0 )
	{		
		ip->AddNewNamedSelSet(overlapping_nodes_all, CStr("OVERLAPPING - ALL"));
	}
}

void OverlapTool::EndEditParams(Interface *ip,IUtil *iu)
{
	ip->DeleteRollupPage(hRollup);
}

int OverlapTool::DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static OverlapTool* pthis = NULL;

	switch(msg)
	{
	case WM_INITDIALOG:
		pthis = (OverlapTool*)lParam;
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_CHECK_OVERLAPS:
			ICustEdit* edit;
			
			edit = GetICustEdit( GetDlgItem( pthis->hRollup, IDC_NODE_TOLERANCE ));
			pthis->nodeTolerance = edit->GetFloat();
			ReleaseICustEdit( edit );

			edit = GetICustEdit( GetDlgItem( pthis->hRollup, IDC_OBJECT_TOLERANCE ));
			pthis->objectTolerance = edit->GetFloat();
			ReleaseICustEdit( edit );

			char buf[256];
			CStr appDir=GetCOREInterface()->GetDir(APP_PLUGCFG_DIR);
			appDir+="\\NxPrefs.ini";

			sprintf(buf, "%f", pthis->nodeTolerance);
			WritePrivateProfileString("Overlap","NodeTolerance",buf,appDir);

			sprintf(buf, "%f", pthis->objectTolerance);
			WritePrivateProfileString("Overlap","ObjectTolerance",buf,appDir);

			pthis->nodeTolerance *= 12.0f;	// convert to inches
			pthis->objectTolerance /= 100.0f;;	// conver to pct

			pthis->Begin();
			return TRUE;		
		}
	}

	return FALSE;
}

BOOL OverlapActionCB::ExecuteAction(int id)
{
	IUtilityPanel* iutil = (IUtilityPanel*)GetCOREInterface(IUTIL_FO_INTERFACE);
	
	assert(iutil);
	iutil->OpenUtility(&theOverlapToolDesc);
	
	return TRUE;
}

ActionTable* GetOverlapActions( void )
{
    TSTR name = _T("Neversoft Overlap Tool");
    HACCEL hAccel = LoadAccelerators(hInstance,
                                     MAKEINTRESOURCE(IDR_OVERLAP_ACCELERATOR));
    int numOps = sizeof(s_overlap_actions) / sizeof(s_overlap_actions[0]);
    ActionTable* pTab;
    pTab = new ActionTable( overlap_actions, overlap_actions_context, name, hAccel, numOps,
                             s_overlap_actions, hInstance);
    GetCOREInterface()->GetActionManager()->RegisterActionContext( overlap_actions_context, name.data());

    return pTab;
}

bool RegOverlapActionAccelerators()
{
	overlapAccel=new OverlapActionCB;

	if (!GetCOREInterface()->GetActionManager()->ActivateActionTable(overlapAccel, overlap_actions))
	{
		MessageBox(NULL,"ActionTable Failed to instantiate","Overlap Tool",MB_OK);
		return false;
	}

	return true;
}

void UnRegOverlapActionAccelerators()
{
	delete overlapAccel;
	overlapAccel=NULL;
}
