/*
	My MDir function from wav2vag
	This creates all required directories for a given string.
	For instance passing in c:\blah\dir2\mydir\thisthing in the situation where say only
	the blah directory exists, directories dir2, mydir, and thisthing will be created

	aml
*/

#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <io.h>
#include <process.h>
#include <sys/stat.h>
#include <string.h>

// Convert Slashes
void ConvSlash(char* path)
{
	int len = strlen(path);

	for(int i=0;i<len;i++)
	{
		if (path[i]=='/')
			path[i]='\\';
	}
}

// Makes directories passed in as string hierarchy
void MDir(char* path)
{
	char curpath[1024];
	char curdir[1024];
	char drive[80];

	char dirs[1024];
	strcpy(dirs,path);

	ConvSlash(dirs);

	_getcwd(curpath,1023);
	_splitpath(dirs,drive,NULL,NULL,NULL);
	strcat(drive,"\\");
	_chdir(drive);
	
	char* pos;
	char* dpos=dirs;

	while((pos=strstr(dpos,"\\"))!=0)
	{
		char* cpos = dpos;
		int   i    = 0;

		while(cpos!=pos)
		{
			curdir[i++]=*cpos;
			cpos++;
		}

		curdir[i]=0;

		// Make dir
		if (strstr(curdir,":")==0)
		{
			_mkdir(curdir);
			_chdir(curdir);
		}

		dpos = pos+1;
	}

	// Make final dir (dpos)
	_mkdir(dpos);
	_chdir(curpath);
}
