// NExtMat.h: Neversoft Extensions Material
//
//////////////////////////////////////////////////////////////////////

#ifndef __MATERIAL_NEXTMAT_H__
#define __MATERIAL_NEXTMAT_H__

#include "../export/export.h"

#define NEXT_MATERIAL_CLASS_ID	Class_ID(0x44ca6965, 0x58126eba)
#define FOUR_PARAM_BLOCKS

//#define vNUM_TERRAIN_TYPES 43
#define vNUM_TERRAIN_TYPES 60

enum
{
	vBASE_OPAQUE_MATERIAL_DRAW_ID					= 0,	
	vBASE_ORDERED_TRANSPARENT_MATERIAL_DRAW_ID		= 1000,	
};

typedef enum
{
	vBLEND_MODE_DIFFUSE,				// ( 0 - 0 ) * 0 + Src
	vBLEND_MODE_ADD,					// ( Src - 0 ) * Src + Dst
	vBLEND_MODE_ADD_FIXED,				// ( Src - 0 ) * Fixed + Dst
	vBLEND_MODE_SUBTRACT,				// ( 0 - Src ) * Src + Dst
	vBLEND_MODE_SUB_FIXED,				// ( 0 - Src ) * Fixed + Dst
	vBLEND_MODE_BLEND,					// ( Src - Dst ) * Src + Dst	
	vBLEND_MODE_BLEND_FIXED,			// ( Src - Dst ) * Fixed + Dst	
	vBLEND_MODE_MODULATE,				// ( Dst - 0 ) * Src + 0
	vBLEND_MODE_MODULATE_FIXED,			// ( Dst - 0 ) * Fixed + 0	
	vBLEND_MODE_BRIGHTEN,				// ( Dst - 0 ) * Src + Dst
	vBLEND_MODE_BRIGHTEN_FIXED,			// ( Dst - 0 ) * Fixed + Dst	
	vBLEND_MODE_GLOSS_MAP,				// Src/Dst/Fixed are ignored in implementation
	vBLEND_MODE_BLEND_PREVIOUS_MASK,	// ( Src - Dst ) * Dst + Dst
	vBLEND_MODE_BLEND_INVERSE_PREVIOUS_MASK,	// ( Dst - Src ) * Dst + Src

	vNUM_BLEND_MODES
} BlendModes; 

enum
{
	vPARAM_COLOR_SRC,
	vPARAM_COLOR_DST,
	vPARAM_COLOR_ZERO,
	vPARAM_COLOR_RESERVED,
	vPARAM_COLOR_FIXED = vPARAM_COLOR_ZERO,
};

typedef enum
{
	TEX_FORCE_32_BIT		= 0x0002,
	TEX_CHANGE_TRANS_COLOR	= 0x0004,
} TextureForceModes;

enum CutoffFunc
{
	CUTOFF_FUNC_NO_UPDATE,
	CUTOFF_FUNC_UPDATE_FRAMEBUFFER,
};


class INExtMaterial
{
public:
	virtual bool    ColorEnabled( int pass ) = 0;
	virtual Color	GetColor( int pass ) = 0;
	virtual Texmap *GetTexmap( int pass ) = 0;
	virtual int		GetBlendMode( int pass ) = 0;
	virtual int		GetFixedValue( int pass ) = 0;
	virtual int		GetNumPasses( void ) = 0;
	virtual bool	IsOneSided( void ) = 0;
	virtual bool    IsTwoSided( void ) = 0;
	virtual bool	IsInvisible( void ) = 0;
	virtual bool	IsTransparent( void )= 0;
	virtual bool	IsFrontFacing( void ) = 0;
	virtual bool	IsDecal( void ) = 0;
	virtual bool	IsSorted( void ) = 0;
	virtual bool	IsWater( void ) = 0;
	virtual bool    IsGrassified( void ) = 0;
	virtual float   GetGrassHeight( void ) = 0;
	virtual int     GetGrassLayers( void ) = 0;

	virtual	float	GetEnvTileU( int pass ) = 0;
	virtual	float	GetEnvTileV( int pass ) = 0;

	virtual float	GetUVel( int pass ) = 0;
	virtual float	GetVVel( int pass ) = 0;
	virtual float	GetUAmplitude( int pass ) = 0;
	virtual float	GetVAmplitude( int pass ) = 0;
	virtual float	GetUPhase( int pass ) = 0;
	virtual float	GetVPhase( int pass ) = 0;
	virtual float	GetUFrequency( int pass ) = 0;
	virtual float	GetVFrequency( int pass ) = 0;
	virtual bool	UVWibbleDataEnabled( int pass ) = 0;
	
	virtual int		GetMappingMode( int pass ) = 0;
	virtual BOOL    MapEnabled( int i ) = 0;
	virtual BOOL    PassEnabled( int pass ) = 0;
	virtual BOOL	PassEnabledInNetGames( int pass ) = 0;
	virtual BOOL    GetColorLocked( int pass ) = 0;
//	virtual BOOL    GetUnlit( int pass ) = 0;

	virtual BOOL	VertexAlphaEnabled( int pass ) = 0;
	
	virtual int	VCWibbleNumSequences( void ) = 0;
	virtual int	VCWibbleNumKeyframes( int sequence ) = 0;
	virtual WibbleKeyframe	VCWibbleKeyFrame( int sequence, int keyframe ) = 0;

	virtual	AColor	GetAmbientColor( int pass ) = 0;
	virtual	AColor	GetDiffuseColor( int pass ) = 0;
	virtual	AColor	GetSpecularColor( int pass ) = 0;
	virtual	int		GetNumSurfacePropertySets( void ) = 0;

	virtual int		   GetTerrainType( void ) = 0;
	virtual float	   GetDrawOrderId( void ) = 0;
	virtual	int		   GetBasePass( void ) = 0;
	virtual int		   GetAlphaCutoff( void ) = 0;
	virtual CutoffFunc GetCutoffFunc( void ) = 0;
	virtual CStr       GetName( void ) = 0;

	virtual Color   GetSpecularColor() = 0;		// Specular color for material as a whole
	virtual float   GetSpecularPower() = 0;
	virtual BOOL    GetUseSpecular() = 0;

	static	char*	GetTerrainName( int type );	
};

#endif // __SHAREDBL_MATERIAL_H__
