#ifndef __FUNCENTER__
#define __FUNCENTER__

#include <winsock2.h>
#include <windows.h>
#include <stdio.h>
#include "../../DebugLink/DebugLink.h"

// The SymbolTrace app will add an appropriate FUNC_ENTER macro to ALL functions in the project
// The implementation of the macro here ensures that the last executed function can be
// examined by the GetPluginState app

#define FUNCENTER2(name, file, line)    \
	{								    \
		DebugState ds;				    \
		strcpy(ds.lastFunction, name);	\
		strcpy(ds.lastFile, file);		\
		ds.lastLine = line;				\
		PostDebugState(&ds);			\
	}

#define FUNCENTER1(name, file, line)                      \
	{								                      \
		char buf[1024];                                   \
		sprintf(buf, "%s(%i): %s\n", file, line, name);   \
		OutputDebugString(buf);                           \
		FUNCENTER2(name, file, line);                     \
	}

#ifdef DUMP_STACK_TO_CONSOLE
#define FUNC_ENTER(name) FUNCENTER1(name, __FILE__, __LINE__)
#else
#define FUNC_ENTER(name) FUNCENTER2(name, __FILE__, __LINE__)
#endif

#endif
