#ifndef __EXPORT_STRIP_STRIP_H__
#define __EXPORT_STRIP_STRIP_H__

#include <Export/Export.h>

#define	vSTRIP_ERROR	-1

enum
{
	mEDGE_A	=	0x0001,
	mEDGE_B =	0x0002,
	mEDGE_C =	0x0004,
	mVERTEX_A = 0x0008,
	mVERTEX_B = 0x0010,
	mVERTEX_C = 0x0020
};

class NxStripVert
{
public:
	int		m_ADC;
	int		m_Index;
};

class NxMesh
{
public:
	enum
	{
		vMAX_FACES = 5000
	};

	enum
	{
		// v2: Added MinFaceFlags
		vVERSION_NUMBER = 0x0002,
	};

	NxMesh( unsigned long mat_checksum );	
	~NxMesh( void );
	
	unsigned long	m_MatChecksum;
	int				m_NumStripVerts;
	NxStripVert*	m_VertStrip;
	int				m_Topology[vMAX_FACES][3];
	int				m_NumFaces;	
	NxObject*		m_Object;
};

// Interface to the stripper object
class INxStripper
{
public:
	virtual	void	Reset( void ) = 0;
	virtual void	SetObject( NxObject* object ) = 0;
	virtual	void	AddFace( NxFace* face ) = 0;	
	virtual bool	Stripify( void ) = 0;
	virtual	void	GetMeshList( Tab< NxMesh * > &mesh_list ) = 0;
};

INxStripper*	GetNxStripper( void );

#endif	// __EXPORT_STRIP_STRIP_H__