/*
	SkelExporter.cpp
	Skeleton Exporter
	1-17-01
*/

#include "SkelExporter.h"
#include "UI/OkToAll.h"
#include <io.h>
#include <process.h>
#include <Misc/Util.h>

#define  WRITE_ACCESS     0x02

SkeletonExporter::SkeletonExporter(HWND hwnd,Interface* ip)
{
	this->ip=ip;
	errHwnd=hwnd;
	skeleton=NULL;
}

SkeletonExporter::~SkeletonExporter()
{
	if (skeleton)
		delete skeleton;
}

bool SkeletonExporter::Export(char* Filename, bool bIgnoreLeaves)
{
	FILE* fp=fopen(Filename,"wb");

	if (!fp)
	{
		// Check the file attributes to see if the .qn is read-only
		if (_access(Filename,WRITE_ACCESS)!=0)
		{
			char message[256];
			int result;
			
			sprintf( message, "You are about to save over a Read-Only file, %s, perhaps you should check-out the file first", Filename );
			result = MessageBoxAll( gInterface->GetMAXHWnd(), message, "Read-only Warning", MB_CHECKOUT_UNLOCK );
			if( result == IDWRITABLE )
			{
				// break the lock, if necessary
				SetFileAttributes( Filename, FILE_ATTRIBUTE_NORMAL );
			}
			else if( result == IDCHECKOUT )
			{
				char *args[4];
				int process_result;

				args[0] = "p4";
				args[1] = "edit";
				args[2] = Filename;
				args[3] = NULL;
				//process_result = spawnvp( _P_WAIT, args[0], args );
				process_result = ExecuteCommand( args );
				if (_access(Filename,WRITE_ACCESS)!=0)
				{
					MessageBox(NULL,"An error occurred while trying to check the file out. Perhaps someone else has it checked out already?","Export Skeleton",MB_ICONSTOP|MB_OK);
					return false;
				}
			}
			else
			{
				return false;
			}
		}
		else
		{
			char ErrorMsg[256];
			sprintf(ErrorMsg,"Unable to save file.  Check file attributes.\nPath: %s",Filename);
			MessageBox(NULL,ErrorMsg,"ScriptExport Error",MB_ICONSTOP|MB_OK);
			return false;
		}

		fp=fopen(Filename,"wb");
		if( !fp )
		{
			return false;
		}
	}

	int numNodes=ip->GetSelNodeCount();

	if (numNodes<1)
		return false;

	skeleton=new CSkeletonData(ip->GetSelNode(0), bIgnoreLeaves);

	skeleton->WriteSKEFormat(fp);
	fclose(fp);

	return true;
}

