#include "SFP.h"
#include "../Material/NExtMat.h"
#include "../Texture/NExtTexture.h"
#include "stdmat.h"
#include "../PropEdit/ParseFuncs.h"

bool GetSFPEffect(INode* node,CStr& str)
{
	CStr buf;
	node->GetUserPropBuffer(buf);

	int curpos = 0;
	int bareq = 0, poseq = 0;

	if (buf.Length() == 0)
		return false;

	while(curpos < buf.Length())
	{
		int pos = Instr(buf,"SFP_Effect",curpos);

		if (pos == -1)
			return false;

		bareq = Instr(buf,"|",pos);
		poseq = Instr(buf,"=",pos);

		if (poseq == -1)
			return false;

		if (bareq > poseq)
			break;
			
		curpos = bareq + 1;
	}

	poseq++;
	char cbuf[1024];
	str = GetRemainLineExact(buf,&poseq);
	strcpy(cbuf,str);
	StripToken(cbuf);

	str = cbuf;
	return true;
}

// Retrieves the emit script name for the autogenerated SFP script for this node
/*
CStr GetEmitScript(INode* node)
{
	Mtl* mtl = node->GetMtl();

	if (!mtl)
		return CStr("");

	if (mtl->ClassID() != NEXT_MATERIAL_CLASS_ID)
		return CStr("");

	CStr type;

	if (!node->GetUserPropString("SFP_Effect",type))
		return CStr("");

	INExtMaterial* nxMtl = dynamic_cast<INExtMaterial*>(mtl);

	// Get first pass texture name
	Texmap* tmap = nxMtl->GetTexmap(0);

	// Only bitmap textures, abort if proceedural
	if (tmap->ClassID() != Class_ID(BMTEX_CLASS_ID,0) &&
		tmap->ClassID() != NEXT_TEXTURE_CLASS_ID)
		return CStr("");
	
	BitmapTex* bmtmap = (BitmapTex*)tmap;
	CStr texName = ExtractFile(bmtmap->GetMapName());

	return ReplaceStr(CStr("Emit_")+texName+CStr("_")+type," ","_");
}
*/
