/*
	QNEditor.cpp
	Cutscene QN display dialog
	6-10-03  aml
*/

#include "CutsceneExportDlg.h"
#include "QNEditor.h"
#include "resource.h"
#include "../PropEdit/RTFEditor.h"

extern Interface* gInterface;

class QNEditorAddCallback: public HitByNameDlgCallback
{
	QNEditor *pQNEditor;

public:
	QNEditorAddCallback(QNEditor* pQNEditor) { this->pQNEditor = pQNEditor; }

	TCHAR *dialogTitle()	{ return _T("Select node to add to cutscene QN"); }
	TCHAR *buttonText() 	{ return _T("Add"); }
	BOOL singleSelect()		{ return FALSE; }
	BOOL useFilter()		{ return TRUE; }
	int filter(INode *node)	{ return TRUE; }
	BOOL useProc()			{ return TRUE; }
	
	void proc(INodeTab &nodeTab) 
	{ 
		if (pQNEditor) 
			pQNEditor->AddNodes(nodeTab);
	}

	BOOL doCustomHilite()	{ return FALSE; }
	BOOL doHilite(INode *node)	{ return FALSE; }
	BOOL showHiddenAndFrozen()	{ return FALSE; }
};

QNEditor::QNEditor(HINSTANCE hInstance, HWND hwndParent, CutsceneExportDlg* pCutsceneDlg) :
	ModalDlgWindow(hInstance, MAKEINTRESOURCE(IDD_QNEDITOR), hwndParent)
{
	pRTFEditor = NULL;
	this->pCutsceneDlg = pCutsceneDlg;
	pNodeList = pCutsceneDlg->GetQNNodeList();
}

QNEditor::~QNEditor()
{
	if (pRTFEditor)
		delete pRTFEditor;
}

void QNEditor::InitNodeList()
{
	SendDlgItemMessage(hwnd, IDC_NODELIST, LB_RESETCONTENT, 0, 0);

	// Add any current QN nodes from the cutscene exporter to the QN node list
	Link<INode*>* link = pNodeList->GetHead();
	int idx;

	while(link)
	{
		idx = SendDlgItemMessage(hwnd, IDC_NODELIST, LB_ADDSTRING, 0, (LPARAM)(char*)link->data->GetName());
		SendDlgItemMessage(hwnd, IDC_NODELIST, LB_SETITEMDATA, (WPARAM)idx, (LPARAM)link);

		link = link->next;
	}
}

void QNEditor::InitQNList()
{
	LinkList<Cutscene>* pCutsceneList = pCutsceneDlg->GetCutsceneDB();
	Link<Cutscene>* link = pCutsceneList->GetHead();
	int idx;

	SendDlgItemMessage(hwnd, IDC_CSLIST, CB_RESETCONTENT, 0, 0);

	while(link)
	{
		idx = SendDlgItemMessage(hwnd, IDC_CSLIST, CB_ADDSTRING, 0, (LPARAM)(char*)link->data.name);
		SendDlgItemMessage(hwnd, IDC_CSLIST, CB_SETITEMDATA, (WPARAM)idx, (LPARAM)link);

		link = link->next;
	}

	SendDlgItemMessage(hwnd, IDC_CSLIST, CB_SETCURSEL, (WPARAM)0, 0);
}

BOOL QNEditor::DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	if (LOWORD(wParam) == IDC_QNEDITOR)
		if (pRTFEditor->ProcMessage(hwnd,msg,wParam,lParam))
			return TRUE;

	switch(msg)
	{
	case WM_INITDIALOG:
		if (pRTFEditor)
			delete pRTFEditor;

		pRTFEditor = new RTFEditor(hInstance, GetDlgItem(hwnd, IDC_QNEDITOR));

		InitNodeList();
		InitQNList();
		UpdateQNView();
		return TRUE;

	case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
			case IDC_ADD:
				AddNodes();
				return TRUE;

			case IDC_REMOVE:
				RemoveNodes();
				return TRUE;

			case IDC_DONE:
				EndDialog(hwnd, 0);
				return TRUE;

			case IDC_CSLIST:
				{
					switch(HIWORD(wParam))
					{
					case CBN_SELCHANGE:
						UpdateQNView();
						return TRUE;
					}
				}
				return FALSE;
			}
		}
		break;

	case WM_CLOSE:
		EndDialog(hwnd, 0);
		return TRUE;
	}

	return FALSE;
}

void QNEditor::AddNodes()
{
	QNEditorAddCallback* pAddCallback = new QNEditorAddCallback(this);
	gInterface->DoHitByNameDialog(pAddCallback);
	delete pAddCallback;
}

void QNEditor::AddNodes(INodeTab& nodeList)
{
	int nNodes = nodeList.Count();

	for(int i = 0; i < nNodes; i++)
	{
		// Ensure that this node doesn't already exist within the list
		if (!pNodeList->Find(&nodeList[i]))
			pNodeList->Add(&nodeList[i]);
	}

	InitNodeList();
	UpdateQNView();
}

void QNEditor::RemoveNodes()
{
	// Remove all the selected nodes
	int  nSelItems = SendDlgItemMessage(hwnd, IDC_NODELIST, LB_GETSELCOUNT, 0, 0);
	int  selItem;

	while(nSelItems > 0)
	{
		SendDlgItemMessage(hwnd, IDC_NODELIST, LB_GETSELITEMS, (WPARAM)1, (LPARAM)&selItem);
		
		Link<INode*>* link = (Link<INode*>*)SendDlgItemMessage(hwnd, IDC_NODELIST, LB_GETITEMDATA, (WPARAM)selItem, 0);
		pNodeList->Remove(link);

		SendDlgItemMessage(hwnd, IDC_NODELIST, LB_DELETESTRING, (WPARAM)selItem, 0);
		nSelItems = SendDlgItemMessage(hwnd, IDC_NODELIST, LB_GETSELCOUNT, 0, 0);
	}

	UpdateQNView();
}

void QNEditor::UpdateQNView()
{
	int idx = SendDlgItemMessage(hwnd, IDC_CSLIST, CB_GETCURSEL, 0, 0);

	if (idx == -1)
		return;

	Link<Cutscene>* link = (Link<Cutscene>*)SendDlgItemMessage(hwnd, IDC_CSLIST, CB_GETITEMDATA, (WPARAM)idx, 0);

	CStr buffer = pCutsceneDlg->GenerateScript(&link->data);
	pRTFEditor->SetText(buffer);
}
