#include <Export/CamExporter.h>
#include <next.h>
#include <Export/Export.h>
#include <Export/ExportUI.h>
#include <Export/ExportOptions.h>
#include <Export/SceneExport.h>
#include <Export/ModelExport.h>
#include <Export/SkinExport.h>
#include <Export/CamExporter.h>
#include <Export/CutsceneExportDlg.h>
#include <Export/AnimOptionsDlg.h>
#include <MaxIcon.h>

#define TBITEM(type, pIcon, cmd) \
		ToolButtonItem(type,pIcon,GetCUIFrameMgr()->GetImageSize(),GetCUIFrameMgr()->GetImageSize(),GetCUIFrameMgr()->GetButtonWidth(),GetCUIFrameMgr()->GetButtonHeight(),cmd,0)
#define TBMACRO(md) \
		ToolMacroItem(0, GetCUIFrameMgr()->GetButtonHeight(), md)
#define NumElements(array) (sizeof(array) / sizeof(array[0]))

// Here a large value is used so it won't conflict with the IDs used
// by MAX.  If the ProcessMessage() method of the handler returns FALSE
// MAX will use the default CUI toolbar processing and this could invoke
// a MAX command unintentionally.  Note that this is only the case if
// it returns FALSE.
#define ID_TB_QUICKVIEW		    20000
#define ID_TB_RESETRELOAD	    20001
#define ID_TB_QUICKEXPORT	    20002
#define ID_TB_SCRIPTEXPORT	    20003
#define ID_TB_OPTIONS		    20004
#define ID_TB_CAMEXPORT         20005	// aml
#define ID_TB_QUICKUPDATE   	20006
#define ID_TB_EXPORTNOTEX       20007	// aml  Export scene without exporting textures
#define ID_TB_QUICKEXPORTNOTEX  20008
#define ID_TB_QUICKVIEWNOTEX    20009
#define ID_TB_RESETRELOADNOTEX  20010
#define ID_TB_CAMERAOPTIONS     20011	// aml  Camera export options
#define ID_TB_CUTSCENEEXPORT    20012
#define ID_TB_QUICKSCRIPT		20013	// Export scripts and request a reload via the network

extern HINSTANCE hInstance;
extern void OpenCutsceneExporter();

const ActionTableId export_actions = vEXPORT_SHORTCUT_ID;
const ActionContextId export_actions_context = vEXPORT_SHORTCUT_ID;

static HWND hToolbar = NULL;
static HIMAGELIST hButtons = NULL;
static int display_counter = 0;
static ExportOptionsDlg *export_dlg = NULL;
static ExportActionCB *accel = NULL;

static ExportUIClassDesc ExportUIDesc;
ClassDesc* GetExportUIDesc() { return &ExportUIDesc; }

static CameraExportDlg*  cam_export_dlg = NULL;
static void DestroyCameraExportOptionsDialog( MSDlgWindow* pWindow, void* pData );

//extern CutsceneExportDlg* cutscene_export_dlg;
extern CutsceneExportDlg* gpCutsceneExporter;

class ExportTBMsgHandler : public CUIFrameMsgHandler 
{
	ExportUI *ct;	
  public:
	ExportTBMsgHandler(ExportUI *ctst)	{ this->ct = ctst; }
	int ProcessMessage(UINT message, WPARAM wParam, LPARAM lParam);

};	
static ExportTBMsgHandler *tbMsgHandler;

int ExportTBMsgHandler::ProcessMessage(UINT message, WPARAM wParam, LPARAM lParam) {
	bool export;
	ExportType type;

	export = false;

	switch(message) {
	case WM_COMMAND:
		switch (LOWORD(wParam)) 
		{		
		case ID_TB_QUICKVIEW:
			type = vQUICK_VIEW;
			export = true;
			break;
		case ID_TB_QUICKUPDATE:
			type = vQUICK_UPDATE;
			export = true;
			break;
		case ID_TB_QUICKVIEWNOTEX:
			type = vQUICK_VIEW_NOTEX;
			export = true;
			break;
		case ID_TB_QUICKEXPORTNOTEX:
			type = vQUICK_UPDATE_NOTEX;
			export = true;
			break;
		case ID_TB_EXPORTNOTEX:
			type   = vQUICK_EXPORT_NOTEX;
			export = true;
			break;
		case ID_TB_RESETRELOAD:
			type = vRESET_AND_RELOAD;
			export = true;
			break;
		case ID_TB_RESETRELOADNOTEX:
			type = vRESET_AND_RELOAD_NOTEX;
			export = true;
			break;
		case ID_TB_QUICKEXPORT:			
			type = vQUICK_EXPORT;
			export = true;
			break;
		case ID_TB_SCRIPTEXPORT:
			type = vSCRIPT_EXPORT;
			export = true;
			break;
		case ID_TB_QUICKSCRIPT:
			type = vQUICK_SCRIPT;
			export = true;
			break;
		case ID_TB_OPTIONS:
			if( export_dlg == NULL )
			{
				export_dlg = new ExportOptionsDlg;
				export_dlg->Show();
			}
			break;
		case ID_TB_CAMERAOPTIONS:
			{
				if (!cam_export_dlg)
				{
					cam_export_dlg = new CameraExportDlg(hInstance,
					                                     gInterface->GetMAXHWnd(),
														 gInterface);

					cam_export_dlg->SetCloseCB(DestroyCameraExportOptionsDialog,NULL);
				}

				cam_export_dlg->Show();
			}
			break;
		case ID_TB_CUTSCENEEXPORT:
			{
				gpCutsceneExporter->Show();
			}
			break;

		case ID_TB_CAMEXPORT:
			type   = vCAM_EXPORT;
			export = true;
			break;

		default: // ID not recognized -- use default CUI processing
			return FALSE;
		}
	}

	if( export )
	{
		ExportOptions* options;
		Exporter* exporter;		

		ResetWarningFile();

		exporter = NULL;
		options = GetExportOptions();

		// If the export type is camera we want to export the cameras
		// regardless of what the ExportOptions are set to (user pushed it)  aml
		if( type == vCAM_EXPORT )
		{
			exporter = GetCamExporter();	
		}
		else if( type == vSCRIPT_EXPORT )		// same case for scripts   aml
		{
			exporter = GetSceneExporter();
		}
		else if( options->m_ExportType == ExportOptions::vEXPORT_SCENE )
		{
			exporter = GetSceneExporter();
		}
		else if( options->m_ExportType == ExportOptions::vEXPORT_MODEL )
		{
			exporter = GetModelExporter();
		}
		else if( options->m_ExportType == ExportOptions::vEXPORT_SKIN )
		{
			exporter = GetSkinExporter();
		}
		else if( options->m_ExportType == ExportOptions::vEXPORT_CAMERA )
		{
			exporter = GetCamExporter();
		}
		else if( options->m_ExportType == ExportOptions::vEXPORT_ANIM )
		{
			//exporter = GetAnimExporter();
			// TODO: Make AnimExporter operate as standard exporter derived from Exporter
			//       for now this relies on loading and managing ANRs which is only done through
			//       the interface which is seperate.  This will force the UI to build export and
			//       then close.
			AnimOptionsDlg* animExporter = new AnimOptionsDlg(hInstance, gInterface->GetMAXHWnd(), gInterface, true);
			delete animExporter;
			return FALSE;
		}

		if( exporter )
		{
			bool bSuccess = exporter->DoExport( type );

			// If we're exporting the cameras also export the script.qn
			if ( type == vCAM_EXPORT || options->m_ExportType == ExportOptions::vEXPORT_CAMERA )
			{
				if ( type != vSCRIPT_EXPORT )
				{
					exporter = GetSceneExporter();
					exporter->DoExport( vSCRIPT_EXPORT );
				}
			}

			/*
			if ( type == vCAM_EXPORT )
			{
				if (bSuccess)
					MessageBox(gInterface->GetMAXHWnd(),"Cameras were successfully exported.","Camera Exporter",MB_ICONINFORMATION|MB_OK);
			}
			*/
		}
	}

	return FALSE;
}

void	DestroyCameraExportOptionsDialog( MSDlgWindow* pWindow, void* pData )
{
	if (cam_export_dlg)
	{
		delete cam_export_dlg;
		cam_export_dlg = NULL;
	}
}

void	DestroyExportOptionsDialog( void )
{
	export_dlg->Hide();
	delete export_dlg;
	export_dlg = NULL;
}

// Activate and Stay Resident
// The GUPRESULT_KEEP tells MAX that we want to remain loaded in the system
// Check the SDK Help File for other returns, to change the behavior
DWORD ExportUI::Start( ) 
{
	ICustButton* button;
	HWND hParent = MaxWnd();
	bool existed;
	
	// Check to see if a frame already exists
	// one will be there if the toolbars have been 
	// loaded through the system window identifier
	ICUIFrame *exFrame = NULL;
	
	existed = false;
	exFrame = GetCUIFrameMgr()->GetICUIFrame(_T("ExportUI Toolbar"));
	if( exFrame )
	{
		existed = true;		
	}
	hWnd = CreateCUIFrameWindow(hParent, _T("ExportUI Toolbar"), 0, 0, 250, 100);
	exFrame = GetCUIFrameMgr()->GetICUIFrame(_T("ExportUI Toolbar"));
	
	iFrame = ::GetICUIFrame(hWnd);
	iFrame->SetContentType(CUI_TOOLBAR);
	iFrame->SetPosType(CUI_HORIZ_DOCK | CUI_VERT_DOCK | CUI_FLOATABLE | CUI_SM_HANDLES );
	// Register me in menu dropdown
	iFrame->SetMenuDisplay(CUI_MENU_SHOW_ENABLED);
	iFrame->SetSystemWindow(TRUE);

	// -- Now create the toolbar window
	hToolbar = CreateWindow
	(
		CUSTTOOLBARWINDOWCLASS,
		NULL,
		WS_CHILD | WS_VISIBLE,
		0, 0, 250, 100,
		hWnd,
		NULL,
		hInstance,
		NULL);

	// -- Now link the toolbar to the CUI frame
	ICustToolbar *export_toolbar = GetICustToolbar(hToolbar);
	export_toolbar->LinkToCUIFrame(hWnd, NULL);
	export_toolbar->SetBottomBorder(FALSE);
	export_toolbar->SetTopBorder(FALSE);

	// Install the message handler to process the controls we'll add...
	tbMsgHandler = new ExportTBMsgHandler(this);
	iFrame->InstallMsgHandler(tbMsgHandler);

	// -- Toss in a few controls of various sorts...
	//export_toolbar->SetImage(GetCUIFrameMgr()->GetDefaultImageList());
	//hButtons = ImageList_Create(16, 15, ILC_COLOR16 | ILC_MASK, 7, 0);
	//LoadMAXFileIcon("ExportUI", hButtons, kBackground, FALSE);
	// Get the index into the entire image list of the CUITest icons.
	int iconIndex;// = GetCUIFrameMgr()->GetGroupStartIndex(_T("ExportUI"));
	// Add a push button
	// This one docks and undocks the toolbar if clicked...
	iconIndex = 1;
	MaxBmpFileIcon* pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex );
	//export_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex, ID_TB_MANY_TO_ONE ));
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_QUICKVIEW));
	
	button = export_toolbar->GetICustButton( ID_TB_QUICKVIEW );
	button->SetTooltip( TRUE, &(_T("Quickview")));
	ReleaseICustButton( button );

	// Add QuickView without textures button
	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 9);
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_QUICKVIEWNOTEX));

	button = export_toolbar->GetICustButton( ID_TB_QUICKVIEWNOTEX );
	button->SetTooltip( TRUE, &(_T("Quick view w/o textures")));
	ReleaseICustButton( button );

	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 3 );
	
	// Designers no longer want to support Quick Update  2-4-03 aml
	//export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_QUICKUPDATE));
	
	//export_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex+4, ID_TB_CHAIN_CLOSED ));

	/*	Designers no longer want to support Quick Update  2-4-03 aml
	button = export_toolbar->GetICustButton( ID_TB_QUICKUPDATE);
	button->SetTooltip( TRUE, &(_T("Quick Update" )));
	ReleaseICustButton( button );

	// Add QuickExport without textures button
	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 8);
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_QUICKEXPORTNOTEX));

	button = export_toolbar->GetICustButton( ID_TB_QUICKEXPORTNOTEX );
	button->SetTooltip( TRUE, &(_T("Quick update w/o textures")));
	ReleaseICustButton( button );
	*/

	// Add Reset and reload button
	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 1 );
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_RESETRELOAD));
	//export_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex+1, ID_TB_ONE_TO_MANY ));

	button = export_toolbar->GetICustButton( ID_TB_RESETRELOAD );
	button->SetTooltip( TRUE, &(_T("Reset and Reload" )));
	ReleaseICustButton( button );

	// Add Export and Reload w/o textures button
	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 10);
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_RESETRELOADNOTEX));
	//export_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex+5, ID_TB_CHAIN_OPEN ));

	button = export_toolbar->GetICustButton( ID_TB_RESETRELOADNOTEX );
	button->SetTooltip( TRUE, &(_T("Reset and Reload w/o Textures" )));
	ReleaseICustButton( button );

	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 2 );
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_QUICKEXPORT));
	//export_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex+4, ID_TB_CHAIN_CLOSED ));

	button = export_toolbar->GetICustButton( ID_TB_QUICKEXPORT );
	button->SetTooltip( TRUE, &(_T("Quick Export" )));
	ReleaseICustButton( button );

	// Add export without textures button
	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 7);
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_EXPORTNOTEX));

	button = export_toolbar->GetICustButton( ID_TB_EXPORTNOTEX );
	button->SetTooltip( TRUE, &(_T("Quick export w/o textures")));
	ReleaseICustButton( button );

	// Add QuickScript button
	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 13 );
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_QUICKSCRIPT));	

	button = export_toolbar->GetICustButton( ID_TB_QUICKSCRIPT );
	button->SetTooltip( TRUE, &(_T("QuickScript" )));
	ReleaseICustButton( button );

	// Add ScriptExport button
	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 4 );
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_SCRIPTEXPORT));
	//export_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex+5, ID_TB_CHAIN_OPEN ));

	button = export_toolbar->GetICustButton( ID_TB_SCRIPTEXPORT );
	button->SetTooltip( TRUE, &(_T("Export Script" )));
	ReleaseICustButton( button );

	// Add camera export button
	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 6);
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_CAMEXPORT));

	button = export_toolbar->GetICustButton( ID_TB_CAMEXPORT );
	button->SetTooltip( TRUE, &(_T("Export Cameras")));
	ReleaseICustButton( button );

	// Add a separator
	export_toolbar->AddTool( ToolSeparatorItem( 8 ));
	
	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 5);
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_OPTIONS));
	//export_toolbar->AddTool( TBITEM( CTB_PUSHBUTTON, iconIndex+2, ID_TB_UNLINK ));

	button = export_toolbar->GetICustButton( ID_TB_OPTIONS );
	button->SetTooltip( TRUE, &(_T("Options" )));
	ReleaseICustButton( button );

	// Add camera options
	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 11);
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_CAMERAOPTIONS));

	button = export_toolbar->GetICustButton( ID_TB_CAMERAOPTIONS );
	button->SetTooltip( TRUE, &(_T("Camera Options")));
	ReleaseICustButton( button );

	// Add cutscene options
	pIcon = new MaxBmpFileIcon(_T("ExportUI"), iconIndex + 12);
	export_toolbar->AddTool(TBITEM(CTB_PUSHBUTTON, pIcon, ID_TB_CUTSCENEEXPORT));

	button = export_toolbar->GetICustButton( ID_TB_CUTSCENEEXPORT );
	button->SetTooltip( TRUE, &(_T("Cutscene Export")));
	ReleaseICustButton( button );

	// -- Set the initial floating position
	// if the utility hasn't been run before, this will become the position
	// the user sees. otherwise, it will get overwritten by the loaded 
	// data below
	SIZE sz; RECT rect;
	export_toolbar->GetFloatingCUIFrameSize(&sz);
	rect.top = 200; rect.left = 200;
	rect.right = rect.left+sz.cx; rect.bottom = rect.top+sz.cy;
	GetCUIFrameMgr()->FloatCUIWindow(hWnd, &rect);
	MoveWindow(hWnd, rect.left, rect.right, sz.cx, sz.cy, TRUE);


	if( existed )
	{
		// SHELF SEARCH - STILL FLAKY!
		ICUIFrame *shelf = GetCUIFrameMgr()->GetICUIFrame(_T("Tab Panel"));
		int nTools = shelf->GetToolbarCount();
		BOOL weInTabBar = FALSE;
		int posInTabBar = -1;
		int i;

		// Search the shelf for instance
		for(i=0;i<nTools;i++)
		{
			if( stricmp(shelf->GetTabName(i),_T("ExportUI Toolbar"))==0 )
			{
				shelf->DeleteToolbarTab(i);
				posInTabBar = i;
				weInTabBar = TRUE;
				break;
			}
		}
		
		// SHELF SEARCH - STILL FLAKY!
		// restore position and docking if the tab panel had saved data
		if( !weInTabBar)
		{
			iFrame->Hide(FALSE);

			// If one already exists - copy its positional data and kill it
			// this would happen if the utility had been run before and therefore
			// the tab panel would get to save itself into the CUI file
			if(exFrame)
			{
				DWORD cPos = exFrame->GetCurPosition();
				if(cPos==CUI_FLOATING)
				{
					// frame was floating - get pos and copy
					Rect sz;
					GetWindowRect(exFrame->GetHwnd(),&sz);
					GetCUIFrameMgr()->FloatCUIWindow(iFrame->GetHwnd(), &sz);
					DestroyWindow(exFrame->GetHwnd());
				}
				else
				{
					// frame was docked - just redock
					DestroyWindow(exFrame->GetHwnd());
					GetCUIFrameMgr()->DockCUIWindow(iFrame->GetHwnd(),cPos);
				}
			}
		}


		// SHELF SEARCH - STILL FLAKY!
		if(weInTabBar)
		{

			shelf->AddToolbarTab(iFrame->GetContentHandle(), tbMsgHandler, iFrame->GetName());
			SetParent(iFrame->GetContentHandle(), shelf->GetHwnd());
			DestroyWindow(iFrame->GetHwnd());
			shelf->SetCurrentTab(shelf->GetCurrentTab());
		}
		// SHELF SEARCH - STILL FLAKY!

		// Force a CUI complete update
		GetCUIFrameMgr()->RecalcLayout(TRUE);
	}

	// We are done, release the toolbar and frame handles
	ReleaseICustToolbar(export_toolbar);
	ReleaseICUIFrame(iFrame);
	iFrame = NULL;

	accel = new ExportActionCB;
	gInterface->GetActionManager()->ActivateActionTable( accel, export_actions );

	return GUPRESULT_KEEP;
}


// We do nothing when the GUP unloads
void ExportUI::Stop( ) 
{	
}


DWORD ExportUI::Control( DWORD parameter ) 
{
	return 0;
}

// action table
static ActionDescription s_export_actions[] = {

	ID_TB_QUICKVIEW,
	IDS_TB_QUICKVIEW,
	IDS_TB_QUICKVIEW,
	IDS_EXPORT_ACTIONS,

	ID_TB_QUICKVIEWNOTEX,
	IDS_TB_QUICKVIEWNOTEX,
	IDS_TB_QUICKVIEWNOTEX,
	IDS_EXPORT_ACTIONS,
		
	ID_TB_RESETRELOAD,
	IDS_TB_RESETRELOAD,
	IDS_TB_RESETRELOAD,
	IDS_EXPORT_ACTIONS,

	ID_TB_RESETRELOADNOTEX,
	IDS_TB_RESETRELOADNOTEX,
	IDS_TB_RESETRELOADNOTEX,
	IDS_EXPORT_ACTIONS,
	
	ID_TB_QUICKEXPORT,
	IDS_TB_QUICKEXPORT,
	IDS_TB_QUICKEXPORT,
	IDS_EXPORT_ACTIONS,

	ID_TB_QUICKEXPORTNOTEX,
	IDS_TB_QUICKEXPORTNOTEX,
	IDS_TB_QUICKEXPORTNOTEX,
	IDS_EXPORT_ACTIONS,

	ID_TB_SCRIPTEXPORT,
	IDS_TB_SCRIPTEXPORT,
	IDS_TB_SCRIPTEXPORT,
	IDS_EXPORT_ACTIONS,

	ID_TB_OPTIONS,
	IDS_TB_OPTIONS,
	IDS_TB_OPTIONS,
	IDS_EXPORT_ACTIONS,	

	ID_TB_CAMERAOPTIONS,
	IDS_TB_CAMERAOPTIONS,
	IDS_TB_CAMERAOPTIONS,
	IDS_EXPORT_ACTIONS,	

	ID_TB_CAMEXPORT,
	IDS_TB_CAMEXPORT,
	IDS_TB_CAMEXPORT,
	IDS_EXPORT_ACTIONS,	

	ID_TB_QUICKSCRIPT,
	IDS_TB_QUICKSCRIPT,
	IDS_TB_QUICKSCRIPT,
	IDS_EXPORT_ACTIONS,
};

ActionTable* GetExportActions( void )
{
    TSTR name = GetString(IDS_EXPORT_ACTIONS);
    HACCEL hAccel = LoadAccelerators(hInstance,
                                     MAKEINTRESOURCE(IDR_EXPORT_ACCELERATOR));
    int numOps = NumElements( s_export_actions );
    ActionTable* pTab;
    pTab = new ActionTable( export_actions, export_actions_context, name, hAccel, numOps,
                             s_export_actions, hInstance);
    GetCOREInterface()->GetActionManager()->RegisterActionContext( export_actions_context, name.data());

    return pTab;
}

BOOL ExportActionCB::ExecuteAction( int id )
{
	bool export;
	ExportType type;

	export = false;
	switch( id )
	{
	case ID_TB_QUICKVIEW:
		export = true;
		type = vQUICK_VIEW;
		break;
	case ID_TB_QUICKVIEWNOTEX:
		export = true;
		type = vQUICK_VIEW_NOTEX;
		break;
	case ID_TB_RESETRELOAD:
		export = true;
		type = vRESET_AND_RELOAD;
		break;
	case ID_TB_RESETRELOADNOTEX:
		export = true;
		type = vRESET_AND_RELOAD_NOTEX;
		break;
	case ID_TB_QUICKEXPORT:
		export = true;
		type = vQUICK_EXPORT;
		break;
	case ID_TB_QUICKEXPORTNOTEX:
		export = true;
		type = vQUICK_EXPORT_NOTEX;
		break;
	case ID_TB_SCRIPTEXPORT:
		export = true;
		type = vSCRIPT_EXPORT;
		break;
	case ID_TB_QUICKSCRIPT:
		export = true;
		type = vQUICK_SCRIPT;
		break;
	case ID_TB_OPTIONS:
		if( export_dlg == NULL )
		{
			export_dlg = new ExportOptionsDlg;
			export_dlg->Show();
		}
		break;
	case ID_TB_CAMERAOPTIONS:
		if (!cam_export_dlg)
		{
			cam_export_dlg = new CameraExportDlg(hInstance,
					                             gInterface->GetMAXHWnd(),
												 gInterface);

			cam_export_dlg->SetCloseCB(DestroyCameraExportOptionsDialog,NULL);
		}

		cam_export_dlg->Show();			
		break;
	case ID_TB_CAMEXPORT:
		export = true;
		type = vCAM_EXPORT;
		break;	
	default:
		break;
	
	}

	if( export )
	{
		ExportOptions* options;
		Exporter* exporter;		

		ResetWarningFile();

		options = GetExportOptions();
		if( options->m_ExportType == ExportOptions::vEXPORT_SCENE )
		{
			exporter = GetSceneExporter();
		}
		else if( options->m_ExportType == ExportOptions::vEXPORT_MODEL )
		{
			exporter = GetModelExporter();
		}
		else if( options->m_ExportType == ExportOptions::vEXPORT_SKIN )
		{
			exporter = GetSkinExporter();
		}
		else if( options->m_ExportType == ExportOptions::vEXPORT_CAMERA )
		{
			exporter = GetCamExporter();
		}

		exporter->DoExport( type );
	}

	return TRUE;
}