#include <Export/AnimOptionsDlg.h>
#include <Export/SkelOptionsDlg.h>
#include <next.h>
#include <appdata.h>
#include <Export/ExportOptions.h>
#include <Export/ExportUI.h>
#include <Export/SceneExportOptions.h>
#include <Export/ModelExportOptions.h>
#include <Export/SkinExportOptions.h>
#include <Export/CamExporter.h>
#include <Export/ObjAnimExport.h>
#include <Export/CutsceneExportDlg.h>

static SceneOptionsDlg*	scene_export_dlg = NULL;
static ModelOptionsDlg*	model_export_dlg = NULL;
static AnimOptionsDlg* anim_export_dlg  = NULL;
static SkeletonOptionsDlg* skel_export_dlg = NULL;
static SkinOptionsDlg*	skin_export_dlg = NULL;
static ObjAnimExportDlg*  obj_export_dlg = NULL;
CutsceneExportDlg* cutscene_export_dlg = NULL;			// Not static as can also be accessed from the toolbar

static QuickviewPlatform s_qv_platform = vQUICKVIEW_PS2;

extern void OpenCutsceneExporter();						// TODO: Deprecated (Remove)
extern CutsceneExportDlg* gpCutsceneExporter;

ExportOptions::ExportOptions( void )
{
	m_Version = vVERSION_NUMBER;
	m_ExportType = vEXPORT_SCENE;
	m_SortGroupId = 500;
	m_SceneConvOptimize = false;
}

static INT_PTR CALLBACK ExportOptionsDlgProc(
		HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static ExportOptionsDlg *dlg = NULL;
	
	switch(msg) 
	{
		case WM_INITDIALOG:
		{
			HWND radio_button;
			ExportOptions* options;
			ICustEdit *draw_order_wnd;
			char draw_order_str[64];

			dlg = (ExportOptionsDlg*) lParam;

			options = GetExportOptions();
			
			draw_order_wnd = GetICustEdit(GetDlgItem( hWnd, IDC_SORTED_DRAW_ORDER ));
			itoa( options->m_SortGroupId, draw_order_str, 10 );
			draw_order_wnd->SetText( draw_order_str );			
			ReleaseICustEdit( draw_order_wnd );
			
			if( GetQuickviewPlatform() == vQUICKVIEW_XBOX )
			{
				radio_button = GetDlgItem( hWnd, IDC_QUICKVIEW_XBOX );
				SendMessage( radio_button, BM_SETCHECK, BST_CHECKED, 0 );
			}
			else if( GetQuickviewPlatform() == vQUICKVIEW_PS2 )
			{
				radio_button = GetDlgItem( hWnd, IDC_QUICKVIEW_PS2 );
				SendMessage( radio_button, BM_SETCHECK, BST_CHECKED, 0 );
			}
			else	// NGC
			{
				radio_button = GetDlgItem( hWnd, IDC_QUICKVIEW_NGC );
				SendMessage( radio_button, BM_SETCHECK, BST_CHECKED, 0 );
			}

			if( options->m_ExportType == ExportOptions::vEXPORT_SCENE )
			{
				HWND settings_button;
				
				radio_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE );
				SendMessage( radio_button, BM_SETCHECK, BST_CHECKED, 0 );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );				
				EnableWindow( settings_button, FALSE );
				
				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
				EnableWindow( settings_button, FALSE );
			}
			else if ( options->m_ExportType == ExportOptions::vEXPORT_ANIM )
			{
				HWND radio_button, settings_button;

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				radio_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM );
				SendMessage( radio_button, BM_SETCHECK, BST_CHECKED, 0 );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
				EnableWindow( settings_button, FALSE );
			}
			else if( options->m_ExportType == ExportOptions::vEXPORT_MODEL )
			{
				HWND radio_button, settings_button;
				
				radio_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL );
				SendMessage( radio_button, BM_SETCHECK, BST_CHECKED, 0 );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				// aml
				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
				EnableWindow( settings_button, FALSE );
			}
			else if( options->m_ExportType == ExportOptions::vEXPORT_SKIN )
			{
				HWND radio_button, settings_button;
				
				radio_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN );
				SendMessage( radio_button, BM_SETCHECK, BST_CHECKED, 0 );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
				EnableWindow( settings_button, FALSE );
			}
			else if( options->m_ExportType == ExportOptions::vEXPORT_SKELETON )
			{
				HWND radio_button, settings_button;
				
				radio_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL );
				SendMessage( radio_button, BM_SETCHECK, BST_CHECKED, 0 );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
				EnableWindow( settings_button, FALSE );
				
				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
				EnableWindow( settings_button, FALSE );
			}
			else if( options->m_ExportType == ExportOptions::vEXPORT_CAMERA )
			{
				HWND radio_button, settings_button;
				
				radio_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM );
				SendMessage( radio_button, BM_SETCHECK, BST_CHECKED, 0 );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
				EnableWindow( settings_button, FALSE );
				
				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
				EnableWindow( settings_button, FALSE );
			}
			else if( options->m_ExportType == ExportOptions::vEXPORT_OBJECT )
			{
				HWND radio_button, settings_button;

				radio_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ );
				SendMessage( radio_button, BM_SETCHECK, BST_CHECKED, 0 );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
				EnableWindow( settings_button, FALSE );
				
				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
				EnableWindow( settings_button, FALSE );
			}
			else if( options->m_ExportType == ExportOptions::vEXPORT_CUTSCENE )
			{
				HWND radio_button, settings_button;

				radio_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE );
				SendMessage( radio_button, BM_SETCHECK, BST_CHECKED, 0 );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
				SendMessage( radio_button, BM_SETCHECK, BST_CHECKED, 0 );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );				
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
				EnableWindow( settings_button, FALSE );

				settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
				EnableWindow( settings_button, FALSE );
			}

			// Set the SceneConvOptimize button as appropriate
			if ( options->m_SceneConvOptimize )
				CheckDlgButton( hWnd, IDC_OPTSCENECONV, BST_CHECKED );
			else
				CheckDlgButton( hWnd, IDC_OPTSCENECONV, BST_UNCHECKED );

			ShowWindow( hWnd, SW_SHOW );
			break;
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam)) 
			{
				case IDOK:
				{
					ExportOptions* options;
					ICustEdit *draw_order_wnd;
					char draw_order_str[64];

					dlg = (ExportOptionsDlg*) lParam;

					options = GetExportOptions();
			
					draw_order_wnd = GetICustEdit(GetDlgItem( hWnd, IDC_SORTED_DRAW_ORDER ));
					draw_order_wnd->GetText( draw_order_str, 64 );					
					ReleaseICustEdit( draw_order_wnd );

					options->m_SortGroupId = atoi( draw_order_str );
					SetExportOptions( options );

					DestroyExportOptionsDialog();
					DestroyAnimOptionsDialog();
					DestroySkeletonOptionsDialog();
//					DestroyCameraOptionsDialog();
					break;
				}
				case IDC_QUICKVIEW_PS2:
					SetQuickviewPlatform( vQUICKVIEW_PS2 );
					break;
				case IDC_QUICKVIEW_XBOX:
					SetQuickviewPlatform( vQUICKVIEW_XBOX );
					break;
				case IDC_QUICKVIEW_NGC:
					SetQuickviewPlatform( vQUICKVIEW_NGC );
					break;
				case IDC_OPTSCENECONV:
					{
						ExportOptions* options;
						options = GetExportOptions();

						if (IsDlgButtonChecked(hWnd, IDC_OPTSCENECONV) == BST_CHECKED)
							options->m_SceneConvOptimize = true;
						else
							options->m_SceneConvOptimize = false;

						SetExportOptions(options);
					}
					break;
				case IDC_EXPORT_OPTIONS_SCENE:
				{
					if( scene_export_dlg || model_export_dlg || skin_export_dlg)
					{
						return TRUE;
					}

					ExportOptions options;
					HWND settings_button;

					options.m_ExportType = ExportOptions::vEXPORT_SCENE;
					SetExportOptions( &options );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );
					EnableWindow( settings_button, TRUE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
					EnableWindow( settings_button, FALSE );
					break;
				}
				case IDC_EXPORT_OPTIONS_MODEL:
				{
					if( scene_export_dlg || model_export_dlg || skin_export_dlg)
					{
						return TRUE;
					}

					ExportOptions options;
					HWND settings_button;

					options.m_ExportType = ExportOptions::vEXPORT_MODEL;
					SetExportOptions( &options );					

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );
					EnableWindow( settings_button, TRUE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
					EnableWindow( settings_button, FALSE );
					break;
				}
				case IDC_EXPORT_OPTIONS_SKIN:
				{
					if( scene_export_dlg || model_export_dlg || skin_export_dlg)
					{
						return TRUE;
					}

					ExportOptions options;
					HWND settings_button;

					options.m_ExportType = ExportOptions::vEXPORT_SKIN;
					SetExportOptions( &options );					

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 1, 0 );
					EnableWindow( settings_button, TRUE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 1, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 0, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 0, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 1, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 0, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
					EnableWindow( settings_button, FALSE );
					break;
				}
				// aml
				case IDC_EXPORT_OPTIONS_SKEL:
				{
					if( scene_export_dlg || model_export_dlg || skin_export_dlg)
					{
						return TRUE;
					}

					ExportOptions options;
					HWND settings_button;

					options.m_ExportType = ExportOptions::vEXPORT_SKELETON;
					SetExportOptions( &options );					

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 1, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 1, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 0, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 0, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 0, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 0, 0 );
					EnableWindow( settings_button, TRUE );					

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
					EnableWindow( settings_button, FALSE );
					break;				
				}

				// aml
				case IDC_EXPORT_OPTIONS_ANIM:
				{
					if( scene_export_dlg || model_export_dlg || skin_export_dlg)
					{
						return TRUE;
					}

					ExportOptions options;
					HWND settings_button;

					options.m_ExportType = ExportOptions::vEXPORT_ANIM;
					SetExportOptions( &options );					

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 1, 0 );
					EnableWindow( settings_button, TRUE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 1, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 0, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 0, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 0, 0 );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
					//SendMessage( settings_button, WM_ENABLE, 0, 0 );
					EnableWindow( settings_button, FALSE );					

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
					EnableWindow( settings_button, FALSE );
					break;				
				}
				case IDC_EXPORT_OPTIONS_CAM:
				{
					if( scene_export_dlg || model_export_dlg || skin_export_dlg)
					{
						return TRUE;
					}

					ExportOptions options;
					HWND settings_button;

					options.m_ExportType = ExportOptions::vEXPORT_CAMERA;
					SetExportOptions( &options );					

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
					EnableWindow( settings_button, FALSE );					

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
					EnableWindow( settings_button, TRUE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
					EnableWindow( settings_button, FALSE );
					break;
				}
				case IDC_EXPORT_OPTIONS_OBJ:
				{
					if( scene_export_dlg || model_export_dlg || skin_export_dlg)
					{
						return TRUE;
					}

					ExportOptions options;
					HWND settings_button;

					options.m_ExportType = ExportOptions::vEXPORT_OBJECT;
					SetExportOptions( &options );					

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
					EnableWindow( settings_button, FALSE );					

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
					EnableWindow( settings_button, TRUE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
					EnableWindow( settings_button, FALSE );
					break;
				}
				case IDC_EXPORT_OPTIONS_CUTSCENE:
				{
					if( scene_export_dlg || model_export_dlg || skin_export_dlg)
					{
						return TRUE;
					}

					ExportOptions options;
					HWND settings_button;

					options.m_ExportType = ExportOptions::vEXPORT_CUTSCENE;
					SetExportOptions( &options );					

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_ANIM_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_MODEL_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SCENE_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKIN_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_SKEL_SETTINGS );
					EnableWindow( settings_button, FALSE );					

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CAM_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_OBJ_SETTINGS );
					EnableWindow( settings_button, FALSE );

					settings_button = GetDlgItem( hWnd, IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS );
					EnableWindow( settings_button, TRUE );
					break;
				}

				case IDC_EXPORT_OPTIONS_SCENE_SETTINGS:
				{
					if( scene_export_dlg == NULL )
					{
						scene_export_dlg = new SceneOptionsDlg;
						scene_export_dlg->Show();
					}

					//EnableWindow( hWnd, FALSE );
					break;
				}
				case IDC_EXPORT_OPTIONS_MODEL_SETTINGS:
				{
					if( model_export_dlg == NULL )
					{
						model_export_dlg = new ModelOptionsDlg;
						model_export_dlg->Show();
					}
					//EnableWindow( hWnd, FALSE );
					break;
				}
				case IDC_EXPORT_OPTIONS_SKIN_SETTINGS:
				{
					if( skin_export_dlg == NULL )
					{
						skin_export_dlg = new SkinOptionsDlg;
						skin_export_dlg->Show();
					}
					break;
				}
				case IDC_EXPORT_OPTIONS_ANIM_SETTINGS:
				{
					if( anim_export_dlg == NULL )
						anim_export_dlg = new AnimOptionsDlg(hInstance,dlg->GetHWND(),gInterface);
	
					anim_export_dlg->Show();

					//EnableWindow( hWnd, FALSE );
					return TRUE;
				}
				case IDC_EXPORT_OPTIONS_SKEL_SETTINGS:
				{
					if( skel_export_dlg == NULL )
						skel_export_dlg = new SkeletonOptionsDlg(hInstance,dlg->GetHWND(),gInterface);

					skel_export_dlg->Show();

					return TRUE;
				}
				/* Removed
				case IDC_EXPORT_OPTIONS_CAM_SETTINGS:
				{
					if( cam_export_dlg == NULL )
					{
						//cam_export_dlg = new CameraExportDlg(hInstance,dlg->GetHWND(),gInterface);
						cam_export_dlg = new CameraExportDlg(hInstance,NULL,gInterface,dlg);
						cam_export_dlg->GetCamData();
					}

					cam_export_dlg->Show();

					return TRUE;
				}
				*/
				case IDC_EXPORT_OPTIONS_OBJ_SETTINGS:
				{
					if( obj_export_dlg == NULL )
					{
						obj_export_dlg = new ObjAnimExportDlg(hInstance,NULL,gInterface,dlg);
						
						// TODO: Process Animation Systems
						//obj_export_dlg->GetObjData();
					}

					obj_export_dlg->Show();

					return TRUE;
				}

				case IDC_EXPORT_OPTIONS_CUTSCENE_SETTINGS:
				{
					gpCutsceneExporter->Show();
				}

				default:
					break;
			}
		}

		default:
			return FALSE;
	}
	
	return TRUE;
}

void	ExportOptionsDlg::Show( void )
{
	m_wnd = CreateDialogParam(
		hInstance,
		MAKEINTRESOURCE(IDD_EXPORT_OPTIONS),
		gInterface->GetMAXHWnd(),
		ExportOptionsDlgProc,
		(LPARAM)this);	
	TSTR title = "Export Options";
	SetWindowText( m_wnd, title );
	gInterface->RegisterDlgWnd( m_wnd );
}

void	ExportOptionsDlg::Hide( void )
{
	gInterface->UnRegisterDlgWnd( m_wnd );
	DestroyWindow( m_wnd );	
}


ExportOptions* GetExportOptions( void )
{
	ExportOptions *options;

	ReferenceTarget *scene = gInterface->GetScenePointer();
	AppDataChunk* pad = scene->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_EXPORT_OPTIONS_ID );

	// Return the export options if they exist
	if( pad && pad->data )
	{
		options = (ExportOptions *) pad->data;
		if( options->m_Version != ExportOptions::vVERSION_NUMBER )
		{
			ExportOptions new_options;

			new_options.m_ExportType = options->m_ExportType;
			if( options->m_Version >= 0x0002 )
			{
				new_options.m_SortGroupId = options->m_SortGroupId;
			}
			
			if( options->m_Version >= 0x0003 )
				new_options.m_SceneConvOptimize = options->m_SceneConvOptimize;
			else
				new_options.m_SceneConvOptimize = false;

			// Remove the old appdata
			scene->RemoveAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_EXPORT_OPTIONS_ID );			
			
			// Return a default set if there were no previous options
			SetExportOptions( &new_options );
			return GetExportOptions();			
		}
		return options;
	}
	else
	{
		ExportOptions new_options;

		// Return a default set if there were no previous options
		SetExportOptions( &new_options );
		return GetExportOptions();
	}
	
	return NULL;	
}

void SetExportOptions( ExportOptions* options )
{
	ExportOptions *export_options;
	AppDataChunk* pad;
	ReferenceTarget *scene;

	assert( options );

	scene = gInterface->GetScenePointer();	
	pad = scene->GetAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_EXPORT_OPTIONS_ID );
	
	if( !pad )
	{
		export_options = new ExportOptions;		
		scene->AddAppDataChunk( vNEXT_CLASS_ID, GUP_CLASS_ID, vNAPP_EXPORT_OPTIONS_ID, sizeof( ExportOptions ), (void*) export_options );	
	}
	else
	{
		export_options = (ExportOptions *) pad->data;		
	}

	*export_options = *options;
	export_options->m_Version = ExportOptions::vVERSION_NUMBER;
}

void	DestroySceneOptionsDialog( void )
{
	scene_export_dlg->Hide();
	delete scene_export_dlg;
	scene_export_dlg = NULL;

	//EnableWindow( m_wnd, TRUE );
}

void	DestroyModelOptionsDialog( void )
{
	model_export_dlg->Hide();
	delete model_export_dlg;
	model_export_dlg = NULL;

	//EnableWindow( m_wnd, TRUE );
}

void	DestroyAnimOptionsDialog( void )
{
	//model_export_dlg->Hide();
	delete anim_export_dlg;
	anim_export_dlg = NULL;

	//EnableWindow( m_wnd, TRUE );
}

void	DestroySkeletonOptionsDialog( void )
{
	delete skel_export_dlg;
	skel_export_dlg = NULL;
}

void	DestroySkinOptionsDialog( void )
{
	if (skin_export_dlg)
	{
		skin_export_dlg->Hide();
		delete skin_export_dlg;
		skin_export_dlg = NULL;	
	}
}
/*
void	DestroyCameraOptionsDialog( void )
{
	if (cam_export_dlg)
	{
		delete cam_export_dlg;
		cam_export_dlg = NULL;
	}
}
*/

void				SetQuickviewPlatform( QuickviewPlatform platform )
{
	s_qv_platform = platform;
}

QuickviewPlatform	GetQuickviewPlatform( void )
{
	return s_qv_platform;
}

bool	UseSceneConvOptimize()
{
	ExportOptions* options;
	options = GetExportOptions();

	return options->m_SceneConvOptimize;
}
