/*
	FindMap.h
	Debug plugin for locating specific maps within the scene
*/

#ifndef __FINDMAP__
#define __FINDMAP__

#include "max.h"
#include "utilapi.h"
#include "iparamb2.h"
#include "../UI/ProgressBar.h"
#include "../misc/llist.h"

#define FINDMAPTOOL_CLASS_ID     Class_ID(0x348311fb, 0x748e5e15)

struct MapLocator
{
	CStr mapName;
	CStr mapPath;
	bool bWasLocated;

	bool operator ==(MapLocator& right)
	{
		if (mapName == right.mapName)
			return true;

		return false;
	}
};

class FindMapTool: public UtilityObj
{
	Interface*   ip;
	IUtil*       iu;

	ICustEdit*   IEditMapName;
	ICustEdit*   IEditMapReplaceName;

	ProgressBar* pbar;
	LinkList<MapLocator> mapList;	// Cache list for already found locations

	HWND         hwnd;				// The main rollup window
	int          nChanges;

	static BOOL __stdcall DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL CALLBACK  EnumChildProc(HWND hwnd, LPARAM lParam);

	void MapFind();
	void MapReplace();
	void SelectNodes(Mtl* mtl);
	void ProcMtl(Mtl* mtl, char* wildcard);
	void ProcMtlReplace(Mtl* mtl, char* wildcard, char* replace);
	void ProcMtlReplaceFixPaths(Mtl* mtl);
	static void LoadPaths(HWND hwnd);
	static void SavePaths(HWND hwnd);
	CStr ReplaceMap(CStr file);
	void FixPaths();
	bool FindFile(char* path, char* file, char* location);
	bool FindMapFile(char* path, char* file, char* location);
	HWND GetMtlEditor();

public:
	FindMapTool();
	~FindMapTool();

	void BeginEditParams(Interface *ip,IUtil *iu);
	void EndEditParams(Interface *ip,IUtil *iu);
	void SelectionSetChanged(Interface *ip,IUtil *iu);
	void DeleteThis() { delete this; }
	void SetStartupParam(TSTR param) {}
};

class FindMapToolClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) { return new FindMapTool(); }
	const TCHAR *	ClassName() {return _T("NeverSoft FindMap Tool"); }
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID 		ClassID() {return FINDMAPTOOL_CLASS_ID;}
	const TCHAR* 	Category() {return _T("FindMapTool");}
	const TCHAR*	InternalName() { return _T("FindMapTool"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }				// returns owning module handle	
};

#endif
