/*
	DebugTool.h
	Debugging plugin for Max
	6-17-01
*/

#ifndef __DEBUGTOOL__
#define __DEBUGTOOL__

#include "max.h"
#include "utilapi.h"
#include "iparamb2.h"

#define DEBUGTOOL_CLASS_ID     Class_ID(0x7fca3789, 0x34963740)

class DebugTool: public UtilityObj
{
	Interface*  ip;
	IUtil*      iu;

	HWND        hwnd;			// The main rollup window

	static BOOL __stdcall DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

public:
	DebugTool();
	~DebugTool();

	void BeginEditParams(Interface *ip,IUtil *iu);
	void EndEditParams(Interface *ip,IUtil *iu);
	void SelectionSetChanged(Interface *ip,IUtil *iu);
	void DeleteThis() { delete this; }
	void SetStartupParam(TSTR param) {}
};

class DebugToolClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) { return new DebugTool(); }
	const TCHAR *	ClassName() {return _T("NeverSoft Debug Tool"); }
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID 		ClassID() {return DEBUGTOOL_CLASS_ID;}
	const TCHAR* 	Category() {return _T("DebugTool");}
	const TCHAR*	InternalName() { return _T("DebugTool"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }			// returns owning module handle	
};

#endif
