#ifndef __PS2_PS2CONV_H__
#define __PS2_PS2CONV_H__

#include <SceneConv.h>

#define		vTEX_GROUP_SIZE_CEILING	( 648 * 1024 )
#define		vSORTED_TEX_GROUP_SIZE_CIELING ( 648 * 1024 )

#define		mTEX_GROUP_TRANSPARENT	0x0001
#define		mTEX_GROUP_SKY			0x0002
#define		mTEX_GROUP_SORTED		0x0004


#define vPS2_COLLISION_VERSION_NUMBER	0x0009
#define	vPS2_MATERIAL_VERSION_NUMBER	0x0005
#define vPS2_MESH_VERSION_NUMBER		0x0006
#define vPS2_VERTEX_VERSION_NUMBER		0x0001
#define vPS2_TEXTURE_VERSION_NUMBER		0x0005
#define vPS2_CASFLAGS_VERSION_NUMBER	0x0002
#define vPS2_WEIGHTMAP_VERSION_NUMBER	0x0001

#define	vADC_ON		0
#define	vADC_OFF	0x00008000

#define vPSMCT32	0
#define vPSMCT24	1
#define vPSMCT16	2
#define vPSMT8		19
#define vPSMT4		20

class IPS2Converter : public SceneConverter
{
public:
	virtual bool	SaveCollisionData( char* path ) = 0;
	virtual bool	ConvertData( void ) = 0;
	virtual bool	SaveScene( char* path ) = 0;
	virtual bool	SaveGeom( char* tex_path, char* scn_path, char* pip_path ) = 0;
	virtual bool	SaveTextureDictionary( char* path, char* usg_path ) = 0;
	virtual bool	SaveCASFlags( char* path ) = 0;
	virtual bool	SaveWeightMap( char* path ) = 0;
	virtual	void	ExpandMultiPassMaterials( void ) = 0;
	virtual	void	SeparateMultiPassMeshes( void ) = 0;
	virtual int		GetPlatformFlags( void ) = 0;
};

IPS2Converter* GetPS2Converter( void );
void ResetPS2Converter( void );

#endif	// __PS2_PS2CONV_H__