#ifndef __LLIST__
#define __LLIST__

#include <assert.h>

template <class T>
struct Link
{
	T data;
	Link<T>* next;
	Link<T>* prev;
};

template <class T>
class LinkList
{
	Link<T>* head;
	Link<T>* tail;
	int      count;
	Link<T>* curpos;
	int      curposIndex;

public:
	LinkList()
	{
		curpos=head=tail=0;
		count=curposIndex=0;
	}

	LinkList(LinkList<T>& list)
	{
		curpos=head=tail=0;
		count=curposIndex=0;

		Link<T>* curNode = list.GetHead();

		while(curNode)
		{
			AddToTail(&curNode->data);
			curNode = curNode->next;
		}
	}

	LinkList<T>& operator = (LinkList<T>& list)
	{
		Clear();

		if (&list==this)
			return *this;

		Link<T>* curNode = list.GetHead();

		while(curNode)
		{
			AddToTail(&curNode->data);
			curNode = curNode->next;
		}

		return *this;
	}

	void Clear()
	{
		Link<T>* CurLink=head;
		Link<T>* tmpLink;

		while(CurLink)
		{
			tmpLink=CurLink->next;
			delete CurLink;
			CurLink=tmpLink;
		}

		head=tail=0;
		count=0;
		curposIndex=0;
	}

	~LinkList()
	{
		Clear();
	}

	inline Link<T>* GetHead() { return head;  }
	inline Link<T>* GetTail() { return tail;  }
	inline int      GetSize() { return count; }

	Link<T>* AddToTail(T* item)
	{
		Link<T>* newLink=new Link<T>;
		newLink->data=*item;
		newLink->prev=tail;
		newLink->next=0;

		if (head==0)
			head=newLink;

		if (tail)
			tail->next=newLink;

		tail=newLink;

		curposIndex = count;
		curpos = tail;
		count++;

		return newLink;
	}

	Link<T>* AddAfterLink(Link<T>* link, T* item)
	{
		if (link)
		{
			Link<T>* newLink=new Link<T>;
			newLink->data=*item;
			newLink->prev=link;
			newLink->next=link->next;

///
			if (link->next)
				link->next->prev = newLink;
///

			link->next=newLink;
	
			if (link==tail)
				tail=newLink;

			curposIndex = count;
			curpos = tail;
			count++;
			return newLink;
		}
		else
		{
			return AddToHead(item);
		}
	}

	Link<T>* Find(T* val)
	{
		Link<T>* curlink = head;

		while(curlink)
		{
			if (curlink->data==*val)
				return curlink;

			curlink=curlink->next;
		}

		return 0;
	}

	Link<T>* Find(bool (*Compare)(T* v1,T* v2),T* value)
	{
		Link<T>* curlink = head;

		while(curlink)
		{
			if (Compare(&curlink->data,value))
				return curlink;

			curlink=curlink->next;
		}

		return 0;
	}

	Link<T>* FindFrom(T* val,Link<T>* link=0)
	{
		Link<T>* curlink;

		if (!link)
			curlink = head;
		else
			curlink = link->next;

		while(curlink)
		{
			if (curlink->data==*val)
				return curlink;

			curlink=curlink->next;
		}

		return 0;
	}

	Link<T>* FindFrom(bool (*Compare)(T* v1,T* v2),T* value,Link<T>* link=0)
	{
		Link<T>* curlink;

		if (!link)
			curlink = head;
		else
			curlink = link->next;

		while(curlink)
		{
			if (Compare(&curlink->data,value))
				return curlink;

			curlink=curlink->next;
		}

		return 0;
	}

	Link<T>* FindRange(T* val,Link<T>* start=0,Link<T>* end=0)
	{
		Link<T>* curlink;

		if (!start)
			start = head;
		else
			curlink = start->next;

		if (!end)
			end = tail;

		while(curlink != end)
		{
			if (curlink->data==*val)
				return curlink;

			curlink = curlink->next;
		}

		return 0;
	}

	Link<T>* FindRange(bool (*Compare)(T* v1,T* v2),T* value,Link<T>* start=0,Link<T>* end=0)
	{
		Link<T>* curlink;

		if (!start)
			start = head;
		else
			curlink = start->next;

		if (!end)
			end = tail;

		while(curlink != end)
		{
			if (Compare(&curlink->data,value))
				return curlink;

			curlink = curlink->next;
		}

		return 0;		
	}

	Link<T>* FindRange(bool (*Compare)(T* v1,T* v2,void*), T* value, Link<T>* start=0, Link<T>* end=0, void* pData=0)
	{
		Link<T>* curlink;

		if (!start)
			start = head;
		else
			curlink = start->next;

		if (!end)
			end = tail;

		while(curlink != end)
		{
			if (Compare(&curlink->data,value,pData))
				return curlink;

			curlink = curlink->next;
		}

		return 0;		
	}

	Link<T>* AddToTail()
	{
		Link<T>* newLink=new Link<T>;
		newLink->prev=tail;
		newLink->next=0;

		if (head==0)
			head=newLink;

		if (tail)
			tail->next=newLink;

		tail=newLink;
		curposIndex = count;
		curpos = tail;
		count++;

		return newLink;
	}

	Link<T>* AddToTailUnique(T* item)
	{
		Link<T>* curlink=head;

		while(curlink)
		{
			if (curlink->data==*item)
				return 0;

			curlink=curlink->next;
		}

		return AddToTail(item);
	}

	Link<T>* AddToTailFindUnique(T* item)
	{
		Link<T>* curlink=head;

		while(curlink)
		{
			if (curlink->data==*item)
				return curlink;

			curlink=curlink->next;
		}

		return AddToTail(item);
	}

	inline Link<T>* AddUnique(T* item)
	{
		return AddToTailUnique(item);
	}

	inline Link<T>* Add(T* item)
	{
		return AddToTail(item);
	}

	inline Link<T>* Add()
	{
		return AddToTail();
	}

	Link<T>* AddToHead(T* item)
	{
		Link<T>* newLink=new Link<T>;
		newLink->data=*item;
		newLink->prev=0;
		newLink->next=head;

		if (tail==0)
			tail=newLink;

		if (head)
			head->prev=newLink;

		head=newLink;
		curposIndex = 0;
		curpos = head;
		count++;

		return newLink;
	}

	void Remove(Link<T>* link)	
	{
		count--;

		// Link is head
		if (link==head)
		{
			if (link==tail)
			{
				head=0;
				tail=0;
				delete link;
				return;
			}
			
			head=link->next;
			link->next->prev=0;
			delete link;
			curposIndex = 0;
			curpos = head;
			return;
		}

		// Link is middle
		if (link!=head && link!=tail)
		{
			link->next->prev=link->prev;
			link->prev->next=link->next;
			delete link;
		}

		// Link is tail
		if (link==tail)
		{
			tail=link->prev;
			link->prev->next=0;
			delete link;
		}

		curposIndex = count-1;
		curpos = tail;
	}

	Link<T>* GetLink(int i)
	{
		curpos=head;

		for(int j=0;j<i;j++)
			curpos=curpos->next;

		return curpos;
	}

	// Append list
	LinkList<T>& operator+= (LinkList<T>& list)
	{
		Link<T>* link = list.GetHead();

		int count = list.count;

		for(int i=0;i<count;i++)
		{
			AddToTail(&link->data);
			link=link->next;
		}

		return *this;	
	}

	LinkList<T>& operator+ (LinkList<T>& list)
	{
		Link<T>* link = list.GetHead();

		int count = list.count;

		for(int i=0;i<count;i++)
		{
			AddToTail(&link->data);
			link=link->next;
		}

		return *this;	
	}

	/*
	T& operator[] (int i)
	{
		curpos=head;

		for(int j=0;j<i;j++)
			curpos=curpos->next;

		return curpos->data;
	}
	*/

	T& operator[] (int i)
	{
		assert(i>-1);

		if (curpos==0)
		{
			curpos=head;
			curposIndex=0;
			return curpos->data;
		}

		assert(curpos!=0);

		if (curposIndex<i)
		{
			int dist=i-curposIndex;

			for(int j=0;j<dist;j++)
			{
				curpos=curpos->next;
				assert(curpos!=0);
			}

			curposIndex=i;
			return curpos->data;
		}

		if (curposIndex>i)
		{
			int dist=curposIndex-i;

			for(int j=0;j<dist;j++)
			{
				curpos=curpos->prev;
				assert(curpos!=0);
			}

			curposIndex=i;
			return curpos->data;
		}

		// curposIndex==i
		return curpos->data;
	}

	int GetIndex(Link<T>* link)
	{
		Link<T>* curlink = head;
		int index = 0;

		while(curlink)
		{
			if (curlink == link)
				return index;
			
			curlink = curlink->next;
			index++;
		}

		return -1;
	}
};

#endif
