//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		NxPNGScripting.cpp
//
//	Description:
//		This file contains the source and functions for the
//		UI for the File Format module NxPNG, 
//
//	Use:
//		Format modules are called from the Save, Save as,
//		and Save a copy dialogs.  If you have extra
//		options (such as quality settings) query for
//		them here.
//
//-------------------------------------------------------------------------------

//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------

#include "PIDefines.h"
#include "NxPNG.h"

//-------------------------------------------------------------------------------
//
//	ReadScriptParamsOnRead
//
//	Checks the parameters against scripting-returned parameters, if any, and
//	updates the globals to match ones provided by the scripting system.
//
//	Inputs:
//		GPtr globals		Pointer to global structure.
//
//	Outputs:
//		returns TRUE		If you should pop your dialog.
//		returns FALSE		If you should not pop your dialog.
//
//		gResult				Will return any fatal error.
//
//-------------------------------------------------------------------------------


Boolean ReadScriptParamsOnRead (GPtr globals)
{
	PIReadDescriptor			token = NULL;
	DescriptorKeyID				key = 0;
	DescriptorTypeID			type = 0;
	OSType						shape = 0, create = 0;
	DescriptorKeyIDArray		array = { NULLID };
	int32						flags = 0;
	OSErr						gotErr = noErr, stickyError = noErr;
	Boolean						returnValue = true;
	
	if (DescriptorAvailable(NULL))
	{ /* playing back.  Do our thing. */
		token = OpenReader(array);
		if (token)
		{
			while (PIGetKey(token, &key, &type, &flags))
			{
				switch (key)
				{
					case keyMyFoo:
						PIGetBool(token, &gFooRead);
						break;					// check keys here
				}
			}

			stickyError = CloseReader(&token); // closes & disposes.
				
			if (stickyError)
			{
				if (stickyError == errMissingParameter) // missedParamErr == -1715
					;
					/* (descriptorKeyIDArray != NULL)
					   missing parameter somewhere.  Walk IDarray to find which one. */
				else
					gResult = stickyError;
			}
		}
		
		returnValue = PlayDialog();
		/* return TRUE if want to show our Dialog */		
	}
	
	return returnValue;
}
		
//-------------------------------------------------------------------------------
//
//	ReadScriptParamsOnWrite
//
//	Checks the parameters against scripting-returned parameters, if any, and
//	updates the globals to match ones provided by the scripting system.
//
//	Inputs:
//		GPtr globals		Pointer to global structure.
//
//	Outputs:
//		returns TRUE		If you should pop your dialog.
//		returns FALSE		If you should not pop your dialog.
//
//		gResult				Will return any fatal error.
//
//-------------------------------------------------------------------------------


Boolean ReadScriptParamsOnWrite (GPtr globals)
{
	PIReadDescriptor			token = NULL;
	DescriptorKeyID				key = 0;
	DescriptorTypeID			type = 0;
	OSType						shape = 0, create = 0;
	DescriptorKeyIDArray		array = { NULLID };
	int32						flags = 0;
	OSErr						gotErr = noErr, stickyError = noErr;
	Boolean						returnValue = true;
	
	if (DescriptorAvailable(NULL))
	{ /* playing back.  Do our thing. */
		token = OpenReader(array);
		if (token)
		{
			while (PIGetKey(token, &key, &type, &flags))
			{
				switch (key)
				{
					case keyMyBar:
							PIGetBool(token, &gBarWrite);
							break;
					// check other keys here
				}
			}

			stickyError = CloseReader(&token); // closes & disposes.
				
			if (stickyError)
			{
				if (stickyError == errMissingParameter) // missedParamErr == -1715
					;
					/* (descriptorKeyIDArray != NULL)
					   missing parameter somewhere.  Walk IDarray to find which one. */
				else
					gResult = stickyError;
			}
		}
		
		returnValue = PlayDialog();
		/* return TRUE if want to show our Dialog */		
	}
	
	return returnValue;
}

//-------------------------------------------------------------------------------
//
//	WriteScriptParamsOnRead
//
//	Takes our parameters from our global variables and writes them out to the
//	scripting system, which hands it all back to the host.
//
//	Inputs:
//		GPtr globals			Pointer to global structure.
//
//		Boolean gFooRead		Boolean to write to scripting system.
//
//	Outputs:
//		returns an OSErr		If there was a serious error.
//		returns noErr			If everything worked fine.
//
//-------------------------------------------------------------------------------

OSErr WriteScriptParamsOnRead (GPtr globals)
{
	PIWriteDescriptor			token = nil;
	OSErr						gotErr = noErr;
			
	if (DescriptorAvailable(NULL))
	{ /* recording.  Do our thing. */
		token = OpenWriter();
		if (token)
		{
			// write keys here
			PIPutBool(token, keyMyFoo, gFooRead);
			gotErr = CloseWriter(&token); /* closes and sets dialog optional */
			/* done.  Now pass handle on to Photoshop */
		}
	}
	return gotErr;
}

		
//-------------------------------------------------------------------------------
//
//	WriteScriptParamsOnWrite
//
//	Takes our parameters from our global variables and writes them out to the
//	scripting system, which hands it all back to the host.
//
//	Inputs:
//		GPtr globals			Pointer to global structure.
//
//		Boolean gBarWrite		Boolean to write to scripting system.
//
//	Outputs:
//		returns an OSErr		If there was a serious error.
//		returns noErr			If everything worked fine.
//
//-------------------------------------------------------------------------------

OSErr WriteScriptParamsOnWrite (GPtr globals)
{
	PIWriteDescriptor			token = nil;
	OSErr						gotErr = noErr;
			
	if (DescriptorAvailable(NULL))
	{ /* recording.  Do our thing. */
		token = OpenWriter();
		if (token)
		{
			// write keys here
			PIPutBool(token, keyMyBar, gBarWrite);
			gotErr = CloseWriter(&token); /* closes and sets dialog optional */
			/* done.  Now pass handle on to Photoshop */
		}
	}
	return gotErr;
}

//-------------------------------------------------------------------------------

// end NxPNGScripting.c
