// ADOBE SYSTEMS INCORPORATED
// Copyright  1993 - 2002 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this 
// file in accordance with the terms of the Adobe license agreement
// accompanying it.  If you have received this file from a source
// other than Adobe, then your use, modification, or distribution
// of it requires the prior written permission of Adobe.

#ifndef __PIUSuites_H__		// Has this not been defined yet?
#define __PIUSuites_H__		// Only include this once by predefining it

#include "PITypes.h"
#include "PIGeneral.h"
#include "SPBasic.h"
#include <string.h>

extern SPBasicSuite* sSPBasic;

// A better template for acquiring and release suites.
// Depends on a globally defined sSPBasic pointer.
// Illustrator example
// AutoSuite<AITextPathSuite> sAITextPath(kAITextPathSuite, kAITextPathSuiteVersion);
// AutoSuite will throw on bad access
// if you were using MySuite switch to AutoSuite
template<class T> class AutoSuite
{
private:
	T* suite;
	const long suiteVersion;
	const char* suiteName;
	SPErr error;
	// T& operator*(); // don't write this but maybe this would be it{ return *suite; }

	// make sure the compiler doesn't create this
	AutoSuite();
	
	void AcquireSuite(void)
	{		
		if (sSPBasic != NULL)
		{
			error = sSPBasic->AcquireSuite(suiteName, 
				                           suiteVersion, 
				 						   (const void**)&suite);
			if (error) throw((OSType)error);
		}
		else
		{
			throw((OSType)kSPBadParameterError);
		}
	}

public:
	AutoSuite(const char* name, const long version) : 
	  suite(NULL), suiteName(name), suiteVersion(version), error(0)
	{ }

	~AutoSuite()
	{
		Unload();
	}

	const T* operator->()
	{ 
		if (suite == NULL)
			AcquireSuite();
		return suite; 
	}

	const T* operator*()
	{
		if (suite == NULL)
			AcquireSuite();
		return suite;
	}
	
	void Unload(void)
	{
		if (suite != NULL && suiteName != NULL && sSPBasic != NULL)
		{
			sSPBasic->ReleaseSuite(suiteName, suiteVersion);
			suite = NULL;
		}
	}
	
	bool IsNull(){ return (suite == NULL); }
	SPErr GetError() { return error; }
};

typedef struct
{
	char*	name;
	int16	version;
	void**	suitePtr;
} _AcquireList;

void PIUSuitesRelease(_AcquireList *suitesToRelease, int16 numSuites);
SPErr PIUSuitesAcquire(_AcquireList *suitesToAcquire, int16 numSuites);

#endif
// end PIUSuites.h