// NetToolTemp.cpp : Defines the entry point for the application.
//

#include "stdafx.h"

#include <Stdlib.h>
#include <Sk/Gamenet/ExportMsg.h>
#include <core/defines.h>
#include <sys/timer.h>
#include <gel/mainloop.h>

#include <gel/net/net.h>
#include <gel/net/server/netserv.h>
#include <gel/net/client/netclnt.h>
//#include <core/target.h>

#define MAINLOOP_MEMMARKER 16
#define __SAMPLE_SEND__
#define __WIN32_APP_BUILD__

//static	Spt::SingletonPtr< Tgt::Manager >	*tgt_manager;
static	Spt::SingletonPtr< Mlp::Manager >	*mlp_manager;
static	Spt::SingletonPtr< Net::Manager >	*net_manager;

Net::Client* gClient;


static	void	net_setup( void )
{
	char* server_ip;

	net_manager = new Spt::SingletonPtr< Net::Manager > ( true );
	gClient = (*net_manager)->CreateNewAppClient( 0, "NExt Max4", Net::vEXPORT_COMM_PORT, inet_addr((*net_manager)->GetLocalIP()),
										Net::App::mACCEPT_FOREIGN_CONN );
	
	server_ip = getenv( vSERVER_IP_VARIABLE );
	if( server_ip == NULL )
	{
		MessageBox( NULL, "You must set up your VIEWER_IP environment variable if you want real-time updates",
						"Warning", MB_OK|MB_TASKMODAL);		
	}
	else
	{
		Net::Conn* conn;

		gClient->ConnectToServer( inet_addr( server_ip ), Net::vEXPORT_COMM_PORT );
		conn = gClient->NewConnection( inet_addr( server_ip ), Net::vEXPORT_COMM_PORT );
	}
}

static void		engine_setup( void )
{
	Dbg::SetUp();
	Mem::Manager::sSetUp();
	Mem::Manager::sHandle().BottomUpHeap()->PushContext();
	Mem::Manager::sHandle().PushMemoryMarker(MAINLOOP_MEMMARKER);	
	mlp_manager = new Spt::SingletonPtr< Mlp::Manager > ( true );
}

#ifdef __WIN32_APP_BUILD__

static	CHAR		app_name[] = "NetTool";
static	HWND		wnd;

LONG WINAPI wnd_proc ( HWND, UINT , WPARAM , LPARAM );

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	MSG				msg;
	bool			done;

	WNDCLASS		wc;
	
	/* Register the frame class */
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc   = ( WNDPROC ) wnd_proc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = LoadIcon ( hInstance , app_name );
    wc.hCursor       = LoadCursor ( NULL,IDC_ARROW );
    wc.hbrBackground = ( HBRUSH ) ( COLOR_WINDOW + 1 );
    wc.lpszMenuName  = app_name;
    wc.lpszClassName = app_name;

    if ( !RegisterClass ( &wc ) )
	{
        return FALSE;
	}
	
    wnd = CreateWindow ( app_name, app_name, 
			 WS_OVERLAPPEDWINDOW,
			 0 , 0 , 640 , 480,
			 NULL , NULL , hInstance , NULL );

    if ( !wnd )
	{
        return FALSE;
	}

    ShowWindow ( wnd , nCmdShow );
    UpdateWindow ( wnd );

 	engine_setup();
	net_setup();	

// EXAMPLE OF SENDING A NETWORK MESSAGE TO THE SERVER
#ifdef __SAMPLE_SEND__
	Net::MsgQuickview net_msg;
	sprintf( net_msg.m_Filename, "default" );
	gClient->EnqueueMessageToServer( Net::vMSG_ID_QUICKVIEW, sizeof( Net::MsgQuickview ),
										&net_msg );
#endif	// __SAMPLE_SEND__
	done = false;
	while ( !done )
	{
        while ( PeekMessage ( &msg , NULL , 0 , 0 , PM_NOREMOVE ) == TRUE ) 
		{
            if ( GetMessage ( &msg , NULL , 0 , 0 ) ) 
			{
                TranslateMessage ( &msg );
                DispatchMessage ( &msg );
            } 
			else 
			{
				done = true;
				break;
            }			
		}		
		
		(*mlp_manager)->DoGameLogic();
	}

	return 0;
}



LONG WINAPI wnd_proc ( HWND h_wnd, UINT u_msg, WPARAM w_param, LPARAM l_param)
{
	LONG ret = 1;
    
	switch ( u_msg )
	{	

    case WM_SIZE:
        break;

    case WM_CLOSE:
        DestroyWindow ( h_wnd );
        break;

    case WM_DESTROY:
        PostQuitMessage ( 0 );
        break;
	}
	
	ret = DefWindowProc ( h_wnd , u_msg , w_param , l_param );
    return ret;
}

#else

void	main( void )
{
	engine_setup();
	net_setup();

	while(1)
	{
		// EXAMPLE OF SENDING A NETWORK MESSAGE TO THE SERVER
#ifdef __SAMPLE_SEND__
		Net::MsgQuickview msg;
		sprintf( msg.m_Filename, "Test.scn.ps2" );
		gClient->EnqueueMessageToServer( Net::vMSG_ID_QUICKVIEW, sizeof( Net::MsgQuickview ),
											&msg );
#endif	// __SAMPLE_SEND__


		(*mlp_manager)->DoGameLogic();
	}

}

#endif	// __WIN32_APP_BUILD__


