#ifndef __CORE_DEFINES_H
#include "core/defines.h"
#endif

#ifndef	__SCRIPTING_SCRIPT_H
#include "gel/scripting/script.h"
#endif

// Used when extracting 4 bytes from a .qb, where the 4 bytes could represent
// different types of thing.
struct S4Bytes
{
    union
    {
        uint32 mChecksum;
		uint32 mUInt;
        int mInt;
        float mFloat;
    };
};

// Same, but for 2 bytes.
struct S2Bytes
{
    union
    {
		uint16 mUInt;
        sint16 mInt;
    };
};

S4Bytes Read4Bytes(const uint8 *p_long);
S2Bytes Read2Bytes(const uint8 *p_short);
uint8 *Write4Bytes(uint8 *p_buffer, uint32 val);
uint8 *Write4Bytes(uint8 *p_buffer, float floatVal);
uint8 *Write2Bytes(uint8 *p_buffer, uint16 val);

extern int WM_DEBUGGER_HELP;
extern int WM_DEBUGGER_REFRESH;
extern int WM_DEBUGGER_INSERT;
extern int WM_DEBUGGER_DELETE;

class CMyTreeEntry;
class CMyTreeCtrl;
uint8 *InsertCStructIntoTree(CMyTreeCtrl *p_tree, CMyTreeEntry *p_parent, uint8 *p_struct_data);
uint8 *InsertCArrayIntoTree(CMyTreeCtrl *p_tree, CMyTreeEntry *p_parent, uint8 *p_array_data);

const char *GetObjectTypeName(int type);
const char *GetWaitTypeName(Script::EWaitType waitType);
const char *GenerateFullQFileName(const char *p_name);
const char *GetSingleStepModeName(Script::ESingleStepMode mode);
void ConvertKeyPressToMessage(UINT nChar, CWnd *p_window);
uint32 ConvertHexStringToUint32(const char *p_hex);
uint32 ConvertNameToChecksum(const char *p_name);
void RequestObjectInfo(const char *p_object_name);
void RequestScriptGlobalInfo(const char *p_name);
void SetBreakpointOnScript(uint32 script_name);
void ParseTreeEntryText(CString text);
void BringUpHelpFile(const char *p_name);

