#pragma once

#include "mylistview.h"

// CObjectListView view

class CObjectListView : public CMyListView
{
	DECLARE_DYNCREATE(CObjectListView)

protected:
	CObjectListView();           // protected constructor used by dynamic creation
	virtual ~CObjectListView();

	void OnInitialUpdate();

	static HWND s_window;

public:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	static HWND sGetWindow();

protected:
	afx_msg LRESULT OnObjectList(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnRefreshObjectList(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
public:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg LRESULT OnHelp(WPARAM wParam, LPARAM lParam);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
};


