// MonitorView.h : interface of the CMonitorView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MONITORVIEW_H__B3226328_BAD1_4A71_9946_2DAE25EBE909__INCLUDED_)
#define AFX_MONITORVIEW_H__B3226328_BAD1_4A71_9946_2DAE25EBE909__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __CORE_DEFINES_H
#include "core/defines.h"
#endif

#ifndef	__SCRIPTING_SCRIPT_H
#include "gel/scripting/script.h"
#endif

class CDebuggerButton;
class CMyTreeCtrl;

enum
{
	MAX_FILE_NAME_CHARS=200,
	MAX_INFO_BAR_CHARS=1024,
};

// Contains file name and line number info.
// An array of these exists, one for each callstack entry, so that when the
// callstack entry is selected in the tree control the edit window can display
// that file and highlight the appropriate line.
struct SCallstackEntry
{
	char mpFullFilename[MAX_FILE_NAME_CHARS+1];
	int mLineNumber;
};

class CMonitorView : public CView
{
protected: // create from serialization only
	CMonitorView();
	DECLARE_DYNCREATE(CMonitorView)

// Attributes
public:
	CMonitorDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMonitorView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMonitorView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	void OnInitialUpdate();

protected:

	// The id of this script view window, which matches the m_unique_id member
	// of the CScript in the game.
	uint32 m_id;

	void get_window_position(CWnd *p_window, RECT *p_rect);
	bool adjust_positions();

	int m_spinner;
	void update_spinner();
	const char *get_spinner();

	char mp_info_bar_text[MAX_INFO_BAR_CHARS+1];
	CRichEditCtrl *mp_info;
	
	CRichEditCtrl *mp_edit;
	int m_edit_old_width;
	int m_edit_old_height;

	CDebuggerButton *mp_button_stop;
	CDebuggerButton *mp_button_step_into;
	CDebuggerButton *mp_button_step_over;
	CDebuggerButton *mp_button_go;

	int m_slider_pos;
	void handle_new_slider_pos(int new_pos);
	CSliderCtrl *mp_auto_step_speed;

	CMyTreeCtrl *mp_tree_function_params;
	int m_params_old_width;
	int m_params_old_height;

	CMyTreeCtrl *mp_tree_callstack;
	int m_callstack_old_width;
	int m_callstack_old_height;

	uint32 *add_to_callstack_tree(int entryIndex, uint32 *p_data);

	int m_current_displayed_callstack_entry;
	char mp_edit_window_current_file_name[MAX_FILE_NAME_CHARS+1];
	enum
	{
		UPDATE_HIGHLIGHT_ONLY_IF_CHANGED=0,
		DO_UPDATE_HIGHLIGHT
	};
	void update_file_window(bool update_highlight=UPDATE_HIGHLIGHT_ONLY_IF_CHANGED);

	int m_num_callstack_entries;
	// Note: MAX_RETURN_ADDRESSES is defined in gel\scripting\script.h in the game code.
	// The +1 is because in the script debugger we are including the current 
	// program counter location as a callstack entry for convenience since it fits in nicely
	// with the tree display. In the actual CScript, the current PC will not be an entry
	// in the callstack, since it only holds return addresses.
	enum
	{
		MAX_CALLSTACK_ENTRIES=MAX_RETURN_ADDRESSES+1,
	};
	SCallstackEntry mp_callstack_entries[MAX_CALLSTACK_ENTRIES];

// Generated message map functions
protected:
	//{{AFX_MSG(CMonitorView)
	afx_msg LRESULT OnWatchInfo(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnBasicScriptInfo(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnStopScript(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnStepInto(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnStepOver(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnGo(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnChangeFile(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnScriptDied(WPARAM wParam, LPARAM lParam);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
};

#ifndef _DEBUG  // debug version in MonitorView.cpp
inline CMonitorDoc* CMonitorView::GetDocument()
   { return (CMonitorDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MONITORVIEW_H__B3226328_BAD1_4A71_9946_2DAE25EBE909__INCLUDED_)
