// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "Monitor.h"
#include "MainFrm.h"
#include "mycode.h"
#include "../monitormouse/monitormouse.h"
#include "sk/gamenet/scriptdebugger.h"
#include "engine.h"

extern CMonitorApp theApp;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_COPYDATA()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	m_mouse_cursor_on_game_screen=false;
	m_pc_screen_width=0;
	m_pc_screen_height=0;
	m_pc_single_monitor_width=0;
	m_is_dual_monitor=false;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	m_bCreated = FALSE;

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMDIFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

BOOL CMainFrame::PreTranslateMessage(MSG* pMsg)
{
	return false;
}

enum
{
	GAME_SCREEN_WIDTH=640,
	GAME_SCREEN_HEIGHT=480
};

bool CMainFrame::is_at_edge_of_pc_screen(int pc_mouse_x)
{
	if (gMouseEdgeIsOnLeft)
	{
		return pc_mouse_x==0;
	}
	else
	{
		return pc_mouse_x==m_pc_screen_width-1;
	}
}

int CMainFrame::wrap_pc_mouse_x()
{
	if (gMouseEdgeIsOnLeft)
	{
		return (GAME_SCREEN_WIDTH-2)*((double)m_pc_single_monitor_width)/GAME_SCREEN_WIDTH;
	}
	else
	{
		if (m_is_dual_monitor)
		{
			return m_pc_single_monitor_width+(2)*((double)m_pc_single_monitor_width)/GAME_SCREEN_WIDTH;
		}
		else
		{
			return (2)*((double)m_pc_single_monitor_width)/GAME_SCREEN_WIDTH;
		}
	}
}

bool CMainFrame::is_at_edge_of_game_screen(int game_x)
{
	if (gMouseEdgeIsOnLeft)
	{
		return game_x >= GAME_SCREEN_WIDTH-1;
	}
	else
	{
		return game_x <= 0;
	}
}

int CMainFrame::restore_pc_mouse_x()
{
	if (gMouseEdgeIsOnLeft)
	{
		return 1;
	}
	else
	{
		return m_pc_screen_width-2;
	}
}

void CMainFrame::transform_pc_coords_to_game_coords(int new_pc_x, int new_pc_y, int *p_game_x, int *p_game_y)
{
	if (m_is_dual_monitor)
	{
		if (gMouseEdgeIsOnLeft)
		{
			*p_game_x=(((double)new_pc_x)*GAME_SCREEN_WIDTH)/m_pc_single_monitor_width;
			*p_game_y=(((double)new_pc_y)*GAME_SCREEN_HEIGHT)/m_pc_screen_height;
		}
		else
		{
			*p_game_x=(((double)(new_pc_x-m_pc_single_monitor_width))*GAME_SCREEN_WIDTH)/m_pc_single_monitor_width;
			*p_game_y=(((double)new_pc_y)*GAME_SCREEN_HEIGHT)/m_pc_screen_height;
		}
	}
	else
	{
		*p_game_x=(((double)new_pc_x)*GAME_SCREEN_WIDTH)/m_pc_single_monitor_width;
		*p_game_y=(((double)new_pc_y)*GAME_SCREEN_HEIGHT)/m_pc_screen_height;
	}
}

// TODO
// Get game screen width/height using defines in the game code?
// Switch on/off PC cursor better ...

// This gets called when the MonitorMouse.dll intercepts mouse events.
BOOL CMainFrame::OnCopyData(CWnd* pWnd, COPYDATASTRUCT* pCopyDataStruct) 
{
	SMouseInfo* p_info=(SMouseInfo*)pCopyDataStruct->lpData;

	if (p_info->mMouseProcCode==HC_ACTION)
	{
		// Get the PC screen width and height.
		m_pc_screen_width=GetSystemMetrics(SM_CXSCREEN);
		m_pc_screen_height=GetSystemMetrics(SM_CYSCREEN);

		// Check whether they are using a dual monitor setup by checking
		// the aspect ratio, assuming that a dual monitor would have a ratio
		// bigger than 16:9
		if (((double)m_pc_screen_width)/m_pc_screen_height > 16.0f/9.0f)
		{
			// Dual monitor, so get the width of one screen by dividing by 2.
			m_pc_single_monitor_width=m_pc_screen_width/2;
			m_is_dual_monitor=true;
		}
		else
		{
			m_pc_single_monitor_width=m_pc_screen_width;
			m_is_dual_monitor=false;
		}

		int new_pc_x=p_info->mMouseHookStruct.pt.x;
		int new_pc_y=p_info->mMouseHookStruct.pt.y;
		int game_x=0;
		int game_y=0;

		// Decide whether to transition to the game screen
		if (!m_mouse_cursor_on_game_screen)
		{
			// The mouse transitions to the game screen as soon as the pc
			// mouse touches the left side.
			if (is_at_edge_of_pc_screen(new_pc_x))
			{
				m_mouse_cursor_on_game_screen=true;
				// Now recalculate new_pc_x so that it is at the right side of
				// the pc screen but such that when game_x is calculated from it 
				// in the code a bit further down, it will be no bigger 
				// than GAME_SCREEN_WIDTH-2.
				// We don't want game_x to be GAME_SCREEN_WIDTH-1 right away, 
				// because that is the criteria for switching back to the pc screen,
				// and it would just switch back straight away otherwise.
				new_pc_x=wrap_pc_mouse_x();
				SetCursorPos(new_pc_x,new_pc_y);
				ShowCursor(FALSE);

				// Now, the pc mouse cursor is invisible, but at the right side
				// of the pc screen, and free to move around the screen.
				// We are going to scale its position to the game screen,
				// and make the game draw a new cursor.
				// Also, any button events are going to be masked off from windows
				// whilst on the game screen.
				
				// Send a message to the game indicating that the mouse is on screen,
				// so that the game can set a flag indicating to accept mouse position
				// messages.
				Net::MsgDesc msg;
				msg.m_Id = GameNet::vMSG_ID_DBG_MOUSE_ON_SCREEN;
				gClient->EnqueueMessageToServer(&msg);
			}
		}

		// If on the game screen, calculate the game screen coordinates.
		if (m_mouse_cursor_on_game_screen)
		{
			// Scale the pc coords to the game screen.
			transform_pc_coords_to_game_coords(new_pc_x,new_pc_y,&game_x,&game_y);

			// Check whether to transition from the game screen to the PC screen
			// Note that we need a >= rather than a == because on a dual monitor
			// setup game_x could be made to be greater than GAME_SCREEN_WIDTH-1
			if (is_at_edge_of_game_screen(game_x))
			{
				// The cursor has moved back to the PC screen.
				m_mouse_cursor_on_game_screen=false;
				// Note that we make the pc mouse cursor reappear at x=1 rather
				// than x=0 because x==0 is the criteria for switching to the
				// game screen, and it would switch back straight away otherwise.
				new_pc_x=restore_pc_mouse_x();
				SetCursorPos(new_pc_x,new_pc_y);
				ShowCursor(TRUE);

				// Send a message to the game indicating that the cursor has gone off screen.
				// This is so that the game can set a flag indicating to ignore any further
				// mouse position messages.
				// This is necessary because some mouse position messages may arrive late,
				// and if the game did not ignore them they would cause the mouse cursor to 
				// reappear.
				Net::MsgDesc msg;
				msg.m_Id = GameNet::vMSG_ID_DBG_MOUSE_OFF_SCREEN;
				gClient->EnqueueMessageToServer(&msg);
			}
		}


		if (m_mouse_cursor_on_game_screen)
		{
			// Send a mouse-position message to the game.
			sint16 p_data[2];
			p_data[0]=game_x;
			p_data[1]=game_y;

			Net::MsgDesc msg;
			msg.m_Length=4;
			msg.m_Data=p_data;
			msg.m_Id = GameNet::vMSG_ID_DBG_MOUSE_POSITION;
			// Note: Perhaps there will be less apparent lag if we use StreamMessageToServer
			// instead? The lag may be due to the queued messages arriving out of order ...
			gClient->EnqueueMessageToServer(&msg);


			switch (p_info->mMouseProcWParam)
			{
				// Send a message to the game if the left mouse button is pressed.
				case WM_LBUTTONDOWN:
				// Also have to check for non-client area button down events, which
				// happen when the button is clicked when the mouse is over a title
				// bar or frame boundary etc.
				case WM_NCLBUTTONDOWN:
					msg.m_Id = GameNet::vMSG_ID_DBG_MOUSE_LEFT_BUTTON_DOWN;
					msg.m_Length=0;
					msg.m_Data=NULL;
					gClient->EnqueueMessageToServer(&msg);
					break;

				// Same for if the button is released.
				case WM_LBUTTONUP:
				case WM_NCLBUTTONUP:
					msg.m_Id = GameNet::vMSG_ID_DBG_MOUSE_LEFT_BUTTON_UP;
					msg.m_Length=0;
					msg.m_Data=NULL;
					gClient->EnqueueMessageToServer(&msg);
					break;

				// and same again for the right button.
				case WM_RBUTTONUP:
				case WM_NCRBUTTONUP:
					msg.m_Id = GameNet::vMSG_ID_DBG_MOUSE_RIGHT_BUTTON_UP;
					msg.m_Length=0;
					msg.m_Data=NULL;
					gClient->EnqueueMessageToServer(&msg);
					break;

				case WM_RBUTTONDOWN:
				case WM_NCRBUTTONDOWN:
					msg.m_Id = GameNet::vMSG_ID_DBG_MOUSE_RIGHT_BUTTON_DOWN;
					msg.m_Length=0;
					msg.m_Data=NULL;
					gClient->EnqueueMessageToServer(&msg);
					break;

				default:
					break;
			}
		}
	}

	if (m_mouse_cursor_on_game_screen)
	{
		// Returning TRUE so as to prevent any mouse events getting to
		// the PC windows when the mouse cursor is on the game screen, otherwise
		// things will get very confusing.
		return TRUE;
	}

	return CMDIFrameWnd::OnCopyData(pWnd, pCopyDataStruct);
}
