// DebuggerButton.cpp : implementation file
//

#include "stdafx.h"
#include "monitor.h"
#include "DebuggerButton.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDebuggerButton

CDebuggerButton::CDebuggerButton(int messageToSendToParent)
{
	m_message=messageToSendToParent;

	m_toggleable=false;
	m_state=false;
}

CDebuggerButton::~CDebuggerButton()
{
}

void CDebuggerButton::SetToggleable()
{
	m_toggleable=true;
	m_state=false;
	// Call the MFC CButton::SetState function to ensure the button is in the up position.
	SetState(FALSE);
}

void CDebuggerButton::SetNotToggleable()
{
	m_toggleable=false;
	m_state=false;
	// Call the MFC CButton::SetState function to ensure the button is in the up position.
	SetState(FALSE);
}

BEGIN_MESSAGE_MAP(CDebuggerButton, CButton)
	//{{AFX_MSG_MAP(CDebuggerButton)
	ON_CONTROL_REFLECT(BN_CLICKED, OnClicked)
	//}}AFX_MSG_MAP
	ON_WM_PAINT()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDebuggerButton message handlers

void CDebuggerButton::OnClicked() 
{
	// If toggleable, toggle the m_state value.
	// Doing this before sending the message to the parent so that the parent's
	// message handler will read the correct value for m_state.
	if (m_toggleable)
	{
		m_state=!m_state;
	}

	GetParent()->SendMessage(m_message);

	// Set the focus back to the parent, otherwise F5 button events won't get
	// through to it.
	GetParent()->SetFocus();
}

// Here I am using the button's paint message to update the up/down state of the
// button so that it matches the value of m_state.
// I had tried for ages to get button toggling working by setting the up/down state
// of the button inside the parent's message handler code.
// However, that did not work, because it seems that immediately after the 'clicked'
// message is handled, windows will then set the state of the button again, but it will
// notice that I had changed it and will get confused and send another clicked message.
// So I needed to find a message that always gets sent to the button after it gets 
// clicked on, so that I could add code to it to update the button state.
// The paint message seems a good one to use, and it works.
void CDebuggerButton::OnPaint()
{
	//CPaintDC dc(this); // device context for painting
	// TODO: Add your message handler code here
	// Do not call CButton::OnPaint() for painting messages

	// Make sure that the button up/down state reflects that of m_state
	if (m_toggleable)
	{
		// Note: SetState is an MFC function belonging to CButton
		SetState(m_state);
	}

	// Note: Even though the auto-generated comment at the top of this function
	// says not to call CButton::OnPaint(), it does not work properly if I don't.
	// If I just call CPaintDC dc(this) like they say, then the buttons do not appear
	// when first created, they only appear when clicked on for the first time.
	// Calling CButton::OnPaint() fixes that, and does not seem to cause any other 
	// problems. CButton::OnPaint() would be called anyway if I had not added this handler, 
	// all I've done is make the little bit of code above get called first, and I think
	// the code is safe, it's not like it is doing any funky low-level painting stuff.
	CButton::OnPaint();
}
