#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
//#include <Image/Image.h>
#include "png.h"

#define streams		1
#define hilevel		1
#define entire		1

void __cdecl nx_png_warning(png_structp png_ptr, png_const_charp message)
{
	DebugPrint( "PNG Warning: %s\n", message );
}

/* Read a PNG file.  You may want to return an error code if the read
 * fails (depending upon the failure).  There are two "prototypes" given
 * here - one where we are given the filename, and we need to open the
 * file, and the other where we are given an open file (possibly with
 * some or all of the magic bytes read - see comments above).
 */
bool read_png( char *file_name, png_structp* in_png_ptr, png_infop* in_info_ptr )  /* We need to open the file */
{
   png_structp png_ptr;
   png_infop info_ptr;
   unsigned int sig_read = 0;      
   FILE *fp;

   if(( fp = fopen( file_name, "rb" )) == NULL )
   {
      return false;
   }

   /* Create and initialize the png_struct with the desired error handler
    * functions.  If you want to use the default stderr and longjump method,
    * you can supply NULL for the last three parameters.  We also supply the
    * the compiler header file version, so that we know if the application
    * was compiled with a compatible version of the library.  REQUIRED
    */
   *in_png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, nx_png_warning );
      //(png_voidp) user_error_ptr, user_error_fn, user_warning_fn);
   png_ptr = *in_png_ptr;

   if (png_ptr == NULL)
   {
      fclose(fp);
      return false;
   }

   /* Allocate/initialize the memory for image information.  REQUIRED. */
   *in_info_ptr = png_create_info_struct(png_ptr);
   info_ptr = *in_info_ptr;
   if (info_ptr == NULL)
   {
      fclose(fp);
      png_destroy_read_struct(&png_ptr, (png_infopp)NULL, (png_infopp)NULL);
      return false;
   }

   /* Set error handling if you are using the setjmp/longjmp method (this is
    * the normal method of doing things with libpng).  REQUIRED unless you
    * set up your own error handlers in the png_create_read_struct() earlier.
    */

   if (setjmp(png_jmpbuf(png_ptr)))
   {
      /* Free all of the memory associated with the png_ptr and info_ptr */
      png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
      fclose(fp);
      /* If we get here, we had a problem reading the file */
      return false;
   }

   /* One of the following I/O initialization methods is REQUIRED */
#ifdef streams /* PNG file I/O method 1 */
   /* Set up the input control if you are using standard C streams */
   png_init_io(png_ptr, fp);

#else no_streams /* PNG file I/O method 2 */
   /* If you are using replacement read functions, instead of calling
    * png_init_io() here you would call:
    */
   png_set_read_fn(png_ptr, (void *)user_io_ptr, user_read_fn);
   /* where user_io_ptr is a structure you want available to the callbacks */
#endif no_streams /* Use only one I/O method! */

   /* If we have already read some of the signature */
   png_set_sig_bytes(png_ptr, sig_read);

#ifdef hilevel
   /*
    * If you have enough memory to read in the entire image at once,
    * and you need to specify only transforms that can be controlled
    * with one of the PNG_TRANSFORM_* bits (this presently excludes
    * dithering, filling, setting background, and doing gamma
    * adjustment), then you can read the entire image (including
    * pixels) into the info structure with this call:
    */
      
   png_read_png(png_ptr, info_ptr, 0, NULL);
#else
   /* OK, you're doing it the hard way, with the lower-level functions */

   /* The call to png_read_info() gives us all of the information from the
    * PNG file before the first IDAT (image data chunk).  REQUIRED
    */
   png_read_info(png_ptr, info_ptr);

   png_get_IHDR(png_ptr, info_ptr, &width, &height, &bit_depth, &color_type,
       &interlace_type, NULL, NULL);

/**** Set up the data transformations you want.  Note that these are all
 **** optional.  Only call them if you want/need them.  Many of the
 **** transformations only work on specific types of images, and many
 **** are mutually exclusive.
 ****/

   /* tell libpng to strip 16 bit/color files down to 8 bits/color */
   png_set_strip_16(png_ptr);

   /* Strip alpha bytes from the input data without combining with the
    * background (not recommended).
    */
   png_set_strip_alpha(png_ptr);

   /* Extract multiple pixels with bit depths of 1, 2, and 4 from a single
    * byte into separate bytes (useful for paletted and grayscale images).
    */
   png_set_packing(png_ptr);

   /* Change the order of packed pixels to least significant bit first
    * (not useful if you are using png_set_packing). */
   png_set_packswap(png_ptr);

   /* Expand paletted colors into true RGB triplets */
   if (color_type == PNG_COLOR_TYPE_PALETTE)
      png_set_palette_rgb(png_ptr);

   /* Expand grayscale images to the full 8 bits from 1, 2, or 4 bits/pixel */
   if (color_type == PNG_COLOR_TYPE_GRAY && bit_depth < 8)
      png_set_gray_1_2_4_to_8(png_ptr);

   /* Expand paletted or RGB images with transparency to full alpha channels
    * so the data will be available as RGBA quartets.
    */
   if (png_get_valid(png_ptr, info_ptr, PNG_INFO_tRNS))
      png_set_tRNS_to_alpha(png_ptr);

   /* Set the background color to draw transparent and alpha images over.
    * It is possible to set the red, green, and blue components directly
    * for paletted images instead of supplying a palette index.  Note that
    * even if the PNG file supplies a background, you are not required to
    * use it - you should use the (solid) application background if it has one.
    */

   png_color_16 my_background, *image_background;

   if (png_get_bKGD(png_ptr, info_ptr, &image_background))
      png_set_background(png_ptr, image_background,
                         PNG_BACKGROUND_GAMMA_FILE, 1, 1.0);
   else
      png_set_background(png_ptr, &my_background,
                         PNG_BACKGROUND_GAMMA_SCREEN, 0, 1.0);

   /* Some suggestions as to how to get a screen gamma value */

   /* Note that screen gamma is the display_exponent, which includes
    * the CRT_exponent and any correction for viewing conditions */
   if (/* We have a user-defined screen gamma value */)
   {
      screen_gamma = user-defined screen_gamma;
   }
   /* This is one way that applications share the same screen gamma value */
   else if ((gamma_str = getenv("SCREEN_GAMMA")) != NULL)
   {
      screen_gamma = atof(gamma_str);
   }
   /* If we don't have another value */
   else
   {
      screen_gamma = 2.2;  /* A good guess for a PC monitors in a dimly
                              lit room */
      screen_gamma = 1.7 or 1.0;  /* A good guess for Mac systems */
   }

   /* Tell libpng to handle the gamma conversion for you.  The final call
    * is a good guess for PC generated images, but it should be configurable
    * by the user at run time by the user.  It is strongly suggested that
    * your application support gamma correction.
    */

   int intent;

   if (png_get_sRGB(png_ptr, info_ptr, &intent))
      png_set_gamma(png_ptr, screen_gamma, 0.45455);
   else
   {
      double image_gamma;
      if (png_get_gAMA(png_ptr, info_ptr, &image_gamma))
         png_set_gamma(png_ptr, screen_gamma, image_gamma);
      else
         png_set_gamma(png_ptr, screen_gamma, 0.45455);
   }

   /* Dither RGB files down to 8 bit palette or reduce palettes
    * to the number of colors available on your screen.
    */
   if (color_type & PNG_COLOR_MASK_COLOR)
   {
      int num_palette;
      png_colorp palette;

      /* This reduces the image to the application supplied palette */
      if (/* we have our own palette */)
      {
         /* An array of colors to which the image should be dithered */
         png_color std_color_cube[MAX_SCREEN_COLORS];

         png_set_dither(png_ptr, std_color_cube, MAX_SCREEN_COLORS,
            MAX_SCREEN_COLORS, NULL, 0);
      }
      /* This reduces the image to the palette supplied in the file */
      else if (png_get_PLTE(png_ptr, info_ptr, &palette, &num_palette))
      {
         png_uint_16p histogram;

         png_get_hIST(png_ptr, info_ptr, &histogram);

         png_set_dither(png_ptr, palette, num_palette,
                        max_screen_colors, histogram, 0);
      }
   }

   /* invert monochrome files to have 0 as white and 1 as black */
   png_set_invert_mono(png_ptr);

   /* If you want to shift the pixel values from the range [0,255] or
    * [0,65535] to the original [0,7] or [0,31], or whatever range the
    * colors were originally in:
    */
   if (png_get_valid(png_ptr, info_ptr, PNG_INFO_sBIT))
   {
      png_color_8p sig_bit;

      png_get_sBIT(png_ptr, info_ptr, &sig_bit);
      png_set_shift(png_ptr, sig_bit);
   }

   /* flip the RGB pixels to BGR (or RGBA to BGRA) */
   if (color_type & PNG_COLOR_MASK_COLOR)
      png_set_bgr(png_ptr);

   /* swap the RGBA or GA data to ARGB or AG (or BGRA to ABGR) */
   png_set_swap_alpha(png_ptr);

   /* swap bytes of 16 bit files to least significant byte first */
   png_set_swap(png_ptr);

   /* Add filler (or alpha) byte (before/after each RGB triplet) */
   png_set_filler(png_ptr, 0xff, PNG_FILLER_AFTER);

   /* Turn on interlace handling.  REQUIRED if you are not using
    * png_read_image().  To see how to handle interlacing passes,
    * see the png_read_row() method below:
    */
   number_passes = png_set_interlace_handling(png_ptr);

   /* Optional call to gamma correct and add the background to the palette
    * and update info structure.  REQUIRED if you are expecting libpng to
    * update the palette for you (ie you selected such a transform above).
    */
   png_read_update_info(png_ptr, info_ptr);

   /* Allocate the memory to hold the image using the fields of info_ptr. */

   /* The easiest way to read the image: */
   png_bytep row_pointers[height];

   for (row = 0; row < height; row++)
   {
      row_pointers[row] = png_malloc(png_ptr, png_get_rowbytes(png_ptr,
         info_ptr));
   }

   /* Now it's time to read the image.  One of these methods is REQUIRED */
#ifdef entire /* Read the entire image in one go */
   png_read_image(png_ptr, row_pointers);

#else no_entire /* Read the image one or more scanlines at a time */
   /* The other way to read images - deal with interlacing: */

   for (pass = 0; pass < number_passes; pass++)
   {
#ifdef single /* Read the image a single row at a time */
      for (y = 0; y < height; y++)
      {
         png_read_rows(png_ptr, &row_pointers[y], NULL, 1);
      }

#else no_single /* Read the image several rows at a time */
      for (y = 0; y < height; y += number_of_rows)
      {
#ifdef sparkle /* Read the image using the "sparkle" effect. */
         png_read_rows(png_ptr, &row_pointers[y], NULL, number_of_rows);
#else no_sparkle /* Read the image using the "rectangle" effect */
         png_read_rows(png_ptr, NULL, &row_pointers[y], number_of_rows);
#endif no_sparkle /* use only one of these two methods */
      }

      /* if you want to display the image after every pass, do
         so here */
#endif no_single /* use only one of these two methods */
   }
#endif no_entire /* use only one of these two methods */

   /* read rest of file, and get additional chunks in info_ptr - REQUIRED */
   png_read_end(png_ptr, info_ptr);
#endif hilevel

   /* At this point you have read the entire image */

   /* clean up after the read, and free any memory allocated - REQUIRED */
   //png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);

   /* close the file */
   fclose(fp);

   /* that's it */
   return true;
}

bool NxTexture::load_png( char* path, int mip_level )
{
	png_structp png_ptr;
	png_infop info_ptr;

	if( read_png( path, &png_ptr, &info_ptr ))
	{	
		bool has_trans_chunk;
		int pixel_data_size, palette_data_size, bytes_per_row;
		char* dst;
		int i;

		has_trans_chunk = false;
		// Check if this image has a valid transparency chunk
		if( png_get_valid(png_ptr, info_ptr, PNG_INFO_tRNS ))
		{
			has_trans_chunk = true;
		}

		m_width[mip_level] = info_ptr->width;
		m_height[mip_level] = info_ptr->height;
		switch( info_ptr->color_type )
		{			
			case PNG_COLOR_TYPE_PALETTE:			
				if( mip_level == 0 )
				{
					if( has_trans_chunk )
					{
						m_palette_format = v32_BIT;					
						m_palette_bpp = 32;
					}
					else
					{
						m_palette_format = v24_BIT;
						m_palette_bpp = 24;
					}
				}
				
				if( info_ptr->bit_depth == 1 )
				{					
					//pixel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 3;
					pixel_data_size = m_height[mip_level] * info_ptr->rowbytes;
					m_texel_data[mip_level] = new char[pixel_data_size];
					m_pixel_format[mip_level] = v1_BIT;					
					m_bpp[mip_level] = 1;
					
					if( mip_level == 0 )
					{
						m_num_palette_entries = 2;
						palette_data_size = m_num_palette_entries * ( m_palette_bpp >> 3 );
						m_palette_data = new char[palette_data_size];					
					}
				}
				else if( info_ptr->bit_depth == 2 )
				{		
					//pixel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 2;
					pixel_data_size = m_height[mip_level] * info_ptr->rowbytes;
					m_texel_data[mip_level] = new char[pixel_data_size];
					m_pixel_format[mip_level] = v2_BIT;					
					m_bpp[mip_level] = 2;

					if( mip_level == 0 )
					{
						m_num_palette_entries = 4;
						palette_data_size = m_num_palette_entries * ( m_palette_bpp >> 3 );
						m_palette_data = new char[palette_data_size];
					}					
				}
				else if( info_ptr->bit_depth == 4 )
				{
					//pixel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 1;
					pixel_data_size = m_height[mip_level] * info_ptr->rowbytes;
					m_texel_data[mip_level] = new char[pixel_data_size];
					m_pixel_format[mip_level] = v4_BIT;					
					m_bpp[mip_level] = 4;

					if( mip_level == 0 )
					{
						m_num_palette_entries = 16;
						palette_data_size = m_num_palette_entries * ( m_palette_bpp >> 3 );
						m_palette_data = new char[palette_data_size];
					}					
				}
				else if( info_ptr->bit_depth == 8 )
				{					
					//pixel_data_size = m_width[mip_level] * m_height[mip_level];
					pixel_data_size = m_height[mip_level] * info_ptr->rowbytes;
					m_texel_data[mip_level] = new char[pixel_data_size];
					m_pixel_format[mip_level] = v8_BIT;					
					m_bpp[mip_level] = 8;

					if( mip_level == 0 )
					{
						m_num_palette_entries = 256;
						palette_data_size = m_num_palette_entries * ( m_palette_bpp >> 3 );
						m_palette_data = new char[palette_data_size];										
					}
				}
				else
				{
					return false;
				}

				// First copy texel data
				dst = m_texel_data[mip_level];
				for( i = m_height[mip_level] - 1; i >= 0; i-- )
				{
					memcpy( dst, info_ptr->row_pointers[i], info_ptr->rowbytes );
					dst += info_ptr->rowbytes;
				}

				// We need to re-order the nibbles in < 8-bit PNGs
				if( m_pixel_format[mip_level] == v4_BIT )
				{
					int size;

					size = GetTexelDataSize( mip_level );
					dst = m_texel_data[mip_level];
					for( i = 0; i < size; i++ )
					{
						unsigned char byte, lo_nibble;
						
						byte = *dst;
						lo_nibble = byte & 0x0F;
						byte >>= 4;
						byte |= ( lo_nibble << 4 );
						*dst++ = byte;
					}
				}
				else if( m_pixel_format[mip_level] == v2_BIT )
				{					
					char* new_texels;
					char* new_palette;
					int prev_palette_entries, prev_texel_data_size;					
					char* src;

					// Convert 2-bit textures to 4-bit textures
					
					//prev_texel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 2;					
					prev_texel_data_size = pixel_data_size;
					bytes_per_row = (( m_width[mip_level] * 4 ) + 7 ) >> 3;					
					//pixel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 1;
					pixel_data_size = m_height[mip_level] * bytes_per_row;
					
					m_pixel_format[mip_level] = v4_BIT;					
					new_texels = new char[pixel_data_size];					
				
					if( mip_level == 0 )
					{
						prev_palette_entries = m_num_palette_entries;
						m_num_palette_entries = 16;
						palette_data_size = m_num_palette_entries * ( m_palette_bpp >> 3 );					
						new_palette = new char[palette_data_size];
					}

					dst = new_texels;
					src = m_texel_data[mip_level];
					for( i = 0; i < prev_texel_data_size; i++ )
					{
						unsigned char byte, color;

						byte = *src;
						//color = byte & 0x03;
						color = (byte & 0xC0) >> 6;
						*dst = color;
						byte <<= 2;
						color = (byte & 0xC0) >> 6;
						*dst |= ( color << 4 );
						//*dst |= color;
						dst++;
						byte <<= 2;
						color = (byte & 0xC0) >> 6;
						*dst = color;
						byte <<= 2;
						color = (byte & 0xC0) >> 6;
						*dst |= ( color << 4 );
						//*dst |= color;
						dst++;
						src++;
					}					


					if( mip_level == 0 )
					{
						delete [] m_palette_data;
						m_palette_data = new_palette;
					}

					delete [] m_texel_data[mip_level];
					m_texel_data[mip_level] = new_texels;			

					m_bpp[mip_level] = 4;
				}
				else if( m_pixel_format[mip_level] == v1_BIT )
				{			
					char* new_texels;
					char* new_palette;
					int prev_palette_entries, prev_texel_data_size;					
					char* src;
					
					// Convert 1-bit textures to 4-bit textures
					//prev_texel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 3;
					prev_texel_data_size = pixel_data_size;
					bytes_per_row = (( m_width[mip_level] * 4 ) + 7 ) >> 3;					
					pixel_data_size = m_height[mip_level] * bytes_per_row;					
					//pixel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 1;
					
					m_pixel_format[mip_level] = v4_BIT;					
					new_texels = new char[pixel_data_size];
					
					if( mip_level == 0 )
					{
						prev_palette_entries = m_num_palette_entries;
						m_num_palette_entries = 16;
						palette_data_size = m_num_palette_entries * ( m_palette_bpp >> 3 );
						new_palette = new char[palette_data_size];										
					}

					dst = new_texels;
					src = m_texel_data[mip_level];
					for( i = 0; i < prev_texel_data_size; i++ )
					{
						unsigned char byte, color;

						byte = *src;
						color = byte & 0x01;
						//*dst = ( color << 4 );
						*dst = color;
						byte >>= 1;
						color = byte & 0x01;
						//*dst |= color;
						*dst |= ( color << 4 );
						dst++;
						byte >>= 1;
						color = byte & 0x01;
						//*dst = ( color << 4 );
						*dst = color;
						byte >>= 1;
						color = byte & 0x01;
						//*dst |= color;
						*dst |= ( color << 4 );
						dst++;
						byte >>= 1;
						color = byte & 0x01;
						//*dst = ( color << 4 );
						*dst = color;
						byte >>= 1;
						color = byte & 0x01;
						//*dst |= color;
						*dst |= ( color << 4 );
						dst++;
						byte >>= 1;
						color = byte & 0x01;
						//*dst = ( color << 4 );
						*dst = color;
						byte >>= 1;
						color = byte & 0x01;
						//*dst |= color;
						*dst |= ( color << 4 );
						dst++;
						src++;
					}					

					if( mip_level == 0 )
					{
						delete [] m_palette_data;
						m_palette_data = new_palette;
					}

					delete [] m_texel_data[mip_level];
					m_texel_data[mip_level] = new_texels;					

					m_bpp[mip_level] = 4;
				}

				if( mip_level == 0 )
				{
					// Now copy palette data
					dst = m_palette_data;
					for( i = 0; i < m_num_palette_entries; i++ )
					{
						if( i < info_ptr->num_palette )
						{
							*dst++ = info_ptr->palette[i].red;
							*dst++ = info_ptr->palette[i].green;
							*dst++ = info_ptr->palette[i].blue;
						}
						else
						{
							*dst++ = 0;
							*dst++ = 0;
							*dst++ = 0;
						}
						if( has_trans_chunk )
						{
							if( i < png_ptr->num_trans )
							{
								*dst++ = png_ptr->trans[i];
							}
							else
							{
								*dst++ = (char) 255;
							}
						}					
					}					
				}
				break;

			case PNG_COLOR_TYPE_RGB:
				pixel_data_size = m_width[mip_level] * m_height[mip_level] * 3;
				m_texel_data[mip_level] = new char[pixel_data_size];
				m_pixel_format[mip_level] = v24_BIT;				
				m_bpp[mip_level] = 24;
				m_palette_bpp = 0;
				// Copy texel data
				dst = m_texel_data[mip_level];
				for( i = m_height[mip_level] - 1; i >= 0; i-- )
				{
					memcpy( dst, info_ptr->row_pointers[i], info_ptr->rowbytes );
					dst += info_ptr->rowbytes;
				}
				break;

			case PNG_COLOR_TYPE_RGBA:
				pixel_data_size = m_width[mip_level] * m_height[mip_level] * 4;
				m_texel_data[mip_level] = new char[pixel_data_size];
				m_pixel_format[mip_level] = v32_BIT;
				m_bpp[mip_level] = 32;
				m_palette_bpp = 0;
				// Copy texel data
				dst = m_texel_data[mip_level];
				for( i = m_height[mip_level] - 1; i >= 0; i-- )
				{
					memcpy( dst, info_ptr->row_pointers[i], info_ptr->rowbytes );
					dst += info_ptr->rowbytes;
				}
				break;				
			
			case PNG_COLOR_TYPE_GRAY:
			{
				// If a grayscale image has alpha, convert it to a paletted image with alpha.
				// Otherwise, leave it as grayscale and let the backend tool decide whether
				// or not to convert it to a paletted, equivalent texture.

				// **** UPDATE
				// I'm going to wait on this task. For now, we'll do the conversion here, but later
				// we may choose to preserve grayscale images and let the backend tool make the
				// conversion decision

				m_grayscale = true;
				if( mip_level == 0 )
				{
					if( has_trans_chunk )
					{
						m_palette_format = v32_BIT;					
						m_palette_bpp = 32;
					}
					else
					{
						m_palette_format = v24_BIT;					
						m_palette_bpp = 24;
					}
				}

				if( info_ptr->bit_depth == 8 )
				{						
					pixel_data_size = m_width[mip_level] * m_height[mip_level];
					m_texel_data[mip_level] = new char[pixel_data_size];
					m_pixel_format[mip_level] = v8_BIT;					
					m_bpp[mip_level] = 8;					

					if( mip_level == 0 )
					{
						m_num_palette_entries = 256;
						palette_data_size = m_num_palette_entries * ( m_palette_bpp >> 3 );
						m_palette_data = new char[palette_data_size];					
					}				
				}
				else if( info_ptr->bit_depth == 4 )
				{
					//pixel_data_size = ( m_width[mip_level] * m_height[mip_level] ) / 2;
					pixel_data_size = m_height[mip_level] * info_ptr->rowbytes;
					m_texel_data[mip_level] = new char[pixel_data_size];
					m_pixel_format[mip_level] = v4_BIT;					
					m_bpp[mip_level] = 4;					

					if( mip_level == 0 )
					{
						m_num_palette_entries = 16;
						palette_data_size = m_num_palette_entries * ( m_palette_bpp >> 3 );
						m_palette_data = new char[palette_data_size];
					}
				}
				else if( info_ptr->bit_depth == 2 )
				{						
					//pixel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 2;
					pixel_data_size = m_height[mip_level] * info_ptr->rowbytes;
					m_texel_data[mip_level] = new char[pixel_data_size];
					m_pixel_format[mip_level] = v2_BIT;
					m_bpp[mip_level] = 2;					
				}				
				else if( info_ptr->bit_depth == 1 )
				{
					//pixel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 3;
					pixel_data_size = m_height[mip_level] * info_ptr->rowbytes;
					m_texel_data[mip_level] = new char[pixel_data_size];
					m_pixel_format[mip_level] = v1_BIT;
					m_bpp[mip_level] = 1;					
				}
				else
				{
					return false;
				}

				// First copy texel data
				dst = m_texel_data[mip_level];
				for( i = m_height[mip_level] - 1; i >= 0; i-- )
				{
					memcpy( dst, info_ptr->row_pointers[i], info_ptr->rowbytes );
					dst += info_ptr->rowbytes;
				}

				// We need to re-order the nibbles in 4-bit PNGs
				if( m_pixel_format[mip_level] == v4_BIT )
				{
					int size;

					size = GetTexelDataSize( mip_level );
					dst = m_texel_data[mip_level];
					for( i = 0; i < size; i++ )
					{
						unsigned char byte, lo_nibble;
						
						byte = *dst;
						lo_nibble = byte & 0x0F;
						byte >>= 4;
						byte |= ( lo_nibble << 4 );
						*dst++ = byte;
					}
				}
				else if( m_pixel_format[mip_level] == v2_BIT )
				{					
					char* new_texels;
					int prev_texel_data_size;					
					char* src;

					if( mip_level == 0 )
					{
						m_num_palette_entries = 16;
						palette_data_size = m_num_palette_entries * ( m_palette_bpp >> 3 );
						m_palette_data = new char[palette_data_size];
					}

					// Convert 2-bit textures to 4-bit textures
					//prev_texel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 2;					
					prev_texel_data_size = pixel_data_size;
					bytes_per_row = (( m_width[mip_level] * 4 ) + 7 ) >> 3;					
					pixel_data_size = m_height[mip_level] * bytes_per_row;
					//pixel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 1;
					
					m_pixel_format[mip_level] = v4_BIT;					
					new_texels = new char[pixel_data_size];
					
					dst = new_texels;
					src = m_texel_data[mip_level];
					for( i = 0; i < prev_texel_data_size; i++ )
					{
						unsigned char byte, color;

						byte = *src;
						color = byte & 0x03;
						*dst = color;
						byte >>= 2;
						color = byte & 0x03;
						*dst |= ( color << 4 );
						dst++;
						byte >>= 2;
						color = byte & 0x03;
						*dst = color;
						byte >>= 2;
						color = byte & 0x03;
						*dst |= ( color << 4 );
						dst++;
						src++;						
					}					

					delete [] m_texel_data[mip_level];
					m_texel_data[mip_level] = new_texels;					

					m_bpp[mip_level] = 4;
				}
				else if( m_pixel_format[mip_level] == v1_BIT )
				{			
					char* new_texels;
					int prev_texel_data_size;					
					char* src;
					
					// Convert 1-bit textures to 4-bit textures
					if( mip_level == 0 )
					{
						m_num_palette_entries = 16;
						palette_data_size = m_num_palette_entries * ( m_palette_bpp >> 3 );
						m_palette_data = new char[palette_data_size];
					}

					//prev_texel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 3;
					//pixel_data_size = ( m_width[mip_level] * m_height[mip_level] ) >> 1;
					prev_texel_data_size = pixel_data_size;
					bytes_per_row = (( m_width[mip_level] * 4 ) + 7 ) >> 3;					
					pixel_data_size = m_height[mip_level] * bytes_per_row;					
					
					m_pixel_format[mip_level] = v4_BIT;					
					new_texels = new char[pixel_data_size];
					
					dst = new_texels;
					src = m_texel_data[mip_level];
					for( i = 0; i < prev_texel_data_size; i++ )
					{
						unsigned char byte, color;

						byte = *src;
						color = byte & 0x01;
						//*dst = ( color << 4 );
						*dst = color;
						byte >>= 1;
						color = byte & 0x01;
						//*dst |= color;
						*dst |= ( color << 4 );
						dst++;
						byte >>= 1;
						color = byte & 0x01;
						//*dst = ( color << 4 );
						*dst = color << 4;
						byte >>= 1;
						color = byte & 0x01;
						//*dst |= color;
						*dst |= ( color << 4 );
						dst++;
						byte >>= 1;
						color = byte & 0x01;
						//*dst = ( color << 4 );
						*dst = color;
						byte >>= 1;
						color = byte & 0x01;
						//*dst |= color;
						*dst |= ( color << 4 );
						dst++;
						byte >>= 1;
						color = byte & 0x01;
						//*dst = ( color << 4 );
						*dst = color;
						byte >>= 1;
						color = byte & 0x01;
						//*dst |= color;
						*dst |= ( color << 4 );
						dst++;
						src++;
					}					

					delete [] m_texel_data[mip_level];
					m_texel_data[mip_level] = new_texels;
					
					m_bpp[mip_level] = 4;
				}

				// Now construct the palette data for the (previously) grayscale images
				if( mip_level == 0 )
				{
					dst = m_palette_data;
					if( info_ptr->bit_depth == 1 )
					{
						for( i = 0; i < 2; i++ )
						{
							*dst++ = i * 255;
							*dst++ = i * 255;
							*dst++ = i * 255;
							if( has_trans_chunk )
							{
								if( i < png_ptr->num_trans )
								{
									*dst++ = png_ptr->trans[i];
								}
								else
								{
									*dst++ = (char) 255;
								}
							}
						}					
					}
					else if( info_ptr->bit_depth == 2 )
					{
						for( i = 0; i < 4; i++ )
						{
							*dst++ = ( 255 / 3 ) * i;
							*dst++ = ( 255 / 3 ) * i;
							*dst++ = ( 255 / 3 ) * i;
							if( has_trans_chunk )
							{
								if( i < png_ptr->num_trans )
								{
									*dst++ = png_ptr->trans[i];
								}
								else
								{
									*dst++ = (char) 255;
								}
							}
						}					
					}
					else
					{
						for( i = 0; i < m_num_palette_entries; i++ )
						{	
							unsigned char entry;
							
							entry = ( 255 / ( m_num_palette_entries - 1 )) * i;						
							*dst++ = entry;
							*dst++ = entry;
							*dst++ = entry;
							if( has_trans_chunk )
							{
								if( i < png_ptr->num_trans )
								{
									*dst++ = png_ptr->trans[i];
								}
								else
								{
									*dst++ = (char) 255;
								}
							}					
						}
					}
				}
				break;
			}

			case PNG_COLOR_TYPE_GA:				
			{
				char error_msg[256];
			
				sprintf( error_msg, "Could not load %s. It is a 32-bit Grayscale image.  It should be paletted instead.", path );
				MessageBox( gInterface->GetMAXHWnd(), error_msg, "Error!", MB_OK );

				m_grayscale = true;
				
				return false;
			}

			default:			
			{
				char error_msg[256];
			
				sprintf( error_msg, "Could not load %s. It is using an unsupported image type.", path );
				MessageBox( gInterface->GetMAXHWnd(), error_msg, "Error!", MB_OK );

				return false;
				//png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
				//break;
			}
		}
		
		png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
		return true;
	}
	
	return false;
}
