#include "FuncEnter.h"

/*
	OptFile.cpp
	Optional File UI control used for Cutscene Exporter
*/

#include "OptFile.h"
#include "../PropEdit/ParseFuncs.h"

// Button IDs
#define CUSTIDC_BUTTON    1
#define CUSTIDC_COMBOLIST 2
#define CUSTIDC_EDIT      3

extern Interface* gInterface;

OptFile::OptFile(HINSTANCE hInstance) :
	UIControl(hInstance, CLASS)
{ FUNC_ENTER("OptFile::OptFile"); 
	hFont = CreateFont(14,0,0,0,0,0,0,0,0,0,0,0, VARIABLE_PITCH | FF_SWISS, "");
	IEdit = NULL;
}

OptFile::~OptFile()
{ FUNC_ENTER("OptFile::~OptFile"); 
	SaveConfigFile();
	
	if (hFont)
		DeleteObject(hFont);

	if (IEdit)
		ReleaseICustEdit(IEdit);

	DestroyWindow(hwndFileButton);
}

void OptFile::BuildControlUI()
{ FUNC_ENTER("OptFile::BuildControlUI"); 
	RECT wndRect;
	GetClientRect(hwnd,&wndRect);

	int width = wndRect.right - wndRect.left;

	hwndFileButton = CreateWindow("button",
		                          "F",
							      WS_CHILD|WS_VISIBLE,
							      width-10,
							      0,
							      10,
							      wndRect.bottom - wndRect.top,
							      hwnd,
							      (HMENU)CUSTIDC_BUTTON,
							      hInstance,
							      NULL);

	hwndList = CreateWindow("combobox",
		                    "",
							WS_CHILD|CBS_DROPDOWN|CBS_SORT|WS_VSCROLL|WS_VISIBLE,
							width-30,
							0,
							20,
							wndRect.bottom - wndRect.top + 200,
							hwnd,
							(HMENU)CUSTIDC_COMBOLIST,
							hInstance,
							NULL);

	SendMessage(hwndList, CB_SETDROPPEDWIDTH, (WPARAM)200, 0);
	SendMessage(hwndList, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(FALSE, 0));

	hwndEdit = CreateWindow("CustEdit",
		                    "",
							WS_CHILD|WS_VISIBLE,
							0,
							0,
							width-30,
							wndRect.bottom - wndRect.top,
							hwnd,
							(HMENU)CUSTIDC_EDIT,
							hInstance,
							NULL);

	IEdit = GetICustEdit(hwndEdit);
	IEdit->WantDlgNextCtl(TRUE);

	ReadConfigFile();
}

HWND OptFile::GetFocusWindow()
{ FUNC_ENTER("OptFile::GetFocusWindow"); 
	return hwndEdit;
}

void OptFile::AddUnique(char* buf)
{ FUNC_ENTER("OptFile::AddUnique"); 
	int count = SendMessage(hwndList, CB_GETCOUNT, 0, 0);

	CStr newBuf = buf;
	newBuf.toLower();
	char listbuf[1024];

	for(int i = 0; i < count; i++)
	{
		SendMessage(hwndList, CB_GETLBTEXT, (WPARAM)i, (LPARAM)listbuf);
		lcase(listbuf);

		if (strcmp(listbuf, newBuf)==0)
			return;
	}

	SendMessage(hwndList, CB_ADDSTRING, 0, (LPARAM)buf);
}

LRESULT OptFile::WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{ FUNC_ENTER("OptFile::WndProc"); 
	switch(msg)
	{
	case WM_CUSTEDIT_ENTER:
		{
			char buf[1024];
			IEdit->GetText(buf, 1023);
			AddUnique(buf);
			SaveConfigFile();
		}
		return TRUE;

	case WM_KILLFOCUS:
		{
			char buf[1024];
			IEdit->GetText(buf, 1023);
			AddUnique(buf);
			break;
		}

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case CUSTIDC_BUTTON:
			FileDlg();
			break;
		}

		switch(HIWORD(wParam))
		{
		case CBN_SELCHANGE:
			{
				char buf[1024];
				int idx = SendMessage(hwndList, CB_GETCURSEL, 0, 0);
				SendMessage(hwndList, CB_GETLBTEXT, (WPARAM)idx, (LPARAM)buf);
				IEdit->SetText(buf);
			}
			//break;	// Intentional fall through (Sel change should notify)

		case EN_CHANGE:
			{
				// Notify the parent window that an update has occurred
				HWND hwndParent = GetParent(hwnd);
				int  ID         = (int)GetWindowLong(hwnd,GWL_ID);

				SendMessage(hwndParent,WM_CHILDUPDATED,(WPARAM)ID,0);
			}
			break;
		}
		break;
	}

	return UIControl::WndProc(hwnd, msg, wParam, lParam);
	//return DefWindowProc(hwnd, msg, wParam, lParam);
}

void OptFile::FileDlg()
{ FUNC_ENTER("OptFile::FileDlg"); 
	OPENFILENAME ofn;
	char filename[256]="";

	ofn.lStructSize=sizeof(ofn);
	ofn.hwndOwner=gInterface->GetMAXHWnd();
	ofn.hInstance=hInstance;
	ofn.lpstrFilter= filter;
	ofn.lpstrCustomFilter=NULL;
	ofn.nMaxCustFilter=0;
	ofn.nFilterIndex=0;
	ofn.lpstrFile=filename;
	ofn.nMaxFile=256;
	ofn.lpstrFileTitle=NULL;
	ofn.nMaxFileTitle=128;
	ofn.lpstrInitialDir = rootDir;
	ofn.lpstrTitle= caption;
	ofn.Flags=OFN_LONGNAMES|OFN_ENABLESIZING;
	ofn.nFileOffset=0;
	ofn.nFileExtension=0;
	ofn.lpstrDefExt=TEXT("");
	ofn.lCustData=0;
	ofn.lpfnHook=NULL;
	ofn.lpTemplateName=NULL;

	GetOpenFileName(&ofn);
	
	if (filename[0])
	{
		CStr fname = filename;
		fname.toLower();

		value = ReplaceStr(fname, rootDir, "");
		IEdit->SetText(value);

		AddUnique(value);
		SaveConfigFile();

		// Notify the parent window that an update has occurred
		HWND hwndParent = GetParent(hwnd);
		int  ID         = (int)GetWindowLong(hwnd,GWL_ID);

		SendMessage(hwndParent,WM_CHILDUPDATED,(WPARAM)ID,0);
	}
}

void OptFile::SetValue(char* val)
{ FUNC_ENTER("OptFile::SetValue"); 
	value = val;
	IEdit->SetText(value);

	// Notify the parent window that an update has occurred
	HWND hwndParent = GetParent(hwnd);
	int  ID         = (int)GetWindowLong(hwnd,GWL_ID);

	SendMessage(hwndParent,WM_CHILDUPDATED,(WPARAM)ID,0);
}

CStr OptFile::GetValue()
{ FUNC_ENTER("OptFile::GetValue"); 
	if (IEdit)
	{
		char buf[1024];
		IEdit->GetText(buf, 1023);
		return CStr(buf);
	}
	else
		return value;
}

void OptFile::SetRoot(char* root)
{ FUNC_ENTER("OptFile::SetRoot"); 
	rootDir = root;
	rootDir.toLower();
}

void OptFile::SetCaption(char* txt)
{ FUNC_ENTER("OptFile::SetCaption"); 
	caption = txt;
}

void OptFile::SetFilter(const char* txt)
{ FUNC_ENTER("OptFile::SetFilter"); 
	filter = txt;
}

void OptFile::SetConfigFile(char* txt)
{ FUNC_ENTER("OptFile::SetConfigFile"); 
	configFile = txt;
}

void OptFile::ReadConfigFile()
{ FUNC_ENTER("OptFile::ReadConfigFile"); 
	FILE* fp = fopen(configFile, "r");

	if (fp)
	{
		char buf[1024];
		int  len;

		while(!feof(fp))
		{
			if (fgets(buf, 1023, fp))
			{
				len = strlen(buf);

				if (len > 0)
				{
					if (len-1 >= 0)
						if (buf[len-1] == 10)
							buf[len-1] = 0;

					SendMessage(hwndList, CB_ADDSTRING, 0, (LPARAM)buf);
				}
			}
		}

		fclose(fp);
	}
}

void OptFile::SaveConfigFile()
{ FUNC_ENTER("OptFile::SaveConfigFile"); 
	FILE* fp = fopen(configFile, "w");

	if (!fp)
		return;

	int count = SendMessage(hwndList, CB_GETCOUNT, 0, 0);

	char buf[1024];
	for(int i = 0; i < count; i++)
	{
		SendMessage(hwndList, CB_GETLBTEXT, (WPARAM)i, (LPARAM)buf);
		fprintf(fp, "%s\n", buf);
	}

	fclose(fp);
}
