#include "FuncEnter.h"

/*
	MtlSelect.cpp
	A material selection control
	8-1-01
*/

#include "MtlSelect.h"
#define CUSTIDC_BUTTON 1

extern Interface* gInterface;

MtlSelect::MtlSelect(HINSTANCE hInstance,HWND hwnd) :
	UIControl(hInstance, CLASS)
{ FUNC_ENTER("MtlSelect::MtlSelect"); 
	
}

MtlSelect::MtlSelect(HINSTANCE hInstance) :
	UIControl(hInstance, CLASS)
{ FUNC_ENTER("MtlSelect::MtlSelect"); 

}

MtlSelect::MtlSelect(MtlSelect& right) :
	UIControl(right.hInstance, CLASS)
{ FUNC_ENTER("MtlSelect::MtlSelect"); 
	hwndButton = NULL;
	value = right.value;
}

MtlSelect& MtlSelect::operator = (MtlSelect& right)
{ FUNC_ENTER("MtlSelect::operator="); 
	hwndButton = NULL;
	SetValue(right.GetValue());

	return *this;
}

void MtlSelect::BuildControlUI()
{ FUNC_ENTER("MtlSelect::BuildControlUI"); 
	RECT wndRect;
	GetClientRect(hwnd,&wndRect);

	hwndButton = CreateWindow("button",
		                      "",
							  WS_CHILD|WS_VISIBLE,
							  0,
							  0,
							  wndRect.right - wndRect.left,
							  wndRect.bottom - wndRect.top,
							  hwnd,
							  (HMENU)CUSTIDC_BUTTON,
							  hInstance,
							  NULL);
}

LRESULT MtlSelect::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("MtlSelect::WndProc"); 
	switch(msg)
	{
	case WM_CREATE:
		SetValue(value);
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case CUSTIDC_BUTTON:
			DoMtlSelect();
			return TRUE;
		}
	}

	return DefWindowProc(hwnd,msg,wParam,lParam);
}

void MtlSelect::DoMtlSelect()
{ FUNC_ENTER("MtlSelect::DoMtlSelect"); 
	MtlBase* mtl;
	BOOL     bNewMtl;
	BOOL     bCancel;

	mtl = gInterface->DoMaterialBrowseDlg(hwnd, BROWSE_MATSONLY | BROWSE_INSTANCEONLY, bNewMtl, bCancel);
	
	if (mtl)
	{
		if (!bCancel)
		{
			SetValue(mtl->GetName());
		}
	}
}

void MtlSelect::SetValue(CStr name)
{ FUNC_ENTER("MtlSelect::SetValue"); 
	value = name;
	SetWindowText(hwndButton,(char*)name);
}

CStr MtlSelect::GetValue()
{ FUNC_ENTER("MtlSelect::GetValue"); 
	char buf[256];
	GetWindowText(hwndButton,buf,255);

	return CStr(buf);
}
