#include "FuncEnter.h"

/*
	ListView.h
	Management class for ListView controls

	1-7-01
*/

#include "ListView.h"
#include "max.h"		// Included for MatchPattern

ListView::ListView(HWND hwnd)
{ FUNC_ENTER("ListView::ListView"); 
	this->hwnd=hwnd;

	numCol=0;
	numItems=0;
	curCol=0;
	curRow=0;

	fpSort=NULL;

	// Send notification when the user clicks on an item
	ListView_SetExtendedListViewStyle(hwnd,LVS_EX_FULLROWSELECT|LVS_EX_HEADERDRAGDROP);
	//ListView_SetExtendedListViewStyle(hwnd,LVS_EX_ONECLICKACTIVATE);
}

ListView::~ListView()
{ FUNC_ENTER("ListView::~ListView"); 

}

bool ListView::AddColumn(char* colName,int colWidth)
{ FUNC_ENTER("ListView::AddColumn"); 
	LVCOLUMN col;
	ZeroMemory(&col,sizeof(LVCOLUMN));
	col.mask=LVCF_TEXT|LVCF_WIDTH;
	col.cx  =colWidth;
	col.pszText=colName;
	col.cchTextMax=strlen(colName);

	if (ListView_InsertColumn(hwnd,numCol,&col)!=-1)
	{
		//ListView_SetColumnWidth(hwnd,numCol,LVSCW_AUTOSIZE_USEHEADER);
		//ListView_SetColumnWidth(hwnd,numCol,100);
		numCol++;
		return true;
	}

	return false;
}

void ListView::ScrollToItem(int index)
{ FUNC_ENTER("ListView::ScrollToItem"); 
	ListView_EnsureVisible(hwnd, index, FALSE);
}

int ListView::AddItem(char* name,int rowIndex)
{ FUNC_ENTER("ListView::AddItem"); 
	LVITEM item;
	ZeroMemory(&item,sizeof(LVITEM));
	item.mask=LVIF_TEXT|LVIF_PARAM;		// Param included to clear field
	item.pszText=name;
	item.cchTextMax=strlen(name);

	if (rowIndex==-1)
		rowIndex=numItems;

	item.iItem=rowIndex;

	curRow=ListView_InsertItem(hwnd,&item);
	curCol=1;
	numItems++;
	return curRow;
}

int ListView::AddSubItem(char* name,int colIndex,int rowIndex)
{ FUNC_ENTER("ListView::AddSubItem"); 
	LVITEM item;
	ZeroMemory(&item,sizeof(LVITEM));
	item.mask=LVIF_TEXT;	
	item.pszText=name;
	item.cchTextMax=strlen(name);

	if (rowIndex==-1)
		rowIndex=curRow;

	if (colIndex==-1)
		colIndex=curCol;

	item.iItem=rowIndex;
	item.iSubItem=colIndex;

	if (ListView_SetItem(hwnd,&item))
	{
		curCol=colIndex+1;
		return colIndex;
	}

	return -1;
}

int ListView::GetSel()
{ FUNC_ENTER("ListView::GetSel"); 
	return ListView_GetSelectionMark(hwnd);
}

int ListView::GetSelItem()
{ FUNC_ENTER("ListView::GetSelItem"); 
	int numSels=GetCount();

	for (int i=0;i<numSels;i++)
	{
		if (IsSelected(i))
			return i;
	}

	return -1;
}

void ListView::SetSel(int index)
{ FUNC_ENTER("ListView::SetSel"); 
	ListView_SetSelectionMark(hwnd,index);
}

void ListView::DeleteItem(int index)
{ FUNC_ENTER("ListView::DeleteItem"); 
	ListView_DeleteItem(hwnd,index);
}

void ListView::GetItem(int index,char* name,int size,int subitem)
{ FUNC_ENTER("ListView::GetItem"); 
	LVITEM item;

	ZeroMemory(&item,sizeof(LVITEM));
	item.mask=LVIF_TEXT;
	item.pszText=name;
	item.cchTextMax=size;
	item.iItem=index;
	item.iSubItem=subitem;

	ListView_GetItem(hwnd,&item);
}

int ListView::Find(char* name, int field)
{ FUNC_ENTER("ListView::Find"); 
	int count = GetCount();

	for(int i=0;i<count;i++)
	{
		char buf[256];
		GetItem(i,buf,256,field);

		if (strcmp(buf,name)==0)
			return i;
	}

	return -1;
}

int ListView::GetCount()
{ FUNC_ENTER("ListView::GetCount"); 
	return ListView_GetItemCount(hwnd);
}

int ListView::GetSelCount()
{ FUNC_ENTER("ListView::GetSelCount"); 
	return ListView_GetSelectedCount(hwnd);
}

int ListView::GetSelCountExplicit()
{ FUNC_ENTER("ListView::GetSelCountExplicit"); 
	int nCount    = GetCount();
	int nSelCount = 0;

	for(int i = 0; i < nCount; i++)
	{
		if (IsSelected(i))
			nSelCount++;
	}

	return nSelCount;
}

bool ListView::IsSelected(int index)
{ FUNC_ENTER("ListView::IsSelected"); 
	LVITEM item;
	ZeroMemory(&item,sizeof(LVITEM));
	item.mask=LVIF_STATE;
	item.iItem=index;
	item.state=0;
	item.stateMask=LVIS_SELECTED;

	ListView_GetItem(hwnd,&item);

	if (item.state & LVIS_SELECTED)
		return true;

	return false;
}

void ListView::Select(int index)
{ FUNC_ENTER("ListView::Select"); 
	ListView_SetItemState(hwnd,index,LVIS_SELECTED,LVIS_SELECTED);
}

void ListView::UnSelect(int index)
{ FUNC_ENTER("ListView::UnSelect"); 
	ListView_SetItemState(hwnd,index,0,LVIS_SELECTED);
}

void ListView::UnSelectAll()
{ FUNC_ENTER("ListView::UnSelectAll"); 
	int count=GetCount();

	for(int i=0;i<count;i++)
		ListView_SetItemState(hwnd,i,0,LVIS_SELECTED);
}

int ListView::GetNextItem(int lastindex,char* name,int size)
{ FUNC_ENTER("ListView::GetNextItem"); 
	int index=ListView_GetNextItem(hwnd,lastindex,LVNI_SELECTED);

	if (index==-1)
		return -1;

	if (name)
		GetItem(index,name,size);

	return index;
}

void ListView::Clear()
{ FUNC_ENTER("ListView::Clear"); 
	ListView_DeleteAllItems(hwnd);

	numCol=0;
	numItems=0;
	curCol=0;
	curRow=0;
}

int ListView::HitTest(int x,int y)
{ FUNC_ENTER("ListView::HitTest"); 
	LVHITTESTINFO htinfo;
	ZeroMemory(&htinfo,sizeof(LVHITTESTINFO));
	htinfo.pt.x=x;
	htinfo.pt.y=y;

	ListView_HitTest(hwnd,&htinfo);
	
	if (htinfo.flags==LVHT_ONITEMICON  ||
		htinfo.flags==LVHT_ONITEMLABEL ||
		htinfo.flags==LVHT_ONITEMSTATEICON)
	{
		return htinfo.iItem;
	}

	return -1;
}

void ListView::SetItemData(int index,DWORD val)
{ FUNC_ENTER("ListView::SetItemData"); 
	LVITEM item;
	ZeroMemory(&item,sizeof(LVITEM));
	item.mask=LVIF_PARAM;
	item.iItem=index;
	item.lParam=(LPARAM)val;

	ListView_SetItem(hwnd,&item);
}

DWORD ListView::GetItemData(int index)
{ FUNC_ENTER("ListView::GetItemData"); 
	LVITEM item;

	ZeroMemory(&item,sizeof(LVITEM));
	item.mask=LVIF_PARAM;
	item.iItem=index;

	ListView_GetItem(hwnd,&item);

	return item.lParam;
}

void ListView::Update(int i)
{ FUNC_ENTER("ListView::Update"); 
	ListView_Update(hwnd,i);
}

struct SortData
{
	ListView* plist;
	void*     data;
};

int CALLBACK ListView::Compare(LPARAM lParam1,LPARAM lParam2,LPARAM lParamSort)
{ FUNC_ENTER("ListView::Compare"); 
	SortData* sdata=(SortData*)lParamSort;
	ListView* pthis = sdata->plist;

	if (pthis->fpSort)
		return pthis->fpSort((DWORD)lParam1,(DWORD)lParam2,pthis,sdata->data);

	return 0;
}

void ListView::Sort(int(*fpCompare)(DWORD,DWORD,ListView* pData,void* pExtData),void* pSortData)
{ FUNC_ENTER("ListView::Sort"); 
	fpSort=fpCompare;
	SortData* data = new SortData;
	data->plist = this;
	data->data  = pSortData;
	ListView_SortItems(hwnd,Compare,(LPARAM)data);
	delete data;
}

void ListView::SelectWildcard(char* wildcard)
{ FUNC_ENTER("ListView::SelectWildcard"); 
	char name[256];
	int nCount = GetCount();

	if (wildcard[0] == '\0')
	{
		for(int i = 0; i < nCount; i++)
			UnSelect(i);
	}
	else
	{
		for(int i = 0; i < nCount; i++)
		{
			GetItem(i, name, 255);	

			if (MatchPattern(CStr(name), CStr(wildcard)))
			{
				Select(i);
				ScrollToItem(i);
			}
			else
				UnSelect(i);
		}
	}
}
