#include "FuncEnter.h"

/*
	InputDlg.cpp
	This is a standard dialog for getting a string of input
	aml - 1-30-03
*/

#include "InputDlg.h"
#include "resource.h"

InputDlg::InputDlg(HINSTANCE hInstance, HWND hwndParent, char* name, char* entry, char* title) :
	ModalDlgWindow(hInstance, MAKEINTRESOURCE(IDD_INPUTDLG), hwndParent)
{ FUNC_ENTER("InputDlg::InputDlg"); 
	strcpy(this->name, name);
	strcpy(this->entry, entry);
	strcpy(this->title, title);
}

InputDlg::~InputDlg()
{ FUNC_ENTER("InputDlg::~InputDlg"); 
	
}

BOOL InputDlg::DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{ FUNC_ENTER("InputDlg::DlgProc"); 
	switch(msg)
	{
	case WM_INITDIALOG:
		IEdit = GetICustEdit(GetDlgItem(hwnd, IDC_USEREDIT));

		SetDlgItemText(hwnd, IDC_INPUTNAME, name);
		IEdit->SetText(entry);
		SetWindowText(hwnd, title);		
		return TRUE;

	case WM_CLOSE:
		ReleaseICustEdit(IEdit);
		EndDialog(hwnd, 0);
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			{
				bCancelled = false;
				EndDialog(hwnd, 0);

				if (!IEdit)
				{
					input[0] = 0;
					return TRUE;
				}

				IEdit->GetText(input, 1023);
			}
			return TRUE;
		
		case IDCANCEL:
			{
				bCancelled = true;
				EndDialog(hwnd, 0);

				if (!IEdit)
				{
					input[0] = 0;
					return TRUE;
				}

				IEdit->GetText(input, 1023);
			}
			return TRUE;
		}
	}

	return FALSE;
}

CStr InputDlg::GetInput()
{ FUNC_ENTER("InputDlg::GetInput"); 
	return CStr(input);
}

void InputDlg::SetInput(char* text)
{ FUNC_ENTER("InputDlg::SetInput"); 
	IEdit->SetText(text);
}
