/*
	QueryBuilder.h
	The query builder generates a list of Find-A-Node queries from level property data
*/

#ifndef __QUERYBUILDER__
#define __QUERYBUILDER__

#include "../UI/MSWindow.h"
#include "max.h"
#include "../misc/llist.h"

class PropList;

class QueryBuilderDlg: public MSDlgWindow
{
	LinkList<CStr> propNames;					// List of property names

	Interface*   ip;							// The MAX Interface pointer
	PropList*    plist;							// The property list containing the query wildcards
	int          lastFocusIdx;					// The last index in the prop list that had focus

	void (*fpOkCB)(QueryBuilderDlg*,void*);		// Callback executed when the OK button is pressed
	void *pOkCBData;							// Callback retained data

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParawm,LPARAM lParam);

	void BuildAPList(INode* node=NULL);			// Construct list of all availabe properties
	void BuildSNList(INode* node=NULL);			// Construct list of all searchable nodes

	static void FocusCB(PropList* plist, int idx, void* pData);

	void SNEditUpdate();
	void APEditUpdate();

	bool IsMatch(CStr orig, CStr pattern);

public:
	QueryBuilderDlg(HINSTANCE hInstance,HWND hwndParent,Interface* ip);
	~QueryBuilderDlg();

	void RegOKCB(void(*Func)(QueryBuilderDlg*,void*),void* pData);

	void AddToPropList();
	void RemoveFromPropList();

	// Selection set commands
	void SNAll();
	void SNNone();
	void SNInvert();

	void APAll();
	void APNone();
	void APInvert();

	void Process();
	void ResetPropList();
	void Rescan();
	void NodeSelect();
};

#endif
