#include "FuncEnter.h"

/*
	PropTagParser.cpp
	This class includes functionality to parse extended
	property tags into property lists

	2-13-01
*/

#include "PropTagParser.h"
#include "ParseFuncs.h"
#include "../UI/MultiList.h"
#include "../UI/FlagSelect.h"
#include "../PropEdit/CmdTypes.h"
#include "../path.h"

PropTagParser::PropTagParser()
{ FUNC_ENTER("PropTagParser::PropTagParser"); 

}

PropTagParser::~PropTagParser()
{ FUNC_ENTER("PropTagParser::~PropTagParser"); 

}

void PropTagParser::BuildPropList(PropList* plist,LinkList<ConfigProp>* cprops)
{ FUNC_ENTER("PropTagParser::BuildPropList"); 
	Link<ConfigProp>* curNode=cprops->GetHead();
	int index;

	while(curNode)
	{
		CStr strDesc,strDefault;

		ParsePropTags(curNode->data.extdata,curNode->data.name,strDesc,strDefault);
		
		// Add the property name to the tooltip information (in case it gets truncated)
		strDesc=CStr("[")+curNode->data.name+CStr("]\n")+strDesc;

		// Check for extended DynUI commands
		if (!ParseExtendedTags(plist,curNode->data.extdata,"",curNode->data.name,strDesc,strDefault))
		{
			//int index;

			// No DynUI commands add as a standard edit box
			plist->AddEdit(curNode->data.name,strDesc);
			//index=plist->GetCurIndex();
			//plist->SetValue(index,curNode->data.value);

			ParseExtendedTagsReq(plist,curNode->data.extdata,"",curNode->data.name,strDesc,strDefault);
		}
		
		//plist->AddEdit(curNode->data.name,strDesc);

		index=plist->GetCurIndex();
		plist->SetValue(index,curNode->data.value);
		curNode=curNode->next;
	}
}

void PropTagParser::BuildConfigList(LinkList<ConfigProp>* cprops, PropList* plist)
{ FUNC_ENTER("PropTagParser::BuildConfigList"); 
	cprops->Clear();

	for(int curprop = 0; curprop < plist->NumProps(); curprop++)
	{
		ConfigProp cprop;
		cprop.name = plist->GetName(curprop);
		plist->GetValue(curprop, cprop.value);
		cprops->Add(&cprop);
	}
}

void PropTagParser::AssignPropValues(PropList* plist, LinkList<ConfigProp>* cprops)
{ FUNC_ENTER("PropTagParser::AssignPropValues"); 
	Link<ConfigProp>* link = cprops->GetHead();

	while(link)
	{
		plist->SetValue(link->data.name, link->data.value);
		link = link->next;
	}
}

bool PropTagParser::ParsePropTags(char* buf,CStr name,CStr& strDesc,CStr& strDefault)
{ FUNC_ENTER("PropTagParser::ParsePropTags"); 
	CStr strAutoDuck=BuildAutoDuckString(buf);
	int  len=strAutoDuck.Length();
	int  pos=0;
	bool bFound=false;

	while(pos<len)
	{
		CStr strTemp=GetRemainLinePartial(strAutoDuck,&pos);
		CStr strSrch;

		// Scan for each type
		strSrch=CStr("// @nextdesc | ")+name+CStr(" | ");

		if (Instr(strTemp,strSrch)!=-1)
		{
			bFound=true;
			strDesc=strTemp.Substr(strSrch.Length(),strTemp.Length());
		}

		strSrch=CStr("// @nextdef | ")+name+CStr(" | ");

		if (Instr(strTemp,strSrch)!=-1)
		{
			bFound=true;
			strDefault=strTemp.Substr(strSrch.Length(),strTemp.Length());
		}
	}

	return bFound;
}

bool PropTagParser::ParseExtendedTags(PropList* plist,
									  char*     loc,
									  CStr strType,CStr strName,
									  CStr strDesc,CStr strDefault)
{ FUNC_ENTER("PropTagParser::ParseExtendedTags"); 
	if (ParseExtendedTagsParm(plist,loc,strType,strName,strDesc,strDefault))
	{
		ParseExtendedTagsReq(plist,loc,strType,strName,strDesc,strDefault);
		ParseExtendedTagsCmd(plist,loc,strType,strName,strDesc,strDefault);
		return true;
	}

	return false;;
}

bool PropTagParser::ParseExtendedTagsCmd(PropList* plist,
										 char*     loc,
										 CStr strType,CStr strName,
										 CStr strDesc,CStr strDefault)
{ FUNC_ENTER("PropTagParser::ParseExtendedTagsCmd"); 
	char  token[1024];
	int   pos;

	CStr strSearchExt = CStr("@nextcmd | ")+strName;
	CStr strPropMode;
	CStr strParam;

	CStr strPath = CStr(getenv(APP_ENV)) + CStr(SCRIPT_PATH);
	
	// Parse nextreq flags
	strSearchExt = CStr("@nextcmd | ")+strName;

	// Check for extended parameter info
	while(loc=strstr(loc,strSearchExt))
	{
		loc+=strSearchExt.Length();
		pos=0;

		GetToken(loc,&pos,token);		// This is undefined
		GetToken(loc,&pos,token);		// This is the property mode
		StripToken(token);
		strPropMode=token;

		// Add the appropriate command based on the type of control
		if (strPropMode==CStr("omiton"))
		{
			GetToken(loc,&pos,token);
			StripToken(token);
			strParam = token;

			plist->AddCmd(strName, CMDTYPE_OMITON, 1, &strParam);
		}

		if (strPropMode==CStr("omitoff"))
		{
			GetToken(loc,&pos,token);
			StripToken(token);
			strParam = token;

			plist->AddCmd(strName, CMDTYPE_OMITOFF, 1, &strParam);
		}
	}

	return false;
}


bool PropTagParser::ParseExtendedTagsReq(PropList* plist,
										 char*     loc,
										 CStr strType,CStr strName,
										 CStr strDesc,CStr strDefault)
{ FUNC_ENTER("PropTagParser::ParseExtendedTagsReq"); 
	char  token[1024];
	int   pos;
	bool  bNewRule = false;

	CStr strSearchExt = CStr("@nextparm | ") + strName + CStr(" |");
	CStr strPropMode;
	CStr evalValue;
	CStr evalExpr;

	CStr strPath = CStr(getenv(APP_ENV)) + CStr(SCRIPT_PATH);
	
	// Parse nextreq flags
	strSearchExt = CStr("@nextreq | ") + strName + CStr(" |");
	//strSearchExt = CStr("@nextreq | ") + strName;

	// Check for extended parameter info
	while(loc=strstr(loc,strSearchExt))
	{
		loc+=(strSearchExt.Length()-1);
		pos=0;

		GetToken(loc,&pos,token);		// This is undefined
		GetToken(loc,&pos,token);		// This is the property mode
		StripToken(token);
		strPropMode=token;

		// Add the appropriate rule based on the type of control
		if (strPropMode == CStr("maxscript"))
		{
			GetToken(loc,&pos,token);
			StripToken(token);
			evalValue = token;

			plist->AddRule(strName, RULETYPE_MAXSCRIPT, evalValue, 0);
			bNewRule = true;
		}

		if (strPropMode == CStr("or_maxscript"))
		{
			GetToken(loc,&pos,token);
			StripToken(token);
			evalValue = token;

			plist->AddRule(strName, RULETYPE_OR_MAXSCRIPT, evalValue, 0);
			bNewRule = true;
		}

		if (strPropMode == CStr("prop"))
		{
			GetToken(loc,&pos,token);
			StripToken(token);
			evalValue = token;

			int nFields = CountCharEL(loc+pos,'|') + 1;

			CStr* evalExpr = new CStr[nFields];

			for(int fld = 0; fld < nFields; fld++)
			{
				GetToken(loc,&pos,token);
				StripToken(token);
				evalExpr[fld] = token;
			}

			plist->AddRule(strName, RULETYPE_PROP, evalValue, nFields, evalExpr);
			delete [] evalExpr;

			bNewRule = true;
		}

		if (strPropMode == CStr("or_prop"))
		{
			GetToken(loc,&pos,token);
			StripToken(token);
			evalValue = token;

			int nFields = CountCharEL(loc+pos,'|') + 1;

			CStr* evalExpr = new CStr[nFields];

			for(int fld = 0; fld < nFields; fld++)
			{
				GetToken(loc,&pos,token);
				StripToken(token);
				evalExpr[fld] = token;
			}

			plist->AddRule(strName, RULETYPE_OR_PROP, evalValue, nFields, evalExpr);
			delete [] evalExpr;

			bNewRule = true;
		}
	}

	return bNewRule;
}

bool PropTagParser::ParseExtendedTagsParm(PropList* plist,
								          char* loc,
		                                  CStr strType,CStr strName,
					                      CStr strDesc,CStr strDefault)
{ FUNC_ENTER("PropTagParser::ParseExtendedTagsParm"); 
	char  token[1024];
	int   pos;
	int   index;

	CStr strSearchExt=CStr("@nextparm | ")+strName;

	CStr strPropMode;

	CStr strPath = CStr(getenv(APP_ENV)) + CStr(SCRIPT_PATH);

	// Check for extended parameter info
	while(loc=strstr(loc,strSearchExt))
	{
		loc+=strSearchExt.Length();
		pos=0;

		GetToken(loc,&pos,token);		// This is undefined
		GetToken(loc,&pos,token);		// This is the property mode
		StripToken(token);
		strPropMode=token;

		// Add the appropriate interface based on the type of control
		if (strPropMode==CStr("edit"))
		{
			plist->AddEdit(strName,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);
			return true;
		}

		if (strPropMode==CStr("slider"))
		{
			int min,max;

			GetToken(loc,&pos,token);	// This is the min range
			StripToken(token);
			min=atoi(token);
			
			GetToken(loc,&pos,token);	// This is the max range
			StripToken(token);
			max=atoi(token);

			plist->AddSlider(strName,min,max,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);
			return true;
		}

		if (strPropMode==CStr("slidernum"))
		{
			float min,max;

			GetToken(loc,&pos,token);	// This is the min range
			StripToken(token);
			min=atof(token);
			
			GetToken(loc,&pos,token);	// This is the max range
			StripToken(token);
			max=atof(token);
			
			plist->AddSliderNum(strName,min,max,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);
			return true;
		}

		////////
		if (strPropMode==CStr("static"))
		{
			plist->AddStatic(strName,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);
			return true;
		}

		if (strPropMode==CStr("spinedit"))
		{
			float min,max,incr;

			GetToken(loc,&pos,token);	// This is the min range
			StripToken(token);
			min=atof(token);
			
			GetToken(loc,&pos,token);	// This is the max range
			StripToken(token);
			max=atof(token);

			GetToken(loc,&pos,token);	// This is the increment value
			StripToken(token);
			incr=atof(token);

			plist->AddSpinEdit(strName,min,max,incr,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);
			return true;
		}

		if (strPropMode==CStr("colorpopup"))
		{
			int minColors, maxColors;

			GetToken(loc,&pos,token);	// This is min
			StripToken(token);
			minColors=atoi(token);

			GetToken(loc,&pos,token);	// This is max
			StripToken(token);
			maxColors=atoi(token);

			plist->AddColorPopup(strName,minColors,maxColors,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);
			return true;
		}
		///////////////////////

		if (strPropMode==CStr("list"))
		{
			ListData* ldata=plist->AddList(strName,strDesc);
			//index=plist->GetCurIndex();
			//plist->SetValue(index,strDefault);

			for(;;)
			{
				// extract list
				if (GetToken(loc,&pos,token))
				{
					StripToken(token);

					// Support reading flags from an external file
					if (strcmp(token,"file")==0)
					{
						char filename[256];
						GetToken(loc,&pos,filename);
						StripToken(filename);

						FILE* fp = fopen(strPath + filename,"r");
						
						char buf[256];
						while(!feof(fp))
						{
							fgets(buf,255,fp);
							StripToken(buf);
							
							if (strlen(buf)>0)
								ldata->list.Add(&CStr(buf));
						}

						fclose(fp);
						continue;
					}

					if (strcmp(token,"done")==0)
						return true;

					ldata->list.Add(&CStr(token));
				}
				else
					break;		// Break if there was no done to prevent infinite loop (syntax error)
			}

			return true;
		}

		if (strPropMode==CStr("extlist"))
		{
			ListData* ldata=plist->AddExtList(strName,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);

			for(;;)
			{
				// extract list
				if (GetToken(loc,&pos,token))
				{
					StripToken(token);

					// Support reading flags from an external file
					if (strcmp(token,"file")==0)
					{
						char filename[256];
						GetToken(loc,&pos,filename);
						StripToken(filename);

						FILE* fp = fopen(strPath + filename,"r");
						
						char buf[256];
						while(!feof(fp))
						{
							fgets(buf,255,fp);
							StripToken(buf);
							
							if (strlen(buf)>0)
								ldata->list.Add(&CStr(buf));
						}

						fclose(fp);
						continue;
					}

					if (strcmp(token,"done")==0)
						return true;

					ldata->list.Add(&CStr(token));
				}
				else
					break;		// Break if there was no done to prevent infinite loop (syntax error)
			}

			return true;
		}

		//////////// C

		if (strPropMode==CStr("file"))
		{
			int  filterpos=0;
			int  toklen;

			FileData* fdata=plist->AddFile(strName,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);

			// Set the initial path
			GetToken(loc,&pos,token);
			StripToken(token);
			fdata->path = token;

			// Set the relative path
			GetToken(loc,&pos,token);
			StripToken(token);
			fdata->relPath = token;

			for(;;)
			{
				// extract list
				if (GetToken(loc,&pos,token))
				{
					StripToken(token);

					if (strcmp(token,"done")==0)
						break;

					toklen=strlen(token);
					for(int i=0;i<toklen && filterpos<512;i++)
						fdata->Fltr[filterpos++]=token[i];

					fdata->Fltr[filterpos++]='\0';
				}
				else
					break;		// Break if there was no done to prevent infinite loop (syntax error)
			}

			fdata->Fltr[filterpos]='\0';
			return true;
		}

		if (strPropMode==CStr("color"))
		{
			plist->AddColor(strName,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);
			return true;
		}

		///

		if (strPropMode==CStr("check"))
		{
			plist->AddCheck(strName,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);
			return true;
		}

		if (strPropMode==CStr("material"))
		{
			plist->AddMtl(strName,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);
		}

		if (strPropMode==CStr("script"))
		{
			plist->AddScript(strName,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);
			return true;
		}

		if (strPropMode==CStr("node"))
		{
			plist->AddNode(strName,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);
			return true;
		}

		/////// C

		if (strPropMode==CStr("multi"))
		{
			MultiList* ml = plist->AddMulti(strName,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);

			for(;;)
			{
				// extract list
				if (GetToken(loc,&pos,token))
				{
					StripToken(token);

					// Support reading flags from an external file
					if (strcmp(token,"file")==0)
					{
						char filename[256];
						GetToken(loc,&pos,filename);
						StripToken(filename);

						FILE* fp = fopen(strPath + filename,"r");
						
						char buf[256];
						while(!feof(fp))
						{
							fgets(buf,255,fp);
							StripToken(buf);
							
							if (strlen(buf)>0)
								ml->AddItem(buf);
						}

						fclose(fp);
						continue;
					}

					if (strcmp(token,"done")==0)
						return true;

					ml->AddItem(token);
				}
				else
					break;		// Break if there was no done to prevent infinite loop (syntax error)
			}

			return true;
		}

		if (strPropMode==CStr("flags"))
		{
			FlagSelect* fs = plist->AddFlags(strName,strDesc);
			index=plist->GetCurIndex();
			plist->SetValue(index,strDefault);

			for(;;)
			{
				// extract list
				if (GetToken(loc,&pos,token))
				{
					StripToken(token);

					// Support reading flags from an external file
					if (strcmp(token,"file")==0)
					{
						char filename[256];
						GetToken(loc,&pos,filename);
						StripToken(filename);

						FILE* fp = fopen(strPath + filename,"r");
						
						char buf[256];
						while(!feof(fp))
						{
							fgets(buf,255,fp);
							StripToken(buf);
							
							if (strlen(buf)>0)
								fs->AddItem(buf);
						}

						fclose(fp);
						continue;
					}

					if (strcmp(token,"done")==0)
						return true;

					fs->AddItem(token);
				}
				else
					break;		// Break if there was no done to prevent infinite loop (syntax error)
			}
		}
	}

	return false;
}

bool PropTagParser::ParseScriptTags(PropList* plist,CStr Filename,CStr Keyword)
{ FUNC_ENTER("PropTagParser::ParseScriptTags"); 
	char funcDesc[1024]="";	// Buffer to store the description of the function
	//char ErrorMsg[256];	// Error buffer
	char lineBuf[512];		// line buffer
	char token[1024];
	int  pos=0;
	int  filepos;
	int  index;

	CStr strLine;

	CStr strAutoDuck;
	CStr strParamType;
	CStr strParamName;
	CStr strParamDesc;
	CStr strParamDefault;

	CStr strPropMode;

	FILE* fp=fopen(Filename,"r");

	Keyword.toLower();
	CStr strSearch1=CStr("// @script ");
	CStr strSearch2=CStr("| ")+Keyword+CStr(" |");

	if (!fp)
	{
		//sprintf(ErrorMsg,"Failed to open script file: %s",(char*)Filename);
		//MessageBox(hwnd,ErrorMsg,"PropEdit",MB_OK|MB_ICONSTOP);
		return false;
	}

	filepos=0;

	while(fgets(lineBuf,512,fp))
	{
		strLine=lineBuf;
		strLine.toLower();

		if (IsInstr(strLine,strSearch1) &&
			IsInstr(strLine,strSearch2) )
		{
			strAutoDuck=BuildAutoDuckString(fp,filepos);
			char* str=strAutoDuck;
			char* loc;

			// Find all unnamed parameters
			loc=str;
			while(loc=strstr(loc,"@uparm "))
			{
				loc+=6;
				pos=0;
				GetToken(loc,&pos,token);	// This is the param example
				StripToken(token);
				strParamDefault=token;

				GetToken(loc,&pos,token);	// This is the param description
				StripToken(token);
				strParamDesc=token;

				if (!ParseExtendedTags(plist,
					                   loc,
					                   strParamType,strParamName,
									   strParamDesc,strParamDefault))
				{
					plist->AddEdit("",strParamDesc);
					index=plist->GetCurIndex();
					plist->SetValue(index,strParamDefault);

					ParseExtendedTagsReq(plist,loc,strParamType,strParamName,strParamDesc,strParamDefault);
				}
			}

			// Find all unnamed optional parameters
			loc=str;
			while(loc=strstr(loc,"@uparmopt "))
			{
				loc+=9;
				pos=0;
				GetToken(loc,&pos,token);	// This is the param example
				StripToken(token);
				strParamDefault=token;

				GetToken(loc,&pos,token);	// This is the param description
				StripToken(token);
				strParamDesc=token;

				if (!ParseExtendedTags(plist,
					                   loc,
					                   strParamType,strParamName,
									   strParamDesc,strParamDefault))
				{
					plist->AddEdit("",strParamDesc);
					index=plist->GetCurIndex();
					plist->SetValue(index,strParamDefault);

					ParseExtendedTagsReq(plist,loc,strParamType,strParamName,strParamDesc,strParamDefault);
				}
			}

			// Find all required parameters
			loc=str;
			while(loc=strstr(loc,"@parm "))
			{
				loc+=5;
				pos=0;

				GetToken(loc,&pos,token);	// This is the param type
				StripToken(token);
				strParamType=token;

				GetToken(loc,&pos,token);	// This is the param name
				StripToken(token);
				strParamName=token;

				GetToken(loc,&pos,token);	// This is the param description
				StripToken(token);
				strParamDesc=token;

				if (!ParseExtendedTags(plist,
					                   loc,
					                   strParamType,strParamName,
									   strParamDesc,strParamDefault))
				{
					// We can add some more appropriate UIs based on the type field
					strParamType.toLower();

					if (strParamType==CStr("int"))
						plist->AddSliderNum(strParamName,-99999,99999,strParamDesc);
					else
					if (strParamType==CStr("float"))
						plist->AddSpinEdit(strParamName,-99999.0f,99999.0f,0.01f,strParamDesc);
					else
						plist->AddEdit(strParamName,strParamDesc);

					index=plist->GetCurIndex();
					plist->SetValue(index,strParamDefault);

					ParseExtendedTagsReq(plist,loc,strParamType,strParamName,strParamDesc,strParamDefault);
				}
			}

			// Find all optional parameters
			loc=str;
			while(loc=strstr(loc,"@parmopt "))
			{
				loc+=8;
				pos=0;
				GetToken(loc,&pos,token);	// This is the param type
				StripToken(token);
				strParamType=token;

				GetToken(loc,&pos,token);	// This is the param name
				StripToken(token);
				strParamName=token;

				GetToken(loc,&pos,token);	// This is the param default
				StripToken(token);
				strParamDefault=token;

				GetToken(loc,&pos,token);	// This is the param description
				StripToken(token);
				strParamDesc=token;

				if (!ParseExtendedTags(plist,
					                   loc,
					                   strParamType,strParamName,
									   strParamDesc,strParamDefault))
				{
					if (strParamType==CStr("int"))
						plist->AddSliderNum(strParamName,-99999,99999,strParamDesc);
					else
					if (strParamType==CStr("float"))
						plist->AddSpinEdit(strParamName,-99999.0f,99999.0f,0.01f,strParamDesc);
					else
						plist->AddEdit(strParamName,strParamDesc);

					index=plist->GetCurIndex();
					plist->SetValue(index,strParamDefault);

					ParseExtendedTagsReq(plist,loc,strParamType,strParamName,strParamDesc,strParamDefault);
				}
			}

			// Find all flags
			loc=str;
			while(loc=strstr(loc,"@flag "))
			{
				loc+=5;
				pos=0;
				GetToken(loc,&pos,token);	// This is the param name
				StripToken(token);
				strParamName=token;

				GetToken(loc,&pos,token);	// This is the param description
				StripToken(token);
				strParamDesc=token;

				if (!ParseExtendedTags(plist,
					                   loc,
					                   strParamType,strParamName,
									   strParamDesc,strParamDefault))
				{
					plist->AddCheck(strParamName,strParamDesc);
					
					ParseExtendedTagsReq(plist,loc,strParamType,strParamName,strParamDesc,strParamDefault);
				}
			}

		}

		filepos=ftell(fp);
	}

	fclose(fp);

	//sprintf(ErrorMsg,"Failed to locate AutoDuck Script definition\nFilename: %s\nSearch: %s",(char*)Filename,(char*)strSearch);
	//MessageBox(hwnd,ErrorMsg,"PropEdit",MB_OK|MB_ICONSTOP);
	return false;
}
