/*
	FindInFiles.h
	Find in Files
*/

#ifndef __FINDINFILES__
#define __FINDINFILES__

#include "../UI/MSWindow.h"

class PropEditor;
class RichText;

class FindInFilesDlg: public MSDlgWindow
{
	HINSTANCE hInstance;		// Application hInstance

	PropEditor* pPropEdit;
	RichText*   pRichText;

	bool bUserWarned;			// Set if user warned about updating of script window
	bool bAbort;				// Cancel was pressed

	char prefix[256];
	char dir[256];

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void GetSearchDir();
	void Find();
	void Find(char* sdir,char* prefix,char* search);
	void ListSel();

	int  CountFiles(char* sdir,char* prefix);
	bool MatchContent(FILE* fp,char* wildcard,char* buf,int* line);

public:
	FindInFilesDlg(HINSTANCE hInstance,HWND hwndParent,PropEditor* pPropEdit,RichText* pRichText);
	~FindInFilesDlg();
};

#endif
