#ifndef __NEXTPARTICLE_H__
#define __NEXTPARTICLE_H__

#define PARTICLE_BOX_CLASS_ID Class_ID(0x7d144f2b, 0x76027598)
#define PARTICLEMASTER_CLASS_ID Class_ID(0x65b636f9, 0x4dfd61f2)
#define SLAVE_CONTROL_CLASS_ID Class_ID(0x9a05605, 0x2cca3ccd)

#define IPOS_CONTROL_CLASS_ID	Class_ID(0x5f4925ca, 0x5aea6b10)
#define IPOINT3_CONTROL_CLASS_ID	Class_ID(0x1775171e, 0x7246385b)
#define ICOLOR_CONTROL_CLASS_ID		Class_ID(0x54a32bcb, 0x445c3380)

#define vLOCAL_EULER_CONTROL_CLASS_ID Class_ID(0x4ba0774b, 0x4d242139)

#define PARTICLE_MASTER		1
#define MID_BOX_REF			2
#define END_BOX_REF			3

enum
{
	PM_REF_PB,
	PM_REF_MID_CTRL,
	PM_REF_END_CTRL,
	PM_REF_MID_ROT_CTRL,
	PM_REF_END_ROT_CTRL,
	vNUM_PM_REFS,
};

enum
{
	vLIFETIME,
	vMID_TIME_PCT,
	vACCELERATION_X,
	vVEL_X,
	vACCELERATION_Y,
	vVEL_Y,
	vACCELERATION_Z,
	vVEL_Z,	
	vUSE_MIDPOINT,
	vNUM_PROPERTIES
};

#define	BOX_MOVED	TARGETMSG_USER

class IParticleMaster
{
public:

 	virtual void SetLifetime(TimeValue t, float r, bool update_props, bool update_controls=true ) = 0;
	virtual void SetMidtimePCT(TimeValue t, float r, bool update_props, bool update_controls=true ) = 0;
	virtual void SetAccelerationX(TimeValue t, float r, bool update_props, bool update_controls=true ) = 0;
	virtual void SetAccelerationY(TimeValue t, float r, bool update_props, bool update_controls=true ) = 0;
	virtual void SetAccelerationZ(TimeValue t, float r, bool update_props, bool update_controls=true ) = 0;
	virtual void SetVelocityX(TimeValue t, float r, bool update_props, bool update_controls=true ) = 0;
	virtual void SetVelocityY(TimeValue t, float r, bool update_props, bool update_controls=true ) = 0;
	virtual void SetVelocityZ(TimeValue t, float r, bool update_props, bool update_controls=true ) = 0;		

	virtual void UpdateRefs() = 0;
	virtual void SetMasterNode( INode* master ) = 0;
};

class IParticleBox
{
public:
	virtual	IParticleMaster*	GetParticleMaster( void ) = 0;
	virtual	float			GetWidth( void ) = 0;
	virtual	float			GetHeight( void ) = 0;
	virtual	float			GetLength( void ) = 0;

	virtual void            SetWidth(float w) = 0;
	virtual void            SetHeight(float h) = 0;
	virtual void            SetLength(float l) = 0;

	virtual	IParticleBox*	GetMidBox( void ) = 0;
	virtual IParticleBox*	GetEndBox( void ) = 0;

	virtual INode*			GetObjectNode( void ) = 0;	
	virtual bool            IsValid( void ) = 0;
	virtual void            SetValid( bool bValid ) = 0;

	virtual void            DetachAssociations( void ) = 0;
	virtual bool			IsDetached( void ) = 0;
};


int		GetParticlePropertyIndex( CStr property );
void	HandleParticlePropertyChange( IParticleBox* box, int prop_index, CStr prop_val );

void	RegisterParticleNotifications( void );
void	UnregisterParticleNotifications( void );

enum
{
	IPOS_X_REF,
	IPOS_Y_REF,
	IPOS_Z_REF,
	vNUM_POS_CONTROLLER_REFS
};

class IPosDlg;
class IndePosition : public Control 
{
	public:
		int node_index;
		IParticleMaster* theMaster;
		Control *posX;
		Control *posY;
		Control *posZ;
		Point3 curval;
		Matrix3 parent_xform;
		Interval ivalid;
		BOOL blockUpdate;
		BOOL blockMove;
		// To support trajectory path.
		int xkSkip;
		int ykSkip;
		int zkSkip;
		BitArray xKeys;
		BitArray yKeys;
		BitArray zKeys;
		Tab<TimeValue> keyTimes;

		static IPosDlg *dlg;
		static IObjParam *ip;
		static ULONG beginFlags;
		static IndePosition *editControl; // The one being edited.
		
		IndePosition(BOOL loading=FALSE, RefTargetHandle master=NULL, int index=0 );
		IndePosition(const IndePosition &ctrl, RefTargetHandle master=NULL, int index=0 );
		~IndePosition();
		void Update(TimeValue t);

		// Animatable methods
		Class_ID ClassID() { return IPOS_CONTROL_CLASS_ID;} 
		SClass_ID SuperClassID() {return CTRL_POSITION_CLASS_ID;} 
		
		void GetClassName(TSTR& s);
		void DeleteThis() {delete this;}		
		int IsKeyable() {return 1;}		

		int NumSubs()  {return 3;}
		Animatable* SubAnim(int i);
		TSTR SubAnimName(int i);
		int SubNumToRefNum(int subNum) {return subNum;}

		DWORD GetSubAnimCurveColor(int subNum);

		ParamDimension* GetParamDimension(int i) {return stdWorldDim;}
		BOOL AssignController(Animatable *control,int subAnim);
		void AddNewKey(TimeValue t,DWORD flags);
		int NumKeys();
		TimeValue GetKeyTime(int index);
		int GetKeyTimes(Tab<TimeValue>&, Interval, DWORD flags);
		int GetKeySelState(BitArray&, Interval, DWORD flags);
		void SelectKeys(TrackHitTab& sel, DWORD flags);
		void SelectKeyByIndex(int i,BOOL sel);
		BOOL IsKeySelected(int i);
		void CopyKeysFromTime(TimeValue src,TimeValue dst,DWORD flags);
		BOOL IsKeyAtTime(TimeValue t,DWORD flags);
		BOOL GetNextKeyTime(TimeValue t,DWORD flags,TimeValue &nt);
		void DeleteKeyAtTime(TimeValue t);
		void DeleteKeys(DWORD flags);
		void DeleteKeyByIndex(int index);

		void BeginEditParams( IObjParam *ip, ULONG flags,Animatable *prev );
		void EndEditParams( IObjParam *ip, ULONG flags,Animatable *next );
		
		// Reference methods
		int NumRefs() { return vNUM_POS_CONTROLLER_REFS; };	
		RefTargetHandle GetReference(int i);
		void SetReference(int i, RefTargetHandle rtarg);
		RefResult NotifyRefChanged(Interval, RefTargetHandle, PartID&, RefMessage);
		
		// Control methods
		Control *GetXController() {return posX;}
		Control *GetYController() {return posY;}
		Control *GetZController() {return posZ;}
		void Copy(Control *from);
		RefTargetHandle Clone(RemapDir& remap);
		BOOL IsLeaf() {return FALSE;}
		void GetValue(TimeValue t, void *val, Interval &valid, GetSetMethod method);	
		void SetValue(TimeValue t, void *val, int commit, GetSetMethod method);
		void SetValueFromMaster(TimeValue t, void *val, int commit, GetSetMethod method);
		void CommitValue(TimeValue t);
		void RestoreValue(TimeValue t);	

		// AF (09/20/02) Pass these methods onto the subAnims
		int GetORT(int type);
		void SetORT(int ort, int type);
		void EnableORTs(BOOL enable);
		
		BOOL CreateLockKey(TimeValue t, int which);

};

#define HYBRID_LINEAR   1

class LocalEulerDlg;
class LocalEulerRotation : public Control {
    public:
        Control *rotX;
        Control *rotY;
        Control *rotZ;
        int order;
        Quat curval;
        Interval ivalid;
		Tab<TimeValue> keyTimes;

        static LocalEulerDlg *dlg;
        static IObjParam *ip;
        static ULONG beginFlags;
        static LocalEulerRotation *editControl; // The one being edited.

        LocalEulerRotation(const LocalEulerRotation &ctrl);
        LocalEulerRotation(BOOL loading=FALSE);
        ~LocalEulerRotation();
        void Update(TimeValue t);
        DWORD GetDefaultInTan() {return HYBRID_LINEAR;}
        DWORD GetDefaultOutTan() {return HYBRID_LINEAR;}

		// Animatable methods
        Class_ID ClassID() { return Class_ID(LOCAL_EULER_CONTROL_CLASS_ID,0); }  
        SClass_ID SuperClassID() { return CTRL_ROTATION_CLASS_ID; }         
        
        void GetClassName(TSTR& s);
        void DeleteThis() { delete this; }        
        int IsKeyable() { return 1; }     

        int NumSubs()  { return 3; }
        Animatable* SubAnim(int i);
        TSTR SubAnimName(int i);
        int SubNumToRefNum(int subNum) { return subNum; }

        DWORD GetSubAnimCurveColor(int subNum);

        ParamDimension* GetParamDimension(int i) { return stdAngleDim; }
        BOOL AssignController(Animatable *control,int subAnim);
        void AddNewKey(TimeValue t,DWORD flags);
        int NumKeys();
        TimeValue GetKeyTime(int index);
		void SelectKeyByIndex(int i,BOOL sel);
		BOOL IsKeySelected(int i);
        void CopyKeysFromTime(TimeValue src, TimeValue dst, DWORD flags);
        BOOL IsKeyAtTime(TimeValue t, DWORD flags);
        BOOL GetNextKeyTime(TimeValue t, DWORD flags, TimeValue &nt);
        void DeleteKeyAtTime(TimeValue t);
		void DeleteKeys(DWORD flags);
		void DeleteKeyByIndex(int index);

        void BeginEditParams(IObjParam *ip, ULONG flags,Animatable *prev);
        void EndEditParams(IObjParam *ip, ULONG flags,Animatable *next);

        int SetProperty(ULONG id, void *data);
        void *GetProperty(ULONG id);

        // Reference methods
        int NumRefs() { return 3; };    
        RefTargetHandle GetReference(int i);
        void SetReference(int i, RefTargetHandle rtarg);
        RefResult NotifyRefChanged(Interval, RefTargetHandle, PartID&, RefMessage);
        void RescaleWorldUnits(float f) {}

        IOResult Save(ISave *isave);
        IOResult Load(ILoad *iload);

        // Control methods
        Control *GetXController() { return rotX; }
        Control *GetYController() { return rotY; }
        Control *GetZController() { return rotZ; }
        void Copy(Control *from);
        RefTargetHandle Clone(RemapDir& remap);
        BOOL IsLeaf() { return FALSE; }
        void GetValue(TimeValue t, void *val, Interval &valid, GetSetMethod method);    
        void SetValue(TimeValue t, void *val, int commit, GetSetMethod method);
        bool GetLocalTMComponents(TimeValue, TMComponentsArg&, Matrix3Indirect& parentTM);
        void CommitValue(TimeValue t);
        void RestoreValue(TimeValue t);
        void EnumIKParams(IKEnumCallback &callback);
        BOOL CompDeriv(TimeValue t, Matrix3& ptm, IKDeriv& derivs, DWORD flags);
        float IncIKParam(TimeValue t, int index, float delta);
        void ClearIKParam(Interval iv, int index);
        void EnableORTs(BOOL enable);
        void MirrorIKConstraints(int axis, int which);       
        BOOL CanCopyIKParams(int which);
        IKClipObject *CopyIKParams(int which);
        BOOL CanPasteIKParams(IKClipObject *co, int which);
        void PasteIKParams(IKClipObject *co, int which);		
        void ChangeOrdering(int newOrder);

		// RB 10/27/2000: Implemented to support HI IK
		void InitIKJoints2(InitJointData2 *posData,InitJointData2 *rotData);
		BOOL GetIKJoints2(InitJointData2 *posData,InitJointData2 *rotData);
    };

#endif // __NEXTPARTICLE_H__
