/*
	Saveable.h
	Class to provide helper functions for saving variable-sized
	data to fixed sections of memory
	aml - 10-10-02
*/

#ifndef __SAVEABLE__
#define __SAVEABLE__

#include "llist.h"
#include "max.h"

class Saveable
{
public:
	virtual int  GetSize()=0;
	virtual void Store(void* data)=0;
	virtual void Retrieve(void* data)=0;
};

template<class T>
int ListSize(LinkList<T>* list)
{
	Link<T>* link = list->GetHead();

	int total = 0;

	while(link)
	{
		total += link->data.GetSize();
		link = link->next;
	}

	return total + sizeof(int);
}

// Doesn't work due to bug in VC6 manually expanding template function to compensate
//   Expanded in ConfigData.h
/*
template<class T>
int ListSize(unsigned char** data)
{
	unsigned char* pos = *data;
	int size;

	memcpy(&size, pos, sizeof(int));
	pos += sizeof(int);

	int subsize = 0;

	for(int i = 0; i < size; i++)
	{
		T data;
		data.Retrieve(pos);
		subsize += data.GetSize();
	}

	return subsize + sizeof(int);
}
*/

int ListSizeConfigProp(unsigned char** data);
int ListSizeConfigScript(unsigned char** data);
int ListSizeConfigProgram(unsigned char** data);
int ListSizeCutsceneObj(unsigned char** data);

template<class T>
void WriteList(unsigned char** data, LinkList<T>* list)
{
	unsigned char* pos = *data;
	int size = list->GetSize();

	memcpy(pos, &size, sizeof(int));
	pos += sizeof(int);
	
	Link<T>* link = list->GetHead();

	while(link)
	{
		link->data.Store(pos);
		pos += link->data.GetSize();

		link = link->next;
	}

	*data = pos;
}

template<class T>
void GetList(unsigned char** data, LinkList<T>* list)
{
	unsigned char* pos = *data;
	int size;

	list->Clear();

	memcpy(&size, pos, sizeof(int));
	pos += sizeof(int);

	for(int i = 0; i < size; i++)
	{
		T data;
		data.Retrieve(pos);
		pos += data.GetSize();

		list->AddToTail(&data);
	}

	*data = pos;
}

int Write(unsigned char** data, unsigned int size, void* pSrcData);
void Read(unsigned char** data, unsigned int size, void* pDestData);
int WriteString(unsigned char** data, CStr& str);
void GetString(unsigned char** data, CStr& str);
int GetStringSize(CStr& str);
int GetStringSize(unsigned char** data);

class SaveableStr: public Saveable, 
                   public CStr
{
public:
	SaveableStr() {}
	//SaveableStr(const char *cs) { CStr::CStr(cs); }
	SaveableStr(CStr str) { CStr::operator=(str); }

	int  GetSize() { return GetStringSize(*this); }
	
	void Store(void* data)
	{
		unsigned char* pos = (unsigned char*)data;
		WriteString(&pos, *this);
	}

	void Retrieve(void* data)
	{
		unsigned char* pos = (unsigned char*)data;
		GetString(&pos, *this);
	}
};

void WriteNodeList(unsigned char** data, LinkList<INode*>* list);
void GetNodeList(unsigned char** data, LinkList<INode*>* list);
int  GetNodeListSize(LinkList<INode*>* list);

#endif
