/*
	ConflictDlg.h
	Dialog to allow user to select how a merge conflict will be resolved
	4-2-01
*/

#ifndef __CONFLICTDLG_H__
#define __CONFLICTDLG_H__

#include "../UI/ModalDlg.h"

enum ResolveMode
{
	RESOLVE_UNDEFINED,	// Nothing entered yet
	RESOLVE_DELSRC,		// Delete source copy
	RESOLVE_DELMERGE,	// Delete merge copy
	RESOLVE_MERGE,		// Merge merge copy into source copy (rename, prompt)
	RESOLVE_AUTORENAME,	// Automatically rename
};

enum DisplayMode
{
	DISPMODE_GEOM,
	DISPMODE_MTL,
};

class ConflictDlg: public ModalDlgWindow
{
	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	char itemName[1024];
	char renameName[1024];
	ResolveMode rmode;
	bool bDisableMerge;
	bool bApplyAll;
	bool bAutoRename;

	DisplayMode dmode;

public:
	ConflictDlg(HINSTANCE hInstance,HWND hwndParent);
	~ConflictDlg();

	void SetItemName(char* name);
	ResolveMode GetResolveMode();

	void Show();

	inline bool ApplyAll() { return bApplyAll; }

	inline void SetGeomMode() { dmode = DISPMODE_GEOM; }
	inline void SetMtlMode()  { dmode = DISPMODE_MTL;  }

	inline void EnableMerge()  { bDisableMerge = false; }
	inline void DisableMerge() { bDisableMerge = true; }

	void  SetRenameName(char* name);

	inline char* GetRenameName() 
	{ 
		if (renameName[0]) 
			return renameName; 

		return NULL;
	}

	inline bool GetAutoRename()
	{
		return bAutoRename; 
	}
};

#endif
