/*
	MemDebug.cpp
	Functions for debugging memory problems
	
	IMPORTANT!  MemDebug.h should always be included last
	aml
*/

//#define ENABLE_MEMLEAK_CHECKS

#ifndef __MEMDEBUG__
#define __MEMDEBUG__

// Performs checks on the state of the heap
#ifdef DISABLE_VERIFYMEMORY
#define VerifyMemory()
#else
#define VerifyMemory() _VerifyMemory(__FILE__,__LINE__)
#endif

bool _VerifyMemory(char* file, const int line);

bool GetMemBlockInfo(void* pMem, char* file, int* line, int* size);
void DumpMemBlockInfo(void* pMem);

////////////////// Memory Leak detection
// This turns on the C runtime memory leak detection
#ifdef ENABLE_MEMLEAK_CHECKS
	#include <crtdbg.h>			// For memory leak detection

	#ifndef _CRTDBG_MAP_ALLOC
	#define _CRTDBG_MAP_ALLOC
	#endif

	#ifdef _DEBUG
	#define DumpAllocSource(p) _DumpAllocSource(p)
	#else
	#define DumpAllocSource(p)
	#endif

	void _DumpAllocSource(void* pMem);

	#ifdef _DEBUG
	#define MemLogStart() _MemLogStart(__FILE__, __LINE__)
	#define MemLogEnd() _MemLogEnd(__FILE__, __LINE__)
	#else
	#define MemLogStart()
	#define MemLogEnd()
	#endif

	void _MemLogStart(char* file, int line);
	void _MemLogEnd(char* file, int line);

	// In crtdbg.h the file and line are passed on to the actual new allocator by expanding
	// it as an inline function however despite enabling inline expansions (which also breaks Edit and Continue)
	// the preprocessor still grabs file and line from crtdbg.h  The below forces new to include the proper
	// file/line is included by defining it as a macro   aml
	//
	// NOTE: This needs temporarily disabled if you're defining a new overload
	#ifndef _NEWEXPANDCRTDBG
	#define new new(_NORMAL_BLOCK, __FILE__, __LINE__)
	//#define new new( __FILE__, __LINE__)
	#define _NEWEXPANDCRTDBG
	#endif

#else
#define DumpAllocSource(p)
#define MemLogStart()
#define MemLogEnd()

#endif // ENABLE_MEMLEAK_CHECKS

#ifdef ENABLE_INTERNAL_MEMLEAK_CHECKS

	//void* operator new(unsigned int size);
	void* operator new(unsigned int size, char* file, int line);
	void* mymalloc(unsigned int size, char* file, int line);

	#ifndef _NEWEXPANDCRTDBG
	#define new new( __FILE__, __LINE__)
	#define malloc(x) mymalloc(x, __FILE__, __LINE__)
	//#define new new(_NORMAL_BLOCK, __FILE__, __LINE__)
	#define _NEWEXPANDCRTDBG
	#endif

#endif
	
//////////////////// End Memory Leak Detection

#endif
