//#include "FuncEnter.h"
#include "../../DebugLink/DebugLink.h"

#define ENABLE_INTERNAL_MEMLEAK_CHECKS

/*
	MemDebug.cpp
	Functions for debugging memory problems
	aml
*/

#include <windows.h>
#include <malloc.h>
#include <stdio.h>
//#include "MemDebug.h"

//#define DUMP_CHK_LINES

unsigned int gMemUsage = 0;			// Amount of total memory allocations in plugin thus far

bool _VerifyMemory(char* file, const int line)
{ //FUNC_ENTER("_VerifyMemory"); 
#ifdef DUMP_CHK_LINES
	char buf[1024];
	sprintf(buf, "%s(%i): VerifyMemory: HEAP CORRUPTION prior to point\n", file, line);
	OutputDebugString(buf);
#endif

	int memStatus = _heapchk();

	if (memStatus == _HEAPOK)
		return true;
	
	char strErrBuf[1024];
	char error[256];

	switch(memStatus)
	{
	case _HEAPBADBEGIN:
		strcpy(error, "_HEAPBADBEGIN");
		break;

	case _HEAPBADNODE:
		strcpy(error, "_HEAPBADNODE");
		break;

	case _HEAPBADPTR:
		strcpy(error, "_HEAPBADPTR");
		break;

	case _HEAPEMPTY:
		strcpy(error, "_HEAPBADBEGIN");
		break;
	}

	DumpLog("c:\\next.log");
	sprintf(strErrBuf, "%s(%i): VerifyMemory: HEAP CORRUPTION prior to point (%s)\n", file, line, error);
	OutputDebugString(strErrBuf);
	MessageBox(NULL, strErrBuf, "VerifyMemory", MB_ICONSTOP|MB_OK);
	return false;
}

// MAX seems to screw us out of using the internal C runtime memory checking routines
// In order to use c runtime memory checking we have to build with the Debug runtime DLL
// but, if we do, memory allocated in the plugin is incompatible with MAX using the normal runtime
// library.  And we'll get heap check exceptions until we eventually crash.  If we use the MAX debug
// build, some inconsistency prevents the plugin from initializing unless its built with the standard runtime???

// To counter define ENABLE_INTERNAL_MEMLEAK_CHECKS and we'll add our own debug information to every memory
// allocation we make (or at least the majority of them)
#ifdef ENABLE_INTERNAL_MEMLEAK_CHECKS

#define MEMBLOCK_ALLOC_MAGICNUMBER  0xBBBBBBBB
#define MEMBLOCK_ALLOC_MAGICNUMBER2 0xEEEEEEEE

// This header starts 268 bytes before the block pointer that the user gets to work with
struct MyDebugMemBlockFooter
{
	DWORD        magic;		// Magic number so we can ensure this block was actually allocated with our handler
	DWORD        magic2;
	char         file[256];	// File in which this allocation originally occurred in
	int			 line;		// Line on which the allocation originally occurred
	int			 size;		// Size of the memory allocation
};

// For safety we'll override the standard new as well, since everything will
// go through our overridden delete (possible some allocations in the app may be missed,
// or other situations may have made the new macro not work)
/*
void* operator new (unsigned int iSize)
{
	void* mem = malloc(iSize);

	return mem;
}
*/

void* operator new(unsigned int size, char* file, int line)
{
	gMemUsage += size;

	unsigned char* pMem = (unsigned char*)malloc(size + sizeof(MyDebugMemBlockFooter));

	MyDebugMemBlockFooter* pBlock = (MyDebugMemBlockFooter*)(pMem + size);

	pBlock->magic  = MEMBLOCK_ALLOC_MAGICNUMBER;
	pBlock->magic2 = MEMBLOCK_ALLOC_MAGICNUMBER2;
	strncpy(pBlock->file, file, 255);
	pBlock->line = line;
	pBlock->size = size;

	return pMem;
}

void* mymalloc(unsigned int size, char* file, int line)
{
	if (size < 0)
		__asm int 3;

	gMemUsage += size;

	unsigned char* pMem = (unsigned char*)malloc(size + sizeof(MyDebugMemBlockFooter));

	MyDebugMemBlockFooter* pBlock = (MyDebugMemBlockFooter*)(pMem + size);

	pBlock->magic  = MEMBLOCK_ALLOC_MAGICNUMBER;
	pBlock->magic2 = MEMBLOCK_ALLOC_MAGICNUMBER2;
	strncpy(pBlock->file, file, 255);
	pBlock->line = line;
	pBlock->size = size;

	return pMem;
}

#define MEMBLOCK_MAX 10 * 1024 * 1024	// Blocks over 10 megs will fail

bool GetMemBlockInfo(void* pMem, char* file, int* line, int* size)
{
	//int error;
	//size_t sz = _msize(pMem, &error);  // _msize not accurate ???

	// Find our information block by scanning for the magic number
	unsigned char* pPos = (unsigned char*)pMem;

	MyDebugMemBlockFooter* pBlock;

	try
	{
		while(pPos < (unsigned char*)pMem + MEMBLOCK_MAX)
		{
			pBlock = (MyDebugMemBlockFooter*)pPos;
			
			if (pBlock->magic  == MEMBLOCK_ALLOC_MAGICNUMBER  &&
				pBlock->magic2 == MEMBLOCK_ALLOC_MAGICNUMBER2 &&
				pBlock->line > 0 &&
				pBlock->size > 0)
			{
				DWORD pEnd   = (DWORD)pBlock;
				DWORD pStart = (DWORD)pMem;

				// Verify that the size of the block matches the linear distance
				// in memory from the start of the block (leave room for vtable if class)
				if ((pEnd - pStart) > (unsigned int)pBlock->size + 4)
					return false;

				if (file)
					strcpy(file, pBlock->file);

				if (line)
					*line = pBlock->line;

				if (size)
					*size = pBlock->size;

				return true;
			}

			pPos++;
		}
	}
	catch(...)
	{
		return false;
	}

	return false;
}

void DumpMemBlockInfo(void* pMem)
{
	char file[256];
	int  line;
	int  size;

	char sBuf[1024];

	if (GetMemBlockInfo(pMem, file, &line, &size))
	{
		sprintf(sBuf, "%s(%i): Mem Block 0x%x size %i\n", file, line, pMem, size);
		OutputDebugString(sBuf);
	}
	else
	{
		sprintf(sBuf, "Mem Block 0x%x is corrupted or allocated with different mem manager\n", pMem);
		OutputDebugString(sBuf);
	}
}

#else

bool GetMemBlockInfo(void* pMem, char* file, int* line, int* size) { return false; }
void DumpMemBlockInfo(void* pMem) { OutputDebugString("ENABLE_INTERNAL_MEMLEAK_CHECKS must be defined"); }

#endif

#ifdef ENABLE_MEMLEAK_CHECKS

//#include <../crt/src/dbgint.h>		// Contains debug definitions for standard C runtime

// Ripped from ../crt/src/dbgint.h
// This is the block header definition for news and mallocs in the standard debug runtime library
#define nNoMansLandSize 4

typedef struct _CrtMemBlockHeader
{
        struct _CrtMemBlockHeader * pBlockHeaderNext;
        struct _CrtMemBlockHeader * pBlockHeaderPrev;
        char *                      szFileName;
        int                         nLine;
        size_t                      nDataSize;
        int                         nBlockUse;
        long                        lRequest;
        unsigned char               gap[nNoMansLandSize];
        /* followed by:
         *  unsigned char           data[nDataSize];
         *  unsigned char           anotherGap[nNoMansLandSize];
         */
} _CrtMemBlockHeader;

// Given a block of memory allocated by malloc or new this function
// will dump the location of the function in code that allocated it
// to the debugger's debug panel  aml
void _DumpAllocSource(void* pMem)
{
	char buf[1024];
	_CrtMemBlockHeader* pBlockHeader;
	pBlockHeader = (_CrtMemBlockHeader*)(((unsigned char*)pMem) - sizeof(_CrtMemBlockHeader));
	
	sprintf(buf, "%s(%i) : MemDbg: 0x%.8X alloc origin (%i bytes)\n", pBlockHeader->szFileName, pBlockHeader->nLine, pMem, pBlockHeader->nDataSize);
	OutputDebugString(buf);
}

static _CrtMemState gMemState;
static char gMemLogStartFile[1024];
static int  gMemLogStartLine;

void _MemLogStart(char* file, int line)
{
	strcpy(gMemLogStartFile, file);
	gMemLogStartLine = line;

	_CrtMemCheckpoint(&gMemState);
}

void _MemLogEnd(char* file, int line)
{
	char buf[1024];
	sprintf(buf, "%s(%i): Memory leak logging started //////////////////////////////////////////////\n", gMemLogStartFile, gMemLogStartLine);
	OutputDebugString(buf);

	_CrtMemDumpAllObjectsSince(&gMemState);
	_CrtMemDumpStatistics(&gMemState);

	sprintf(buf, "%s(%i): Memory leak logging ended ////////////////////////////////////////////////\n", file, line);
	OutputDebugString(buf);
}

#endif
