#ifndef __EXPORT_SKINEXPORTOPTIONS_H__
#define __EXPORT_SKINEXPORTOPTIONS_H__

#include "../misc/Saveable.h"

class SkinExportOptions: public Saveable
{
public:

	enum
	{
		vVERSION_NUMBER = 0x000B,	
		
		// VERSION HISTORY
		// v4  for m_FileName         aml
		// v5  for m_WarnOnLitVerts   aml
		// v6  for m_DirWarn          aml
		// v7  for LOD export         aml
		// v8  for m_ExportBySkinName aml
		// v9  for option to view usage file after export	spg
		// v10 for default LOD distance setting and m_AllowPropOverrides  aml
		// v11 for m_IgnoreSkelLeaves aml
	};

	enum
	{
		vMAX_LENGTH_SKIN_NAME	= 64,
		vMAX_LENGTH_EXPORT_SET	= 64,
		vMAX_LENGTH_DIRPATH     = 256,
	};

	SkinExportOptions( void );
	~SkinExportOptions( void );

	void SetNumLODLevels(unsigned int nLevels);

	int		m_Version;
	bool	m_ExportVisibleOnly;
	bool	m_ExportSelected;
	bool	m_ExportSelectionSet;
	TSTR	m_SkinName;
	TSTR	m_ExportSet;
	float	m_Scale;
	TSTR    m_DirPath;				// Export directory path  aml
	bool    m_WarnOnLitVerts;
	bool    m_DirWarn;

	bool    m_AlwaysLOD;			// aml   v7  True if MultiRes LOD data should be constructed even if there isn't
									//           currently a MultiRes modifier on the object (one will be added)
	
	float   m_LODLowerLimit;		// aml   v7  Lower LOD limit
	int     m_LODNumLevels;			// aml   v7  Number of LOD levels to export
	bool    m_LODProgressive;		// aml   v7  True if LOD data changes should be exported for each vert
	bool    m_ExportBySkinName;		// aml   v8  True if ExportBySkinName node data field should be used to export
									//           multiple skins in the same file
	bool	m_ViewUsgFile;			// spg	 v9  True if we should view the usage file after export
	bool    m_AllowPropOverrides;	// aml   v10 True if property LOD data should override default export settings
	float*  m_LODDistances;			// aml	 v10 Customly handled array holding m_LODNumLevels elements
	bool    m_IgnoreSkelLeaves;		// aml   v11 Ignore leaf nodes in scene hierarchy when generating skeletal data

	// From Saveable
	int  GetSize();
	void Store(void* data);
	void Retrieve(void* data);
};


class SkinOptionsDlg
{
public:
	void Show( void );
	void Hide( void );	
private:
	HWND m_wnd;	
};

int	GetSizeSkinExportOptions( void );
void GetSkinExportOptions( SkinExportOptions* options );
void SetSkinExportOptions( SkinExportOptions* options );

#endif // __EXPORT_SKINEXPORTOPTIONS_H__