#ifndef __EXPORT_SKELETON_H__
#define __EXPORT_SKELETON_H__

#include <next.h>
#include <export/export.h>

struct PartialAnimSet;

#define ANIMFMTVERSION3

namespace Mth
{
	class Quat;
	class Vector;
}

// This class should be used so that the animation and skin code
// have the same indexing system to get bone information.
class CSkeletonData
{
	bool bIgnoreLeafs;	// True if export should ignore leaf nodes
						// Added so we could get cams to export as 1 node skeletons

	bool bForceOneNode;	// Only one node exists in the skeleton (do not descend children)
	bool bTreatAsRoot;	// The given node to build the skeleton is treated as the root of the skeleton

    enum
    {
        vMAX_NODES = 256
    };

public:
    CSkeletonData( INode* pNode, bool bIgnoreLeafs=true, bool bForceOneNode=false, bool bTreatAsRoot=false );
	CSkeletonData( INode* pNode, INode* ignoreBranch, bool bIgnoreLeafs=true, bool bForceOneNode=false, bool bTreatAsRoot=false );
	int				GetBoneIndex( INode* pNode );
	int				GetBoneIndexNoAssert( INode* pNode );
	INode*			GetBone( int index );
	int				GetCount();
	INode*          GetTrueRootBone( INode* pNode );
	INode*          GetNaturalRootBone( INode* pNode, INode* pHintNode = NULL );
    INode*			GetRootBone( INode* pNode );

public:
	// For export...
    unsigned int    GetChecksum();
	unsigned int	GetBoneName( int index );
	unsigned int	GetParentName( int index );
	unsigned int	GetFlipName( int index );

	// writes the skeleton data packet inside the SKA file:
    int				WriteSKAFormat( FILE* pFile );
	int				WriteSKAFormat( unsigned char* pData );

	// writes the skeleton format to the SKE file:
	int				WriteSKEFormat( FILE* pFile );

	void			GetNeutralPose( int index, Mth::Quat* pQuat, Mth::Vector* pVector );

public:
	// the following is for backwards-compatibility
	// for the animation exporter...  it just calls
	// WriteSKAFormat()...
    int				Write( FILE* pFile );
	int             Write( unsigned char* pData );

	void            AddIgnoreException(INode* node);
	void            BuildSkeleton(INode* pNode);
	void			RemoveNonPartialAnimBones(PartialAnimSet* pPartialAnimSet);
	void			SetPartialAnimState(int boneID, bool bActive = true);
	bool            GetPartialAnimState(int boneID);
	
protected:
    void			recursive_add_node( INode* pNode, bool bParentIgnored = false );
    void			print_name_table();
	void			print_debug_file();
	int             GetNodeDepth(INode* pNode);
	bool            HasChild(INode* pNode, INode* pChildNode);

protected:
    int				m_numNodes;
    INode*			mp_nodes[vMAX_NODES];
	INode*          mp_ignoreExceptions[vMAX_NODES];	// Nodes added to this exception list should always be included
														// even if they reside under the ignoreBranch
	int             m_numExceptions;
	INode*          ignoreBranch;				// If this node is encountered it (and all of it's children) should be ignored
												// unless a child node resides within the exception list
	INode*          pRootNode;
	unsigned int    m_mask[vMAX_NODES / 32];	// Partial animation mask
};

#endif // __EXPORT_SKELETON_H__