/*
	ObjKeyEditor.h
	Per Object Key Editor Window
*/

#ifndef __OBJKEYEDITOR__
#define __OBJKEYEDITOR__

//#include "../UI/ModalDlg.h"
#include "../UI/MSWindow.h"
#include "../Export/ScriptKeyEditor.h"
#include "../UI/TrackUI.h"

class CutsceneObj;

//class ObjKeyEditor: public ModalDlgWindow
class ObjKeyEditor: public MSDlgWindow
{
	TrackUI*         objTrack;					// TrackUI control displaying the cutscene objects cutscne info
	CutsceneObj*     pCutsceneObj;				// The cutscene object that we're setting keys on
	ScriptKeyEditor* pScriptKeyEditor;			// Pointer to script key editor dialog (popup when keys are double-clicked)

	BOOL DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void (*fpKeyChanged)(ObjKeyEditor*,CutsceneObj*,void*);
	void* pKeyChangedData;

	static void KeyActionCB(Link<TrackUIKey>* link, void* pData);
	

	static void KeyTimeChanged(int time, void* pData);
	static void UpdateKeys(ScriptKeyEditor* pEditor, void* pData);
	static void CancelKeyUpdate(ScriptKeyEditor* pEditor, void* pData);
	static void KeyChanged(ScriptKeyEditor* pEditor, Link<TrackUIKey>* link, void* pData);

	static void ctKeyChanged(TrackUI* trackUI, void* pData);

public:
	ObjKeyEditor(HINSTANCE hInstance, HWND hwndParent, CutsceneObj* cso);
	~ObjKeyEditor();

	void SetKeyChangedCB(void (*fp)(ObjKeyEditor*,CutsceneObj*,void*), void* pData);
	void Show();
};

#endif
