/*
	ColorPopup.cpp
	Color popup control for manipulating a group of colors
*/

#include "ColorPopup.h"
#include "PropList.h"
#include "../PropEdit/ParseFuncs.h"
#define CUSTIDC_BUTTON 1
#define DEFAULT_NUM_COLORS  4

ColorPopup::ColorPopup(HINSTANCE hInstance) :
	UIControl(hInstance, CLASS)
{
	Init();
}

ColorPopup::ColorPopup(HINSTANCE hInstance, HWND hwnd) :
	UIControl(hInstance, CLASS)
{
	Init();
	Attach(hwnd);
}

ColorPopup::~ColorPopup()
{
	if (plist)
		delete plist;

	if (hwndButton)
		DestroyWindow(hwndButton);
}

void ColorPopup::Init()
{
	POINT pt;
	GetCursorPos(&pt);

	plist = new PropList(hInstance,hwnd,pt.x,pt.y);

	plist->SetChangeCB(PropChangeCB,this);
	plist->SetApplyCB(PropApplyCB,this);
	plist->AddSliderNum("NumColors",min,max,"Selects the number of color fields in the color list");

	if (numColors == -1)
		numColors = DEFAULT_NUM_COLORS;

	char buf[256];
	_itoa(numColors,buf,10);
	plist->SetValue(0,buf);

	for(int i = 0; i < numColors;i++)
	{
		char bufColorName[256];
		char bufAlphaName[256];
		sprintf(bufColorName,"Color%i",i);
		sprintf(bufAlphaName,"Alpha%i",i);
		plist->AddColor(bufColorName);
		plist->AddSliderNum(bufAlphaName,0,255);
	}

	plist->BuildUI();
}

LRESULT ColorPopup::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_CREATE:

		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case CUSTIDC_BUTTON:
			ProcButton();
			return TRUE;
		}
	}

	return DefWindowProc(hwnd,msg,wParam,lParam);
}

void ColorPopup::BuildControlUI()
{
	RECT winRect;
	GetWindowRect(hwnd,&winRect);

	int width  = winRect.right - winRect.left;
	int height = winRect.bottom - winRect.top;

	hwndButton = CreateWindow("button",
		                      "Colors",
							  WS_CHILD|WS_VISIBLE,
							  0,0,
							  width,
							  height,
							  hwnd,
							  (HMENU)CUSTIDC_BUTTON,
							  hInstance,
							  NULL);
}

void ColorPopup::PropChangeCB(PropList* plist, void* pData)
{
	ColorPopup* pthis = (ColorPopup*)pData;
	CStr propVal;

	plist->GetValue(0,propVal);
	pthis->numColors = atoi(propVal);
}

void ColorPopup::PropApplyCB(PropList* plist, void* pData)
{
	ColorPopup* pthis = (ColorPopup*)pData;
	CStr propVal;

	plist->Hide();
}

void ColorPopup::SetValue(CStr val)
{
	if (val.Length() == 0)
	{
		plist->Clear();
		return;
	}

	numColors = CountChar(val,'/') + 1;

	plist->Clear();
	plist->AddSliderNum("NumColors",min,max,"Selects the number of color fields in the color list");
	
	char buf[256];
	_itoa(numColors,buf,10);
	plist->SetValue(0,buf);

	for(int i = 0;i < numColors; i++)
	{
		char buf[512];
		char bufColor[256];
		char bufAlpha[256];
		int  index;

		GetOption(val,buf,'/',i);
		GetOption(buf,bufColor,'@',0);
		GetOption(buf,bufAlpha,'@',1);

		char bufColorName[256];
		char bufAlphaName[256];
		sprintf(bufColorName,"Color%i",i);
		sprintf(bufAlphaName,"Alpha%i",i);
		
		plist->AddColor(bufColorName);
		index = plist->GetCurIndex();
		plist->SetValue(index,bufColor);

		plist->AddSliderNum(bufAlphaName,0,255);
		index = plist->GetCurIndex();
		plist->SetValue(index,bufAlpha);
	}

	value = val;

	plist->BuildUI();
}

CStr ColorPopup::GetValue()
{
	CStr propVal;

	if (!plist)
		return value;
	
	plist->GetValue(0,propVal);
	
	numColors = atoi(propVal);
	value = "";

	for(int i = 0;i < numColors; i++)
	{
		CStr strColor, strAlpha;

		plist->GetValue(i * 2 + 1, strColor);
		plist->GetValue(i * 2 + 2, strAlpha);

		if (i > 0)
			value += CStr("/");

		value += strColor + CStr("@") + strAlpha;
	}

	return value;
}

void ColorPopup::SetLimits(int min,int max)
{
	this->min = min;
	this->max = max;
}

void ColorPopup::ProcButton()
{
	POINT pt;
	GetCursorPos(&pt);

	plist->SetPos(pt.x,pt.y);

	//PropList(HINSTANCE hInstance,HWND hwdParent=0,int x=0,int y=0,int width=300,int height=263,CStr DlgText="");
	plist->Show();
}
