#ifndef __TRIGGER_TRIGGER_H__
#define __TRIGGER_TRIGGER_H__

#include "TriggerUI.h"
#include <inode.h>

#define vTRIGGER_CLASS_ID Class_ID(0x1de02682, 0x3fe630d1)
#define TRIGGER_OBJ_OFFSET_Z	5

class Trigger;

class TriggerCreateCallBack: public CreateMouseCallBack 
{
  private:
	Trigger *ob;

	int proc(ViewExp *vpt,int msg, int point, int flags, IPoint2 m, Matrix3& mat ); 

  public:
		void SetObj(Trigger *obj) { ob = obj; }
};

extern TriggerCreateCallBack TriggerCreateCB;

class Trigger: public GeomObject, public IParamArray, public TriggerUI
{
  private:
	Mesh 	  mesh;

  public:
	BOOL	suspendSnap;	// just like in SimpleObject
	
	Trigger(void);

	// TriggerUI Interface
	inline void BeginEditParams(IObjParam *ip, ULONG flags, Animatable *prev)
	{ TriggerUI::BeginEditParams(ip,flags,prev); }
	
	inline void EndEditParams(IObjParam *ip, ULONG flags, Animatable *next)
	{ TriggerUI::EndEditParams(ip,flags,next); }
	/////////////////////////

	void RefAdded( RefMakerHandle rm );
	void BuildMesh(TimeValue t) {}	// this is not needed unless we plan to animate it

	// from GeomObject
	Mesh* GetRenderMesh(TimeValue t, INode *inode, View& view, BOOL& needDelete)
	{
		needDelete=FALSE;
		return &mesh;
	}
	PatchMesh* GetRenderPatchMesh(TimeValue t, INode *inode, View& view, BOOL& needDelete)
	{
		return NULL;
	}


	// from Object 
	void GetDeformBBox(TimeValue t, Box3& box, Matrix3 *tm, BOOL useSel )
	{
		BuildMesh(t);
		box = mesh.getBoundingBox(tm);
	}

	int 	IsRenderable(void) 		{ return TRUE; }

	void	InitNodeName(TSTR& s)	{ s = "TRG_"; }

	int IntersectRay(TimeValue t, Ray& ray, float& at, Point3& norm)
	{
		BuildMesh(t);
		return mesh.IntersectRay(ray, at, norm);
	}

	ObjectState Eval(TimeValue t)	{ return ObjectState(this); }


	// from BaseObject
	TCHAR*	GetObjectName(void)	{ return "TriggerObject"; }

	CreateMouseCallBack* GetCreateMouseCallBack(void)
	{
		TriggerCreateCB.SetObj(this);
		return(&TriggerCreateCB);
	}

	int Display(TimeValue t, INode* inode,
		ViewExp *vpt, int flags);

	int HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt)
	{
		Point2 pt( (float)p[0].x, (float)p[0].y );
		HitRegion hitRegion;
		GraphicsWindow *gw = vpt->getGW();	
		BuildMesh(t);
		Matrix3 mat = inode->GetObjectTM(t);
		
#ifdef NO_SCALE
		mat.NoScale();
		float scaleFactor = vpt->NonScalingObjectSize()*vpt->GetVPWorldWidth( mat.GetTrans()) / 360.0f;
		if( scaleFactor != 1.0f )
		{
			mat.Scale( Point3( scaleFactor, scaleFactor, scaleFactor ));
		}
#endif
		gw->setTransform(mat);
		MakeHitRegion(hitRegion, type, crossing, 4, p);
		return mesh.select(gw, inode->Mtls(), &hitRegion, flags & HIT_ABORTONHIT, inode->NumMtls());
	}

	void Snap(TimeValue t, INode* inode, SnapInfo *snap, IPoint2 *p, ViewExp *vpt) 
	{
		if(suspendSnap)	// No snap to ourself while creating!
			return;

		Matrix3 tm = inode->GetObjectTM(t);
		GraphicsWindow *gw = vpt->getGW();
		BuildMesh(t);
		gw->setTransform(tm);
		mesh.snap(gw, snap, p, tm);
	}

	void GetWorldBoundBox(TimeValue t, INode *inode, ViewExp* vpt, Box3& box )
	{
		Matrix3 mat = inode->GetObjectTM(t);
		BuildMesh(t);
		box = mesh.getBoundingBox();
		
#ifdef NO_SCALE
		mat.NoScale();
		float scaleFactor = vpt->NonScalingObjectSize()*vpt->GetVPWorldWidth( mat.GetTrans()) / 360.0f;
		if( scaleFactor != 1.0f )
		{
			mat.Scale( Point3( scaleFactor, scaleFactor, scaleFactor ));
		}
#endif
		box = box * mat;
	}

	void GetLocalBoundBox(TimeValue t, INode *inode,ViewExp* vpt,  Box3& box ) 
	{
		Matrix3 mat(1);

		BuildMesh(t);
		box = mesh.getBoundingBox();
#ifdef NO_SCALE
		mat.NoScale();
		float scaleFactor = vpt->NonScalingObjectSize()*vpt->GetVPWorldWidth( mat.GetTrans()) / 360.0f;
		if( scaleFactor != 1.0f )
		{
			mat.Scale( Point3( scaleFactor, scaleFactor, scaleFactor ));
		}
#endif
		box = box * mat;
	}

	// from ReferenceMaker
	RefResult NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, PartID& partID,RefMessage message)
	{ return REF_SUCCEED; }

	RefTargetHandle Clone(RemapDir &remap = NoRemap())
	{
		return new Trigger;
	}

	// from Animatible
	Class_ID ClassID(void)			{ return vTRIGGER_CLASS_ID; }
	void	GetClassName(TSTR& s)	{ s = "TriggerObject"; }
	void	DeleteThis(void)			{ delete this; }
};

class TriggerClassDesc : public ClassDesc 
{
  public:
	int 	IsPublic(void) 				{ return TRUE; }
	void*	Create(BOOL loading=FALSE) { return new Trigger; }
	const TCHAR* ClassName(void)		{ return "TriggerObject"; }
	SClass_ID SuperClassID(void)		{ return GEOMOBJECT_CLASS_ID; }
	Class_ID ClassID(void)				{ return vTRIGGER_CLASS_ID; }
	const TCHAR* Category(void)		{ return "NExt Helpers"; }
};

#endif // __TRIGGER_TRIGGER_H__
