// NExtTexture.h: Neversoft Extensions Texture
//
//////////////////////////////////////////////////////////////////////

#ifndef __TEXTURE_NEXTTEXTURE_H__
#define __TEXTURE_NEXTTEXTURE_H__

#define NEXT_TEXTURE_CLASS_ID	Class_ID(0x24917044, 0x16692a2a)

#define vMAX_NUM_MIP_LEVELS	6

enum
{
	vMIP_TYPE_NONE,
	vMIP_TYPE_AUTO,
	vMIP_TYPE_MANUAL,
};

enum
{
	vCROP,
	vPLACE,
	vNONE,
};

class INExtTexture
{
public:	
	virtual bool	ShouldCompress( int platform ) = 0;
	virtual	int		GetMipType( int platform ) = 0;	
	virtual bool	UsePS2Mips( int platform ) = 0;

	virtual	int		GetMinFilterMode( void ) = 0;
	virtual	int		GetMagFilterMode( void ) = 0;
	virtual int		GetMipFilterMode( void ) = 0;
	virtual int		GetAddressModeU( void ) = 0;
	virtual int		GetAddressModeV( void ) = 0;
	virtual BitmapInfo*	GetBaseMap( int platform ) = 0;
	virtual BitmapInfo* GetActualBaseMap( int platform ) = 0;
	virtual	BitmapInfo*	GetMipMap( int platform, int level ) = 0;
	virtual void    AssignOverrideTexName( int platform, TSTR name ) = 0;	// aml
	virtual int		GetNumMipLevels( int platform ) = 0;
	virtual bool	ChangeTransColor( void ) = 0;
	virtual Color	GetTransColor( void ) = 0;
	virtual float	GetMipMapK( void ) = 0;
	virtual bool	Force24BitPalette( void ) = 0;
	virtual BOOL    UseBasePal( int platform, int level ) = 0;		// aml
	virtual float   GetCropPlaceU() = 0;
	virtual float   GetCropPlaceV() = 0;
	virtual float   GetCropPlaceW() = 0;
	virtual float   GetCropPlaceH() = 0;
	virtual int     GetCropPlaceMode() = 0;
};
#endif // __TEXTURE_NEXTTEXTURE_H__
