/*
	Targa.h
	This file contains the header information for the TrueVision Targa Format
	Just using this for some quick tests as its much more simplistic than PNG (when uncompressed)
	7-12-01  aml
*/

#ifndef __TARGA__
#define __TARGA__

#pragma pack(push,1)		// Force single-byte alignment
struct TGAHeader
{
	unsigned char  IDLength;
	unsigned char  ColorMapType;
	unsigned char  ImageType;
	unsigned short CMapStart;
	unsigned short CMapLength;
	unsigned char  CMapDepth;
	unsigned short XOffset;
	unsigned short YOffset;
	unsigned short Width;
	unsigned short Height;
	unsigned char  PixelDepth;
	unsigned char  ImageDescriptor;
};
#pragma pack(pop)

// These are the available ImageType's for the Targa format
#define TGATYPE_NODATA       0
#define TGATYPE_RAWPAL       1
#define TGATYPE_RAWTRUECOLOR 2
#define TGATYPE_RAWMONO      3
#define TGATYPE_PAL          9
#define TGATYPE_TRUECOLOR    10
#define TGATYPE_MONO         11

#endif
