/*
	PropUpdater.h
	Property Updater

	The property updater is responsible for updating the properties of all objects within
	the level when property fields are added/deleted
*/

#ifndef __PROPUPDATER__
#define __PROPUPDATER__

#include "ScriptIniParser.h"
#include "max.h"
#include "notify.h"
#include "../UI/ModalDlg.h"
#include "PropBufGen.h"

class ColorListBox;
class ProgressBar;

class PropUpdater: public ModalDlgWindow, public PropBufGen
{
	ColorListBox* plist;
	Interface*    ip;
	HINSTANCE     hInstance;
	HWND          hwndParent;
	ProgressBar*  pProgress;

	CStr GetScriptIniName();
	bool FileIsNewer( char* file1, char* file2 );
	void ProcNode(INode* node);
	int  CountNodes(INode* node,int num);

	static void LoadCB(void* pthis,NotifyInfo* ninfo);

	bool ShouldUpdate();

public:
	PropUpdater(HINSTANCE hInstance, HWND hwndParent, Interface* ip);
	~PropUpdater();

	void ProcChanges();
};

#endif
