/**********************************************************************
 *<
	FILE: NExt.cpp

	DESCRIPTION:	Appwizard generated plugin

	CREATED BY: 

	HISTORY: 

 *>	Copyright (c) 2000, All Rights Reserved.
 **********************************************************************/

#include <Engine/Engine.h>
#include "PropEdit/TestPlug.h"	// AML  (This is temporary, until I get QuadMenu info)
#include "GapTool/GapTool.h"
#include "PropEdit/PropEdit.h"	// AML
#include "NExt.h"

extern TCHAR *GetString(int id);

Interface*  gInterface;
GUP*        gpGUP;			// Pointer to the GUP itself for access to GUP interface methods
PropEditor* pPropEdit;		// This is temporarily global so it can be accessed via a tool plugin
							// this will change when we get info on the QuadMenu system

static	Engine* s_engine;

class NExt : public GUP {
	public:


		static HWND hParams;

		// GUP Methods
		DWORD	Start			( );
		void	Stop			( );
		DWORD	Control			( DWORD parameter );
		
		// Loading/Saving
		IOResult Save(ISave *isave);
		IOResult Load(ILoad *iload);

		
		//Constructor/Destructor

		NExt();
		~NExt();		

		// other
		void RegisterShortcuts();
		void UnregisterShortcuts();
};


class NExtClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() { return TRUE; }
	void *			Create(BOOL loading = FALSE) { return new NExt(); }
	const TCHAR *	ClassName() { return GetString(IDS_CLASS_NAME); }
	SClass_ID		SuperClassID() { return GUP_CLASS_ID; }
	Class_ID		ClassID() { return vNEXT_CLASS_ID; }
	const TCHAR* 	Category() { return GetString(IDS_CATEGORY); }
	char*			GetRsrcString( long id ) { return GetString( id ); }
	const TCHAR*	InternalName() { return _T("NExt"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }				// returns owning module handle

};



static NExtClassDesc NExtDesc;
ClassDesc2* GetNExtDesc() { return &NExtDesc; }

// OBSOLETE in R4   Right click menu for the property editor AML
//static PropsRightMenu* NExt_props_menu;

NExt::NExt()
{

}

NExt::~NExt()
{

}

// Activate and Stay Resident
DWORD NExt::Start( ) 
{
	// TODO: Do plugin initialization here
	gInterface = Max();	

	gpGUP = this;

	// Right click menu system was changed in r4,  need to go through the menu manager
	// to make use of the new QuadMenu system   AML

	// TODO: Update to QuadMenu system
	/*
	IMenuManager* MenuMan=gInterface->GetMenuManager();
	IMenu* Imenu=MenuMan->GetViewportRightClickMenu(kNonePressed)->GetMenu(1);

	Imenu->

	//Imenu->AddItem(IMenuItem*);

	// Add right click menu for the new property editor AML
	NExt_props_menu = new PropsRightMenu;
	gInterface->GetRightClickMenuManager()->Register( NExt_props_menu );
	*/

	RegisterShortcuts();

	pPropEdit= new PropEditor(hInstance,gInterface);

	s_engine = new Engine;

	// TODO: Return if you want remain loaded or not
	return GUPRESULT_KEEP;
}

void NExt::Stop( ) {

	// Unregister created right click menus
	//gInterface->GetRightClickMenuManager()->Unregister( NExt_props_menu );
	//delete NExt_props_menu;

	UnregisterShortcuts();

	// Shutdown the property editor
	delete pPropEdit;

	// TODO: Do plugin un-initialization here	
	delete s_engine;
}

DWORD NExt::Control( DWORD parameter ) {
	return 0;
}

IOResult NExt::Save(ISave *isave)
{
	return IO_OK;
}

IOResult NExt::Load(ILoad *iload)
{
	return IO_OK;
}

void NExt::RegisterShortcuts()
{
	RegTestActionAccelerators();
	RegGapActionAccelerators();
}

void NExt::UnregisterShortcuts()
{
	UnRegTestActionAccelerators();
	UnRegGapActionAccelerators();
}
