#include <windows.h>

bool	IsPowerOfTwo( int value )
{
	int num_bits_set;
	int mask;

	num_bits_set = 0;

	for( mask = 1; mask <= 0x8000000; mask <<= 1 )
	{
		if( mask & value )
		{
			num_bits_set++;
		}
	}
	
	return ( num_bits_set == 1 );
}

int	GetLog2( int value )
{
	int i;

	i = 0;
	if( value > 0 )
	{		
		while( value != 1 )
		{
			value >>= 1;
			i++;
		}

		return i;
	}
	
	return -1;
}

bool FileExists( char* path )
{
	HANDLE file_handle;
	WIN32_FIND_DATA find_data;
	
	file_handle = FindFirstFile( path, &find_data );  
	
	if( file_handle != INVALID_HANDLE_VALUE )
	{
		FindClose( file_handle );
	}
	
	return ( file_handle != INVALID_HANDLE_VALUE );
}

// Is file 2 newer than file one
bool FileIsNewer( char* file1, char* file2 )
{
	HANDLE file_handle_1, file_handle_2;
	WIN32_FIND_DATA find_data_1, find_data_2;
	
	file_handle_1 = FindFirstFile( file1, &find_data_1 );  
	if( file_handle_1 == INVALID_HANDLE_VALUE )
	{
		return true;
	}

	file_handle_2 = FindFirstFile( file2, &find_data_2 );  
	if( file_handle_2 == INVALID_HANDLE_VALUE )
	{
		FindClose( file_handle_1 );
		return false;
	}
	
	FindClose( file_handle_1 );
	FindClose( file_handle_2 );
	return( CompareFileTime( &find_data_2.ftLastWriteTime, &find_data_1.ftLastWriteTime ) > 0 );
}