#include <max.h>
#include <utilapi.h>
#include "resource.h"


#define vPURGE_MATERIALS_CLASS_ID	Class_ID(0x25d23254, 0x1d1e5441)
//#define OLD_PS2_MATERIAL_CLASS_ID	Class_ID(0x18d96f62, 0x141a5329)
//#define OLD_NEXT_MATERIAL_CLASS_ID	Class_ID(0x18d96f62, 0x141a532b)
#define OLD_PS2_MATERIAL_CLASS_ID	Class_ID(0xffffffff, 0x0)
#define OLD_NEXT_MATERIAL_CLASS_ID	Class_ID(0x0, 0xffffffff )

class PurgeMaterials : public UtilityObj 
{
	public:
		IUtil *iu;
		Interface *ip;
		HWND hPanel;

		PurgeMaterials();
		void BeginEditParams(Interface *ip,IUtil *iu);
		void EndEditParams(Interface *ip,IUtil *iu);
		void DeleteThis() {}

		void Init(HWND hWnd);
		void Destroy(HWND hWnd);		
};

static PurgeMaterials s_purge_materials;

class PurgeMaterialsClassDesc:public ClassDesc 
{
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading = FALSE) {return &s_purge_materials;}
	const TCHAR *	ClassName() {return "PurgeMaterials";}
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID		ClassID() {return vPURGE_MATERIALS_CLASS_ID;}
	const TCHAR* 	Category() {return _T("PurgeMaterials");}
	};

static PurgeMaterialsClassDesc purge_materials_cd;
ClassDesc* GetPurgeMaterialsClassDesc() {return &purge_materials_cd;}


static INT_PTR CALLBACK PurgeMaterialsDlgProc(
		HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
	{
	switch (msg) {
		case WM_INITDIALOG:
			s_purge_materials.Init(hWnd);			
			break;
		
		case WM_DESTROY:
			s_purge_materials.Destroy(hWnd);
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam)) 
			{
				case IDC_PURGE_MATERIALS:
				{
					
					MtlBase* mb;
					int i;
					
					MtlBaseLib* lib = s_purge_materials.ip->GetSceneMtls();
					for( i = 0; i < lib->Count(); i++ )
					{
						mb = (*lib)[i];
						if( IsMtl( mb ))
						{
							int j;
							Mtl *m = (Mtl *)mb;

							if( ( m->ClassID() == OLD_PS2_MATERIAL_CLASS_ID ) ||
								( m->ClassID() == OLD_NEXT_MATERIAL_CLASS_ID ))
							{
								//lib->Remove( mb );								
							}
							for( j = 0; j < m->NumSubMtls(); j++ ) 
							{
								Mtl *sm = m->GetSubMtl( j );
								if( sm )
								{
									Class_ID sm_id = sm->ClassID();
									Class_ID old_id = OLD_PS2_MATERIAL_CLASS_ID;
									if( ( sm->ClassID() == OLD_PS2_MATERIAL_CLASS_ID ) ||
										( sm->ClassID() == OLD_NEXT_MATERIAL_CLASS_ID ))
										{
											lib->Remove( sm );
											lib->Remove( mb );
											break;
										}
									//int subm = ( mb->IsMultiMtl() && subMt l<0)?i:subMtl;
									//if (!EnumMaps(sm,subm,tenum)) {
										//return 0;
									//}
								}
							}
							
						}
					}
					//s_purge_materials.iu->CloseUtility();
					break;				
				}
			break;
			}

		case WM_LBUTTONDOWN:
		case WM_LBUTTONUP:
		case WM_MOUSEMOVE:
			s_purge_materials.ip->RollupMouseMessage(hWnd,msg,wParam,lParam); 
			break;

		default:
			return FALSE;
		}
	return TRUE; 
	}

PurgeMaterials::PurgeMaterials()
	{
	iu = NULL;
	ip = NULL;	
	hPanel = NULL;		
	}

void PurgeMaterials::BeginEditParams(Interface *ip,IUtil *iu) 
	{
	this->iu = iu;
	this->ip = ip;
	hPanel = ip->AddRollupPage(
		hInstance,
		MAKEINTRESOURCE(IDD_PURGE_MATERIALS_PANEL),
		PurgeMaterialsDlgProc,
		"PurgeMaterials",
		0);
	}
	
void PurgeMaterials::EndEditParams(Interface *ip,IUtil *iu) 
	{	
	this->iu = NULL;
	this->ip = NULL;
	ip->DeleteRollupPage(hPanel);
	hPanel = NULL;
	}

void PurgeMaterials::Init(HWND hWnd)
	{	
	}

void PurgeMaterials::Destroy(HWND hWnd)
	{	
	}

